/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.dps.model;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import gov.loc.mets.DivType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.StructMapType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class StructMapTree {
    private StructMapNode root;
    private String repPid;
    private int commonRootLength;
    private String repLabel;
    public static final String DIV_TYPE_FILE = "FILE";
    private static final ExLogger log = ExLogger.getExLogger(StructMapTree.class);

    public int getCommonRootLength() {
        return this.commonRootLength;
    }

    public void setCommonRootLength(int commonRootLength) {
        this.commonRootLength = commonRootLength;
    }

    public String getRepPid() {
        return this.repPid;
    }

    public void setRepPid(String repPid) {
        this.repPid = repPid;
    }

    public String getRepLabel() {
        return this.repLabel;
    }

    public void setRepLabel(String label) {
        this.repLabel = label;
    }

    public StructMapNode getRoot() {
        return this.root;
    }

    public void setRoot(StructMapNode root) {
        this.root = root;
    }

    public void addToTree(List<HDeStreamRef> strmRefs) {
        ArrayList<String> fileOriginalPaths = new ArrayList<String>();
        for (HDeStreamRef str : strmRefs) {
            fileOriginalPaths.add(str.getFileOriginalPath());
        }
        String commonRootPath = this.findRoot(fileOriginalPaths);
        commonRootPath = commonRootPath.substring(FilenameUtils.indexOfLastSeparator((String)commonRootPath) + 1, commonRootPath.length());
        this.setRoot(new StructMapNode(commonRootPath));
        for (HDeStreamRef strm : strmRefs) {
            String fOrigPath = strm.getFileOriginalPath();
            String subPath = fOrigPath.substring(this.getCommonRootLength());
            subPath = FilenameUtils.separatorsToWindows((String)subPath);
            String[] path = StringUtils.split((String)subPath, (char)'\\');
            this.addPath(strm, path);
        }
    }

    private void addPath(HDeStreamRef strm, String[] path) {
        StructMapNode node = this.getRoot();
        for (int i = 0; i < path.length - 1; ++i) {
            if (!node.existsInSubFolders(path[i])) {
                node.addToSubFolders(path[i], new StructMapNode(path[i]));
            }
            node = node.getSubFolders().get(path[i]);
        }
        String label = com.exlibris.core.sdk.strings.StringUtils.isEmptyString(strm.getFileName()) ? path[path.length - 1] : strm.getFileName();
        node.addToFiles(strm.getPid(), label);
    }

    private String findRoot(List<String> paths) {
        String common = "";
        Iterator<String> pathIter = paths.iterator();
        if (FilenameUtils.indexOfLastSeparator((String)paths.get(0)) != -1) {
            common = pathIter.next().substring(0, FilenameUtils.indexOfLastSeparator((String)paths.get(0)));
            if (pathIter.hasNext()) {
                String tmpPath = pathIter.next();
                while (true) {
                    if (!tmpPath.startsWith(common)) {
                        if (FilenameUtils.indexOfLastSeparator((String)common) != -1) {
                            common = common.substring(0, FilenameUtils.indexOfLastSeparator((String)common));
                            continue;
                        }
                        if (!com.exlibris.core.sdk.strings.StringUtils.isEmptyString(common)) {
                            common = "";
                        }
                    }
                    if (com.exlibris.core.sdk.strings.StringUtils.isEmptyString(common) || !pathIter.hasNext()) break;
                    tmpPath = pathIter.next();
                }
            }
        }
        if (com.exlibris.core.sdk.strings.StringUtils.isEmptyString(common)) {
            common = File.separator;
            this.setCommonRootLength(common.length() - 1);
        } else {
            this.setCommonRootLength(common.length());
        }
        return common;
    }

    public StructMapType toStructMap(String newSMId) throws Exception {
        StructMapType structMap = StructMapType.Factory.newInstance();
        structMap.setTYPE("LOGICAL");
        structMap.setID(newSMId);
        DivType repDiv = structMap.addNewDiv();
        repDiv.setLABEL(this.getRepLabel());
        DivType topDiv = repDiv.addNewDiv();
        String label = com.exlibris.core.sdk.strings.StringUtils.isEmptyString(this.root.getName()) ? "Table of Contents" : this.root.getName();
        topDiv.setLABEL(label);
        StructMapTree.createStructMapDivs(this.root, topDiv);
        return StructMapTree.createStructMapType(StructMapTree.replaceToStructMapTag(structMap));
    }

    public static String replaceToStructMapTag(StructMapType structMap) {
        return structMap.xmlText().replace("<xml-fragment", "<mets:structMap").replace("</xml-fragment>", "</mets:structMap>");
    }

    private static void createStructMapDivs(StructMapNode structMapNode, DivType currentDiv) {
        HashMap<String, StructMapNode> subFolderList = structMapNode.getSubFolders();
        if (structMapNode.getFiles() != null) {
            for (String pid : structMapNode.getFiles().keySet()) {
                DivType fileLevelDiv = currentDiv.addNewDiv();
                fileLevelDiv.setLABEL(structMapNode.getFiles().get(pid));
                fileLevelDiv.setTYPE(DIV_TYPE_FILE);
                fileLevelDiv.addNewFptr().setFILEID(pid);
            }
        }
        for (String subFolder : subFolderList.keySet()) {
            DivType div1 = currentDiv.addNewDiv();
            div1.setLABEL(subFolder);
            StructMapTree.createStructMapDivs((StructMapNode)subFolderList.get(subFolder), div1);
        }
    }

    public static StructMapType createStructMapType(String value) throws Exception {
        StructMapType smt = null;
        try {
            smt = MetsDocument.Factory.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?><mets xmlns=\"http://www.loc.gov/METS/\" xmlns:mets=\"http://www.loc.gov/METS/\">" + value + "</mets>").getMets().getStructMapArray(0);
            return smt;
        }
        catch (Exception e) {
            log.error("Unable to create Struct Map for representation.", e, new String[0]);
            throw e;
        }
    }

    private class StructMapNode {
        private String name;
        private LinkedHashMap<String, String> files;
        private LinkedHashMap<String, StructMapNode> subFolders;

        public StructMapNode(String folderName) {
            this.name = folderName;
            this.files = new LinkedHashMap();
            this.subFolders = new LinkedHashMap();
        }

        public String getName() {
            return this.name;
        }

        public HashMap<String, String> getFiles() {
            return this.files;
        }

        public void addToFiles(String pid, String label) {
            this.files.put(pid, label);
        }

        public HashMap<String, StructMapNode> getSubFolders() {
            return this.subFolders;
        }

        public void addToSubFolders(String name, StructMapNode folderNode) {
            this.subFolders.put(name, folderNode);
        }

        public boolean existsInSubFolders(String name) {
            return this.subFolders.containsKey(name);
        }
    }
}

