/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITBP
extends TiffProfileClassIT {
    public TiffProfileClassITBP() {
        this._profileText = "TIFF/IT-BP (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        int[] valueVec = tifd.getImageColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesImageColorIndicator(tifd, valueVec)) {
            return false;
        }
        valueVec = tifd.getBackgroundColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        return this.satisfiesBackgroundColorIndicator(tifd, valueVec);
    }
}

