/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.GenericContainerContentIdentifier;
import ch.docuteam.tools.file.MetadataProviderDROID_IdentificationResult;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.DROIDCouldNotInitializeException;
import ch.docuteam.tools.file.exception.DROIDMultipleIdentificationsFoundException;
import ch.docuteam.tools.file.exception.DROIDNoIdentificationFoundException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.RegexFileFilter;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequestFactory;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.container.ole2.Ole2IdentifierEngine;
import uk.gov.nationalarchives.droid.container.zip.ZipIdentifierEngine;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;

public abstract class MetadataProviderDROID {
    private static final String SIGNATURES_FOLDER = "config";
    private static final String SIGNATURE_FILE_NAME_PATTERN = "DROID_SignatureFile_V.*\\.xml";
    private static final String CONTAINER_SIGNATURE_FILE_NAME_PATTERN = "container-signature-.*\\.xml";
    static final String SIGNATURE_FILE_NAME_PREFIX = "DROID_SignatureFile_V";
    static final String SIGNATURE_FILE_NAME_EXTENSION = ".xml";
    static final String CONTAINER_SIGNATURE_FILE_NAME_PREFIX = "container-signature-";
    private static String signatureFile = null;
    private static String containerSignatureFile = null;
    private static final int DEFAULT_EXTENSION_USAGE = 1;
    private static int extensionUsage = 1;
    private static BinarySignatureIdentifier signatureIdentificator = null;
    private static ContainerSignatureDefinitions containerSignatureDefs = null;
    private static List<TriggerPuid> containerSignatureTriggerPuids = null;
    private static Boolean isInitialized = false;

    public static void setSignatureFile(String newSignatureFile) throws FileNotFoundException {
        if (!new File(newSignatureFile).exists()) {
            throw new FileNotFoundException(newSignatureFile);
        }
        Logger.debug("setSignatureFile - newSignatureFile: " + newSignatureFile);
        signatureFile = newSignatureFile;
        isInitialized = false;
    }

    static void forceSignatureFileInitialization() {
        isInitialized = false;
        signatureFile = null;
    }

    static void forceContainerSignatureFileInitialization() {
        isInitialized = false;
        containerSignatureFile = null;
    }

    public static String getSignatureFile() {
        Optional<String> lastestSignatureOptional;
        if (signatureFile == null && (lastestSignatureOptional = MetadataProviderDROID.getLastestFilePath(SIGNATURE_FILE_NAME_PATTERN)).isPresent()) {
            signatureFile = lastestSignatureOptional.get();
        }
        return signatureFile;
    }

    public static String getContainerSignatureFile() {
        Optional<String> lastestSignatureOptional;
        if (containerSignatureFile == null && (lastestSignatureOptional = MetadataProviderDROID.getLastestFilePath(CONTAINER_SIGNATURE_FILE_NAME_PATTERN)).isPresent()) {
            containerSignatureFile = lastestSignatureOptional.get();
        }
        return containerSignatureFile;
    }

    private static Optional<String> getLastestFilePath(String fileNamePattern) {
        Optional<Object> result = Optional.empty();
        File signaturesFolder = ResourceUtil.getResource(SIGNATURES_FOLDER);
        if (signaturesFolder != null && signaturesFolder.exists() && signaturesFolder.isDirectory()) {
            String[] fileArray = signaturesFolder.list((FilenameFilter)new RegexFileFilter(fileNamePattern));
            try {
                Logger.debug("getLastSignature - signaturesFolder: " + signaturesFolder.getCanonicalPath());
                Logger.debug("signatures fileArray length: " + Arrays.stream(fileArray).peek(Logger::debug).count());
            }
            catch (IOException e1) {
                Logger.error("at getLastSignature for signaturesFolder.getCanonicalPath()", e1);
            }
            List<String> signatureFileNames = Arrays.stream(fileArray).map(filePath -> new File((String)filePath).getName()).collect(Collectors.toList());
            if (!signatureFileNames.isEmpty()) {
                Optional<String> lastName = MetadataProviderDROID.sortFileNames(signatureFileNames, SIGNATURE_FILE_NAME_PREFIX, SIGNATURE_FILE_NAME_EXTENSION);
                try {
                    if (lastName.isPresent()) {
                        result = Optional.of(signaturesFolder.getCanonicalPath() + File.separator + lastName.get());
                    }
                }
                catch (IOException e) {
                    Logger.error("at getLastSignature for signaturesFolder.getCanonicalPath()");
                }
            } else {
                Logger.error("No signature file found for pattern: " + fileNamePattern);
            }
        } else {
            Logger.error("Wrong path for: config");
        }
        return result;
    }

    static Optional<String> sortFileNames(List<String> fileNames, String fileNamePrefix, String fileNameSuffix) {
        try {
            Comparator comparator = (s1, s2) -> MetadataProviderDROID.parseVersionNumber(fileNamePrefix, fileNameSuffix, s1).compareTo(MetadataProviderDROID.parseVersionNumber(fileNamePrefix, fileNameSuffix, s2));
            return fileNames.stream().max(comparator);
        }
        catch (Exception e) {
            Logger.error("cannot parse version number from fileNames: " + fileNames);
            return fileNames.stream().max((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        }
    }

    private static Integer parseVersionNumber(String prefix, String suffix, String fileName) {
        String substring = fileName.substring(prefix.length(), fileName.lastIndexOf(suffix));
        return Integer.valueOf(substring);
    }

    public static List<String> getExtensions(String puid) throws DROIDCouldNotInitializeException {
        if (puid == null || puid.trim().isEmpty()) {
            return Collections.emptyList();
        }
        MetadataProviderDROID.initializeIfNecessary();
        return signatureIdentificator.getSigFile().getFileFormat(puid).getExtensions();
    }

    public static Optional<String> getFormatNameOfPUID(String puid) throws DROIDCouldNotInitializeException {
        if (puid == null || puid.trim().isEmpty()) {
            return Optional.empty();
        }
        MetadataProviderDROID.initializeIfNecessary();
        FileFormat ff = signatureIdentificator.getSigFile().getFileFormat(puid);
        if (ff == null) {
            return Optional.empty();
        }
        return Optional.of(ff.getName());
    }

    public static Optional<List<String>> getMIMETypesOfPUID(String puid) throws DROIDCouldNotInitializeException {
        if (puid == null || puid.trim().isEmpty()) {
            return Optional.empty();
        }
        MetadataProviderDROID.initializeIfNecessary();
        FileFormat ff = signatureIdentificator.getSigFile().getFileFormat(puid);
        if (ff == null) {
            return Optional.empty();
        }
        String mimetypes = ff.getMimeType();
        if (mimetypes == null || mimetypes.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Arrays.asList(mimetypes.split("\\s?,\\s?")));
    }

    public static void setContainerSignatureFile(String newContainerSignatureFile) {
        Logger.debug("setContainerSignatureFile - newContainerSignatureFile: " + newContainerSignatureFile);
        containerSignatureFile = newContainerSignatureFile;
        isInitialized = false;
    }

    public static void setExtensionUsage(int levelOfExtensionUsage) {
        extensionUsage = levelOfExtensionUsage;
    }

    public static IdentificationResult getIdentificationResult(String filePath) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        List<IdentificationResult> resultList = MetadataProviderDROID.getIdentificationResults(filePath);
        if (resultList == null || resultList.isEmpty()) {
            throw new DROIDNoIdentificationFoundException(filePath);
        }
        if (resultList.size() != 1) {
            throw new DROIDMultipleIdentificationsFoundException(filePath, resultList);
        }
        return resultList.get(0);
    }

    public static String getFileFormatPUID(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getPuid();
    }

    public static String getMimeType(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        Optional firstMimeTypeOptional;
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        String mimeType = result == null ? null : result.getMimeType();
        Optional<Object> optional = firstMimeTypeOptional = mimeType == null ? Optional.empty() : Stream.of(mimeType.split("\\s?,\\s?")).findFirst();
        if (firstMimeTypeOptional.isPresent()) {
            return (String)firstMimeTypeOptional.get();
        }
        return mimeType;
    }

    public static String getFileFormatName(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getName();
    }

    public static String getFileFormatVersion(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getVersion();
    }

    public static String getFileFormatMethod(String fileName) throws DROIDCouldNotInitializeException, DROIDNoIdentificationFoundException, DROIDMultipleIdentificationsFoundException, FileNotFoundException {
        IdentificationResult result = MetadataProviderDROID.getIdentificationResult(fileName);
        return result == null ? null : result.getMethod().getMethod();
    }

    private static void initializeIfNecessary() throws DROIDCouldNotInitializeException {
        if (isInitialized.booleanValue()) {
            return;
        }
        String tmp = FileUtil.getTempFolder();
        Logger.debug(String.format("Verified java.io.tmpdir: %s", tmp));
        try {
            Logger.debug("Initializing DROID...");
            String signatureFilePath = MetadataProviderDROID.getSignatureFile();
            Logger.debug("signatureFile: " + signatureFilePath);
            String containerSignatureFilePath = MetadataProviderDROID.getContainerSignatureFile();
            Logger.debug("containerSignatureFile: " + containerSignatureFilePath);
            if (!new File(signatureFilePath).exists()) {
                throw new FileNotFoundException(signatureFilePath);
            }
            if (!new File(containerSignatureFilePath).exists()) {
                throw new FileNotFoundException(containerSignatureFilePath);
            }
            signatureIdentificator = new BinarySignatureIdentifier();
            signatureIdentificator.setSignatureFile(signatureFilePath);
            signatureIdentificator.init();
            containerSignatureDefs = new ContainerSignatureSaxParser().parse((InputStream)new FileInputStream(containerSignatureFilePath));
            containerSignatureTriggerPuids = containerSignatureDefs.getTiggerPuids();
            isInitialized = true;
            Logger.debug("...OK");
        }
        catch (Exception ex) {
            Logger.debug("...NOK!");
            throw new DROIDCouldNotInitializeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IdentificationResult> getIdentificationResults(String filePath) throws DROIDCouldNotInitializeException, FileNotFoundException {
        MetadataProviderDROID.initializeIfNecessary();
        if (!new File(filePath).exists()) {
            throw new FileNotFoundException(filePath);
        }
        File file = new File(filePath);
        RequestMetaData metadata = new RequestMetaData(Long.valueOf(file.length()), Long.valueOf(file.lastModified()), file.getName());
        RequestIdentifier id = new RequestIdentifier(file.toURI());
        FileSystemIdentificationRequest request = new FileSystemIdentificationRequest(metadata, id);
        try {
            IdentificationResultCollection finalResultCollection;
            request.open((Object)file.toPath());
            IdentificationResultCollection signatureResultCollection = signatureIdentificator.matchBinarySignatures((IdentificationRequest)request);
            IdentificationResultCollection containerResultCollection = MetadataProviderDROID.getContainerResults((IdentificationRequest)request, signatureResultCollection);
            if (containerResultCollection.getResults().size() > 0) {
                finalResultCollection = containerResultCollection;
            } else if (signatureResultCollection.getResults().size() > 0) {
                finalResultCollection = signatureResultCollection;
            } else {
                switch (extensionUsage) {
                    case 1: {
                        finalResultCollection = signatureIdentificator.matchExtensions((IdentificationRequest)request, false);
                        break;
                    }
                    case 2: {
                        finalResultCollection = signatureIdentificator.matchExtensions((IdentificationRequest)request, true);
                        break;
                    }
                    default: {
                        finalResultCollection = containerResultCollection;
                    }
                }
            }
            signatureIdentificator.removeLowerPriorityHits(finalResultCollection);
            List list = finalResultCollection.getResults();
            return list;
        }
        catch (Exception e) {
            Logger.warn("Exception occured while trying to identify file: " + filePath, e);
            List<IdentificationResult> list = null;
            return list;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ex) {
                Logger.error("at request.close() ", ex);
            }
        }
    }

    private static IdentificationResultCollection getContainerResults(IdentificationRequest request, IdentificationResultCollection results) throws IOException {
        IdentificationResultCollection containerResults = new IdentificationResultCollection(request);
        for (IdentificationResult identResult : results.getResults()) {
            String filePuid = identResult.getPuid();
            if (filePuid == null) continue;
            TriggerPuid containerPuid = null;
            for (TriggerPuid tp : containerSignatureTriggerPuids) {
                if (!tp.getPuid().equals(filePuid)) continue;
                containerPuid = tp;
                break;
            }
            if (containerPuid == null) continue;
            ContainerFileIdentificationRequestFactory requestFactory = new ContainerFileIdentificationRequestFactory();
            String containerType = containerPuid.getContainerType();
            if ("OLE2".equals(containerType)) {
                try {
                    GenericContainerContentIdentifier ole2Identifier = new GenericContainerContentIdentifier();
                    ole2Identifier.init(containerSignatureDefs, containerType);
                    Ole2IdentifierEngine ole2IdentifierEngine = new Ole2IdentifierEngine();
                    ole2IdentifierEngine.setRequestFactory((IdentificationRequestFactory)requestFactory);
                    ole2Identifier.setIdentifierEngine((IdentifierEngine)ole2IdentifierEngine);
                    ole2Identifier.process(request.getSourceInputStream(), containerResults);
                }
                catch (IOException e) {
                    Logger.warn("Couldn't identify OLE2 container in more detail", e);
                }
                continue;
            }
            if ("ZIP".equals(containerType)) {
                try {
                    GenericContainerContentIdentifier zipIdentifier = new GenericContainerContentIdentifier();
                    zipIdentifier.init(containerSignatureDefs, containerType);
                    ZipIdentifierEngine zipIdentifierEngine = new ZipIdentifierEngine();
                    zipIdentifierEngine.setRequestFactory((IdentificationRequestFactory)requestFactory);
                    zipIdentifier.setIdentifierEngine((IdentifierEngine)zipIdentifierEngine);
                    zipIdentifier.process(request.getSourceInputStream(), containerResults);
                }
                catch (IOException e) {
                    Logger.warn("Couldn't identify ZIP container in more detail", e);
                }
                continue;
            }
            throw new IOException("Unknown container type: " + containerPuid);
        }
        IdentificationResultCollection finalContainerResults = new IdentificationResultCollection(request);
        for (IdentificationResult r : containerResults.getResults()) {
            FileFormat ff = signatureIdentificator.getSigFile().getFileFormat(r.getPuid());
            finalContainerResults.addResult((IdentificationResult)new MetadataProviderDROID_IdentificationResult(r, ff));
        }
        return finalContainerResults;
    }

    public static void setContainerSignatureFileWithFallback(String droidContainerFilePath) {
        if (droidContainerFilePath != null && !droidContainerFilePath.isEmpty()) {
            MetadataProviderDROID.forceContainerSignatureFileInitialization();
            Logger.info("    Init droid from droidContainerSignatureFilePath: " + droidContainerFilePath);
            File droidContainerFile = new File(droidContainerFilePath);
            if (!droidContainerFile.exists()) {
                droidContainerFile = ResourceUtil.getResource(droidContainerFilePath);
            }
            if (droidContainerFile != null) {
                MetadataProviderDROID.setContainerSignatureFile(droidContainerFile.getAbsolutePath());
            } else {
                Logger.warn("droidContainerFilePath not found: " + droidContainerFilePath);
            }
        }
    }

    public static void setSignatureFileWithFallback(String droidSignatureFilePath) {
        if (droidSignatureFilePath != null && !droidSignatureFilePath.isEmpty()) {
            MetadataProviderDROID.forceSignatureFileInitialization();
            Logger.info("    Init droid from droidSignatureFilePath: " + droidSignatureFilePath);
            File droidSignatureFile = new File(droidSignatureFilePath);
            if (!droidSignatureFile.exists()) {
                droidSignatureFile = ResourceUtil.getResource(droidSignatureFilePath);
            }
            if (droidSignatureFile != null) {
                try {
                    MetadataProviderDROID.setSignatureFile(droidSignatureFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    Logger.warn("droidSignatureFilePath not found: " + droidSignatureFile.getAbsolutePath(), e);
                }
            } else {
                Logger.warn("droidSignatureFilePath not found: " + droidSignatureFilePath);
            }
        }
    }
}

