/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRolesParameters;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.annotation.emailData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlType;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;

@Entity
@Table(name="HFRUSERROLES")
public class HFrUserRoles
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private Calendar expiryDate;
    private DividedDate expiryDateDummy;
    private HFrUser user;
    private String institution;
    private int roleType;
    private Status status;
    private Calendar statusDate;
    private DividedDate statusDateDummy;
    private String registrationNote;
    private String approvedBy;
    private Calendar approvalDate;
    private String scope;
    private String indexXml;
    private List<HFrUserRolesParameters> userRolesParameters;

    public HFrUserRoles() {
        this.status = Status.NEW;
        this.statusDate = Calendar.getInstance();
        this.setCreateDate(Calendar.getInstance());
        this.setModificationDate(Calendar.getInstance());
        this.setExpiryDate(this.expiryDate);
    }

    public HFrUserRoles(HFrUserRoles userRoles) {
        this.expiryDate = userRoles.getExpiryDate();
        this.expiryDateDummy = userRoles.getExpiryDateDummy();
        this.institution = userRoles.getInstitution();
        this.roleType = userRoles.getRoleType();
        this.status = userRoles.getStatus();
        this.statusDate = userRoles.getStatusDate();
        this.statusDateDummy = userRoles.getStatusDateDummy();
        this.registrationNote = userRoles.getRegistrationNote();
        this.approvedBy = userRoles.getApprovedBy();
        this.approvalDate = userRoles.getApprovalDate();
        this.scope = userRoles.getScope();
    }

    @Column(name="role_type")
    @Searchable
    @Index(name="HFRUSERROLES_ROLETYPE")
    @emailData
    public int getRoleType() {
        return this.roleType;
    }

    public void setRoleType(int type) {
        this.roleType = type;
    }

    @Column(name="expiry_date")
    @Searchable
    public Calendar getExpiryDate() {
        if (this.expiryDate != null && this.expiryDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.expiryDate;
    }

    public void setExpiryDate(Calendar expiryDate) {
        this.expiryDate = expiryDate;
        this.expiryDateDummy = new DividedDate(this.expiryDate);
        this.expiryDate = this.expiryDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getExpiryDateDummy() {
        return this.expiryDateDummy;
    }

    public void setExpiryDateDummy(DividedDate expiryDateDummy) {
        this.expiryDateDummy = expiryDateDummy;
    }

    @ManyToOne(targetEntity=HFrUser.class, optional=false)
    @Index(name="USER_ID_IDX")
    public HFrUser getUser() {
        return this.user;
    }

    public void setUser(HFrUser user) {
        this.user = user;
    }

    @Column(name="institution")
    @Searchable
    @emailData
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    @Column
    @Enumerated
    @Searchable
    @Index(name="HFRUSERROLES_STATUS")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Transient
    public String getUserRoleStatus() {
        return this.status.toString();
    }

    public void setUserRoleStatus(String userRoleStatus) {
        this.status = Status.valueOf(userRoleStatus);
    }

    @Column(name="registration_note", length=2000)
    public String getRegistrationNote() {
        return this.registrationNote;
    }

    public void setRegistrationNote(String registrationNote) {
        this.registrationNote = registrationNote;
    }

    @Column(name="approved_by")
    @Searchable
    public String getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    @Column(name="approval_date")
    public Calendar getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Calendar approvalDate) {
        this.approvalDate = approvalDate;
    }

    @Column(name="status_date")
    public Calendar getStatusDate() {
        if (this.statusDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
        this.statusDateDummy = new DividedDate(this.statusDate);
        this.statusDate = this.statusDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getStatusDateDummy() {
        return this.statusDateDummy;
    }

    public void setStatusDateDummy(DividedDate statusDateDummy) {
        this.statusDateDummy = statusDateDummy;
    }

    @Column(name="internal_note")
    public String getInternalNote() {
        return this.registrationNote;
    }

    public void setInternalNote(String registrationNote) {
        this.registrationNote = registrationNote;
    }

    @Column
    @Searchable
    @emailData
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @OneToMany(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="USERROLE_ID")
    public List<HFrUserRolesParameters> getUserRolesParameters() {
        return this.userRolesParameters;
    }

    public void setUserRolesParameters(List<HFrUserRolesParameters> userRolesParameters) {
        this.userRolesParameters = userRolesParameters;
    }

    public void addUserRolesParameter(HFrUserRolesParameters userRolesParameter) {
        if (this.userRolesParameters == null) {
            this.userRolesParameters = new ArrayList<HFrUserRolesParameters>();
        }
        this.userRolesParameters.add(userRolesParameter);
    }

    public void removeUserRolesParameter(HFrUserRolesParameters userRolesParameter) {
        this.userRolesParameters.remove(userRolesParameter);
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void rebuildIndexXml() {
        Element rootElement = this.generateIndexXmlForObject();
        Element paramaters = DocumentFactory.getInstance().createElement("parameters");
        List<HFrUserRolesParameters> list = this.getUserRolesParameters();
        for (HFrUserRolesParameters hfrParameter : list) {
            Element paramater = DocumentFactory.getInstance().createElement(hfrParameter.getName());
            paramater.setText(hfrParameter.getValue());
            paramaters.add(paramater);
        }
        rootElement.add(paramaters);
        this.setIndexXml(rootElement.asXML());
    }

    private Element generateIndexXmlForObject() {
        Method[] methods = this.getClass().getMethods();
        Element rootElement = DocumentFactory.getInstance().createElement("index");
        for (int i = 0; i < methods.length; ++i) {
            Element subElement = this.generateIndexXmlForMethod(methods[i]);
            if (subElement == null) continue;
            rootElement.add(subElement);
        }
        return rootElement;
    }

    private Element generateIndexXmlForMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!method.isAnnotationPresent(Searchable.class)) {
            return null;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("get")) {
            return null;
        }
        Object returnObject = null;
        try {
            returnObject = method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        if (returnObject == null) {
            return null;
        }
        Element element = DocumentFactory.getInstance().createElement(methodName.substring(3));
        String elementValue = returnObject.toString();
        elementValue = elementValue.toLowerCase().trim();
        element.addText(elementValue);
        return element;
    }

    @XmlType(name="user_roles_status")
    public static enum Status {
        NEW,
        ACTIVE,
        INACTIVE,
        PENDING,
        DELETED;

    }
}

