/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompositionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class InstructionSetBox
extends JP2Box {
    public InstructionSetBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof CompositionBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int ityp = this._module.readUnsignedShort(this._dstrm);
        boolean hasXO_YO = (ityp & 1) != 0;
        boolean hasWid_Ht = (ityp & 2) != 0;
        boolean hasAnimation = (ityp & 8) != 0;
        boolean hasCrop = (ityp & 0x20) != 0;
        int rept = this._module.readUnsignedShort(this._dstrm);
        long tick = this._module.readUnsignedInt(this._dstrm);
        int sizeLeft = (int)this._boxHeader.getDataLength() - 8;
        if ((ityp & 0x2B) == 0) {
            if (sizeLeft != 0) {
                this._repInfo.setMessage((Message)new ErrorMessage("Data underrun in Instruction Set Box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        } else {
            ArrayList<Property> instProps = new ArrayList<Property>(11);
            while (sizeLeft >= 0) {
                if (hasXO_YO) {
                    long xo = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("HorizontalOffset", PropertyType.LONG, (Object)new Long(xo)));
                    long yo = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("VerticalOffset", PropertyType.LONG, (Object)new Long(yo)));
                    sizeLeft -= 8;
                }
                if (hasWid_Ht) {
                    long width = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("Width", PropertyType.LONG, (Object)new Long(width)));
                    long height = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("Height", PropertyType.LONG, (Object)new Long(height)));
                    sizeLeft -= 8;
                }
                if (hasAnimation) {
                    long life = this._module.readUnsignedInt(this._dstrm);
                    boolean persist = (life & Integer.MIN_VALUE) != 0L;
                    instProps.add(new Property("Persist", PropertyType.BOOLEAN, (Object)new Boolean(persist)));
                    instProps.add(new Property("Life", PropertyType.LONG, (Object)new Long(life &= Integer.MAX_VALUE)));
                    long nextuse = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("NextUse", PropertyType.LONG, (Object)new Long(nextuse)));
                    sizeLeft -= 8;
                }
                if (hasCrop) {
                    long xc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("HorizontalCropOffset", PropertyType.LONG, (Object)new Long(xc)));
                    long yc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("VerticalCropOffset", PropertyType.LONG, (Object)new Long(yc)));
                    long wc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("CroppedWidth", PropertyType.LONG, (Object)new Long(wc)));
                    long hc = this._module.readUnsignedInt(this._dstrm);
                    instProps.add(new Property("CroppedHeight", PropertyType.LONG, (Object)new Long(hc)));
                    sizeLeft -= 16;
                }
                if (sizeLeft >= 0) continue;
                this._repInfo.setMessage((Message)new ErrorMessage("Data overrun in Instruction Set Box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        }
        this.finalizeBytesRead();
        return true;
    }
}

