/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils.metsHrefUtils;

import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreUtility;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlHttpUtil;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlLocalUtil;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlUtil;
import com.exlibris.digitool.utils.CSVUtil;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import gov.loc.mets.FileType;
import gov.loc.mets.MetsType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public class HrefUrlUtilFactory {
    public static final String HTTP = "http";

    public static HrefUrlUtil getInstance(String filePath, String sipStreamsPath) throws Exception {
        String[] schemes = new String[]{HTTP, "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (urlValidator.isValid(filePath)) {
            return new HrefUrlHttpUtil(filePath);
        }
        return new HrefUrlLocalUtil(filePath, sipStreamsPath);
    }

    public static List<HrefUrlUtil> getDcStreamList(String xmlDcContent, String sipStreamDir, String streamSource) throws Exception {
        ArrayList<HrefUrlUtil> streams = new ArrayList<HrefUrlUtil>();
        List<DublinCore> dcDocs = DublinCoreUtility.getDublinCores(xmlDcContent);
        if (dcDocs == null) {
            return streams;
        }
        if (streamSource == null) {
            streamSource = "dc:identifier";
        }
        for (DublinCore dcDoc : dcDocs) {
            List locations = dcDoc.getXMLPathValues(streamSource);
            if (locations == null) {
                return streams;
            }
            for (int i = 0; i < locations.size(); ++i) {
                HrefUrlUtil hrefUrlUtil = HrefUrlUtilFactory.getInstance((String)locations.get(i), sipStreamDir);
                streams.add(hrefUrlUtil);
            }
        }
        return streams;
    }

    public static List<HrefUrlUtil> getCsvStreamList(String xmlMetsContent, String sipStreamDir, File contentFile) throws Exception {
        ArrayList<HrefUrlUtil> streams = new ArrayList<HrefUrlUtil>();
        List<String[]> csvList = null;
        boolean isHttp = false;
        Map<String, String> csvRowHash = null;
        csvList = CSVUtil.readFile(contentFile, false);
        String[] csvLabels = csvList.get(0);
        for (int i = 1; i < csvList.size(); ++i) {
            String[] csvRow = csvList.get(i);
            csvRowHash = CSVUtil.convertRowToMap(csvRow, csvLabels);
            String objType = csvRowHash.remove("Object Type");
            if (!objType.equalsIgnoreCase("File")) continue;
            isHttp = false;
            String fileName = HrefUrlUtilFactory.getFileName(csvRowHash);
            String fileLocation = HrefUrlUtilFactory.getFileLocation(csvRowHash);
            String prefix = FilenameUtils.getPrefix((String)fileLocation);
            if ((fileLocation == null || !fileLocation.startsWith(HTTP)) && StringUtils.isEmpty((String)prefix)) continue;
            if (fileLocation.startsWith(HTTP)) {
                isHttp = true;
            }
            fileLocation = !isHttp ? FilenameUtils.normalize((String)fileLocation).concat(fileName) : fileLocation;
            HrefUrlUtil hrefUrlUtil = HrefUrlUtilFactory.getInstance(fileLocation, sipStreamDir);
            streams.add(hrefUrlUtil);
        }
        return streams;
    }

    public static List<HrefUrlUtil> geMetsStreamList(String xmlMetsContent, String sipStreamDir) throws Exception {
        MetsType.FileSec.FileGrp[] fileGrpArray;
        ArrayList<HrefUrlUtil> streams = new ArrayList<HrefUrlUtil>();
        IEParser parser = IEParserFactory.parse(xmlMetsContent);
        for (MetsType.FileSec.FileGrp fileGrp : fileGrpArray = parser.getFileGrpArray()) {
            FileType[] fileArray;
            for (FileType fileType : fileArray = fileGrp.getFileArray()) {
                FileType.FLocat[] flocatArray;
                for (FileType.FLocat flocat : flocatArray = fileType.getFLocatArray()) {
                    String location = flocat.getHref();
                    HrefUrlUtil hrefUrlUtil = HrefUrlUtilFactory.getInstance(location, sipStreamDir);
                    streams.add(hrefUrlUtil);
                }
            }
        }
        return streams;
    }

    public static HrefUrlUtil getHrefsFromFile(File file) {
        return (HrefUrlUtil)new FileToHrefTransformer().transform(file);
    }

    public static String getFileName(Map<String, String> csvRowHash) {
        String fileName = null;
        fileName = !StringUtils.isEmpty((String)csvRowHash.get("File Original Name")) ? csvRowHash.get("File Original Name") : csvRowHash.get("File Name");
        return fileName;
    }

    public static String getFileLocation(Map<String, String> csvRowHash) {
        String fileLocation = null;
        fileLocation = !StringUtils.isEmpty((String)csvRowHash.get("File Original Path")) ? csvRowHash.get("File Original Path") : csvRowHash.get("File Location");
        return fileLocation;
    }

    public static Set<HrefUrlUtil> getHrefsFromFiles(Set<File> files) {
        if (files == null) {
            files = new HashSet<File>();
        }
        HashSet<HrefUrlUtil> res = new HashSet<HrefUrlUtil>(files.size());
        CollectionUtils.collect(files, (Transformer)new FileToHrefTransformer(), res);
        return res;
    }

    private static class FileToHrefTransformer
    implements Transformer {
        private FileToHrefTransformer() {
        }

        public Object transform(Object input) {
            return input == null ? null : new HrefUrlLocalUtil(((File)input).getAbsolutePath(), null);
        }
    }
}

