/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.delivery;

import com.exlibris.core.infra.common.html.HTMLNormalizer;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.dps.sdk.access.Access;
import com.exlibris.dps.sdk.access.AccessFactory;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DeliveryMetadataFieldsUtil {
    public static final String CMS_PREFIX = "CMS.";
    public static final String CMS_SUFFIX_LABEL = " - CMS";
    private static final String OPEN_UL_TAG = "<ul>";
    private static final String CLOSE_UL_TAG = "</ul>";
    private static final String OPEN_LI_TAG = "<li>";
    private static final String CLOSE_LI_TAG = "</li>";
    private static final String SPAN_TAG = "<span title=\"{0}\">{0} </span>";
    private static final String OPEN_TITLE_TAG = "<div class='typeB'><span class='title'><span>";
    private static final String CLOSE_TITLE_TAG = "</span></span></div>";
    private static final String OPEN_LIST_TAG = "<div class='typeC'><table style='table-layout: fixed; width: 100%;' class='formDiv'>";
    private static final String CLOSE_LIST_TAG = "</table></div>";

    public static String getGeneralHtml(String ieMetadataTitle, List<KeyValuePair<String, String>> ieMetadataFields, String fileMetadataTitle, List<KeyValuePair<String, String>> fileMetadataFields) {
        String html = "";
        html = html + DeliveryMetadataFieldsUtil.getTitleHtml(ieMetadataTitle);
        html = html + DeliveryMetadataFieldsUtil.getGeneralHtml("", ieMetadataFields);
        html = html + DeliveryMetadataFieldsUtil.getGeneralHtml(fileMetadataTitle, fileMetadataFields);
        return html;
    }

    public static String getGeneralHtml(String title, List<KeyValuePair<String, String>> metadataFields) {
        String html = "";
        if (metadataFields != null && !metadataFields.isEmpty()) {
            if (StringUtils.isNotBlank((String)title)) {
                html = html + DeliveryMetadataFieldsUtil.getTitleHtml(title);
            }
            html = html + OPEN_LIST_TAG;
            for (KeyValuePair<String, String> metadataField : metadataFields) {
                String value = HTMLNormalizer.htmlNormalize(metadataField.getValue());
                html = html + "<tr><td class='fieldName'>" + HTMLNormalizer.htmlNormalize(metadataField.getKey()) + ": </td><td  class='textAlignLeft paddingLeft' title='" + value + "'>" + value + "</td></tr>";
            }
            html = html + CLOSE_LIST_TAG;
        }
        return html;
    }

    public static String getTitleHtml(String title) {
        return StringUtils.isNotEmpty((String)title) ? OPEN_TITLE_TAG + title + CLOSE_TITLE_TAG : "";
    }

    public static String getIEViewerMetadataHtml(List<KeyValuePair<String, String>> metadataFields) {
        String html = "";
        if (metadataFields != null && !metadataFields.isEmpty()) {
            html = html + OPEN_UL_TAG;
            for (KeyValuePair<String, String> metadataField : metadataFields) {
                html = html + OPEN_LI_TAG;
                html = html + MessageFormat.format(SPAN_TAG, HTMLNormalizer.htmlNormalize(metadataField.getKey() + " : "));
                html = html + MessageFormat.format(SPAN_TAG, HTMLNormalizer.htmlNormalize(metadataField.getValue()));
                html = html + CLOSE_LI_TAG;
            }
            html = html + CLOSE_UL_TAG;
        }
        return html;
    }

    public static DublinCore getDublinCore(String dvs, String pid) throws Exception {
        Access access = AccessFactory.create();
        DublinCore dcDoc = null;
        if (!DeliveryMetadataFieldsUtil.isFilePid(pid)) {
            IEParser ieParser = access.getIEByDVS(dvs);
            dcDoc = ieParser.getIeDublinCore();
        } else {
            List<HDeMetadata> metadataList = access.getFileMetadatasByDVS(dvs, pid);
            if (metadataList != null) {
                for (HDeMetadata metadata : metadataList) {
                    if (metadata.getMdId() != 2) continue;
                    String fileDcXml = metadata.getValue();
                    dcDoc = DublinCoreFactory.getInstance().createDocument(fileDcXml);
                    break;
                }
            }
        }
        return dcDoc;
    }

    public static boolean isFilePid(String pid) {
        return pid != null && pid.toUpperCase().startsWith("FL");
    }
}

