/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.filter;

import com.exlibris.core.infra.common.util.GeneralServerUtil;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.ws.RestrictedIPChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class WebServiceFilter
implements Filter {
    final String HTTP = "http";
    final String HTTPS = "https";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int idx = ((HttpServletRequest)request).getRequestURI().toString().lastIndexOf("/");
        String serviceName = ((HttpServletRequest)request).getRequestURI().toString().substring(idx + 1);
        Boolean hasAccess = RestrictedIPChecker.getInstance().checkAccess(request.getRemoteAddr(), serviceName);
        if (!hasAccess.booleanValue()) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        String queryString = ((HttpServletRequest)request).getQueryString();
        boolean sslRequest = false;
        if (queryString != null && queryString.toLowerCase().contains("wsdl")) {
            String uri = ((HttpServletRequest)request).getRequestURI().toString();
            if (uri.contains("/dpsws/repository") && !GeneralServerUtil.serverHasRepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to repository web services.");
                return;
            }
            if (uri.contains("/dpsws/backoffice") && !GeneralServerUtil.serverHasRepRole() && !GeneralServerUtil.serverHasDepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to backoffice web services.");
                return;
            }
            if (uri.contains("/dpsws/deposit") && !GeneralServerUtil.serverHasDepRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to deposit web services.");
                return;
            }
            if (uri.contains("/dpsws/delivery") && !GeneralServerUtil.serverHasDelRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to delivery web services.");
                return;
            }
            if (uri.contains("/dpsws/permanent") && !GeneralServerUtil.serverHasPerRole()) {
                ((HttpServletResponse)response).sendError(404, "Server is not allowed access to permanent web services.");
                return;
            }
        }
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.rep")) && GeneralServerUtil.serverHasRepRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.rep.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.del")) && GeneralServerUtil.serverHasDelRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.del.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.dep")) && GeneralServerUtil.serverHasDepRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.dep.host"))) {
            sslRequest = true;
        } else if ("https".equals(GlobalProperties.getInstance().getProperty("protocol.per")) && GeneralServerUtil.serverHasPerRole() && StringUtils.contains((String)url, (String)GlobalProperties.getInstance().getProperty("load.balancer.per.host"))) {
            sslRequest = true;
        }
        if (sslRequest) {
            HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper((HttpServletRequest)request){

                public StringBuffer getRequestURL() {
                    StringBuffer originalUrl = ((HttpServletRequest)this.getRequest()).getRequestURL();
                    if (!"https".equals(this.getRequest().getScheme())) {
                        return new StringBuffer(originalUrl.toString().replace("http", "https"));
                    }
                    return originalUrl;
                }
            };
            chain.doFilter((ServletRequest)wrapped, response);
        } else if (((HttpServletRequest)request).getHeader("soapAction") != null || ((HttpServletRequest)request).getHeader("soapaction") != null) {
            HttpServletRequestWrapper wrapped = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getHeader(String name) {
                    if (name.toLowerCase().equals("soapaction")) {
                        return "";
                    }
                    return ((HttpServletRequest)this.getRequest()).getHeader(name);
                }

                public Enumeration getHeaders(String name) {
                    Enumeration headerNames = this.getHeaderNames();
                    ArrayList<String> list = new ArrayList<String>();
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        if (headerName.toLowerCase().equals("soapaction") || !headerName.toLowerCase().equals(name.toLowerCase())) continue;
                        list.add(this.getHeader(headerName));
                    }
                    Enumeration en = Collections.enumeration(list);
                    return en;
                }

                public Enumeration getHeaderNames() {
                    Enumeration headerNames = ((HttpServletRequest)this.getRequest()).getHeaderNames();
                    ArrayList<String> list = new ArrayList<String>();
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        if (headerName.toLowerCase().equals("soapaction")) continue;
                        list.add(headerName);
                    }
                    Enumeration en = Collections.enumeration(list);
                    return en;
                }
            };
            chain.doFilter((ServletRequest)wrapped, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

