/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.flatobjects;

import com.exlibris.core.infra.model.HDpFieldMode;
import com.exlibris.core.infra.model.HDpFormField;
import com.exlibris.core.infra.svc.api.flatobjects.AbstractFlatObject;
import com.exlibris.core.infra.svc.api.utils.FormBuilderUtilitiesApi;
import com.exlibris.core.web.page.xmlbeans.XButton;
import java.util.List;

public class PageButton
extends AbstractFlatObject {
    private boolean positiveAction = true;
    private int position;
    private String urlTemplate;
    private HDpFormField comboBox;
    private List<HDpFieldMode> modes;
    private boolean newWindow = false;

    public List<HDpFieldMode> getModes() {
        return this.modes;
    }

    public void setModes(List<HDpFieldMode> modes) {
        this.modes = modes;
    }

    public PageButton() {
    }

    public PageButton(String label, boolean positiveAction) {
        this.setLabel(label);
        this.positiveAction = positiveAction;
    }

    public boolean isPositiveAction() {
        return this.positiveAction;
    }

    public void setPositiveAction(boolean positiveAction) {
        this.positiveAction = positiveAction;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    @Override
    protected String getDefaultCssClass() {
        return null;
    }

    public HDpFormField getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(HDpFormField comboBox) {
        this.comboBox = comboBox;
    }

    @Override
    public void initFlatObject(Object o) {
        XButton xButton = (XButton)o;
        if (xButton != null) {
            this.setPosition(xButton.getButtonPosition().intValue());
            if (!xButton.isSetPositiveAction()) {
                this.setPositiveAction(true);
            } else {
                this.setPositiveAction(xButton.getPositiveAction());
            }
            this.setUrlTemplate(xButton.getUrlTemplate());
            if (this.urlTemplate != null && xButton.isSetNewWindow()) {
                this.newWindow = xButton.getNewWindow();
            }
            this.setComboBox(FormBuilderUtilitiesApi.initHDpFormField(xButton.getXComboField(), 2));
            this.setModes(FormBuilderUtilitiesApi.getFieldModes(xButton.getXFieldModes()));
            this.setLabel(xButton.getLabel());
            this.setCssClass(xButton.getCssClass());
            this.setRolesInclude(xButton.getRoles());
            this.setVisible(xButton.getVisible());
        }
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }
}

