/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.common.streams.EncodingUtil;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import com.exlibris.core.infra.svc.api.AuthenticationManager;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.UserManager;
import com.exlibris.core.infra.svc.api.authentication.AuthenticationProfileManager;
import com.exlibris.core.infra.svc.api.authentication.ExlSAMLBootstrap;
import com.exlibris.core.infra.svc.api.authentication.JwtUtil;
import com.exlibris.core.infra.svc.api.authentication.SamlUtil;
import com.exlibris.core.infra.svc.api.config.PrivilegeCacheManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import com.exlibris.core.infra.svc.api.security.AbstractServerLoginModule;
import com.exlibris.core.infra.svc.api.security.GenericCallback;
import com.exlibris.core.infra.svc.api.security.RemoteAuthenticationException;
import com.exlibris.core.infra.svc.api.security.SecurityHash;
import com.exlibris.core.infra.svc.api.security.SimpleGroup;
import com.exlibris.core.infra.svc.api.security.SimplePrincipal;
import com.exlibris.core.infra.svc.api.utils.AuthenticationUtil;
import com.exlibris.core.infra.svc.api.utils.UserData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.acl.Group;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JaasSecurityModule
extends AbstractServerLoginModule {
    private static final ExLogger logger = ExLogger.getExLogger(JaasSecurityModule.class);
    private Principal identity;
    private char[] credential;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private String DPSUserName = null;
    private String pdsHandle = null;
    private String userGroups = "";
    private String DPSUserInstitution = null;
    private boolean ignorePasswordCase;
    private Common.AuthenticationMode authenticationMode;
    private static final long TIME_SKEW = 30000L;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            this.hashCharset = (String)options.get("hashCharset");
        }
        String flag = (String)options.get("ignorePasswordCase");
        this.ignorePasswordCase = Boolean.valueOf(flag);
    }

    @Override
    public boolean logout() throws LoginException {
        return super.logout();
    }

    @Override
    public boolean abort() throws LoginException {
        return super.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            return super.commit();
        }
        catch (Throwable t) {
            t.getMessage();
            t.printStackTrace();
            throw new LoginException(t.getMessage());
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        boolean authenticated = false;
        try {
            Callback[] calls = new Callback[]{new NameCallback("name"), new PasswordCallback("Password", false), new GenericCallback("authentication_mode"), new GenericCallback("authenticationParameters")};
            this.callbackHandler.handle(calls);
            if (":JwtAuthentication:".equals(((NameCallback)calls[0]).getName())) {
                return this.validateJwt(calls);
            }
            if (":BasicAuthentication:".equals(((NameCallback)calls[0]).getName())) {
                return this.validateBasic(calls);
            }
            this.authenticationMode = (Common.AuthenticationMode)((Object)((GenericCallback)calls[2]).getValue());
            switch (this.authenticationMode) {
                case PDS: {
                    authenticated = this.handlePdsLogin(calls);
                    break;
                }
                case LOCAL: {
                    authenticated = this.handleLocalLogin(calls);
                    break;
                }
                case SAML: {
                    authenticated = this.handleSamlLogin(calls);
                }
            }
        }
        catch (RemoteAuthenticationException e) {
            logger.error("Failed Remote Authentication", e, new String[0]);
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed authentication", e, new String[0]);
        }
        return authenticated;
    }

    private boolean validateJwt(Callback[] calls) throws RemoteAuthenticationException {
        boolean authenticated = false;
        String jwtToken = String.valueOf(((PasswordCallback)calls[1]).getPassword());
        boolean isRemoteReport = "remotereports".equals(((GenericCallback)calls[2]).getValue());
        Map parameters = (Map)((GenericCallback)calls[3]).getValue();
        UserPrincipal userPrincipal = JwtUtil.parseJwtToken(jwtToken, (String)parameters.get("userIp"), isRemoteReport);
        if (isRemoteReport) {
            this.checkRemoteReportsUser(userPrincipal);
        }
        if (userPrincipal != null) {
            this.identity = userPrincipal;
            this.DPSUserName = userPrincipal.getUserName();
            this.DPSUserInstitution = userPrincipal.getInstitutionCode();
            this.augmentUserPrincipal();
            this.loginOk = true;
            authenticated = true;
        }
        return authenticated;
    }

    private boolean validateBasic(Callback[] calls) throws RemoteAuthenticationException {
        boolean authenticated = false;
        String password = String.valueOf(((PasswordCallback)calls[1]).getPassword());
        UserData userData = AuthenticationUtil.getUserDataByHeader(password);
        if (userData != null) {
            HFrUser user = userData.getUser();
            HFrInstitution institution = userData.getInstitution();
            UserPrincipal userPrincipal = new UserPrincipal(user.getUserName());
            userPrincipal.setInstitutionPath(institution.getPath());
            userPrincipal.setInstitutionCode(institution.getCode());
            userPrincipal.setUserDetails(user);
            userPrincipal.setUserName(user.getUserName());
            userPrincipal.setPrivileges(new ArrayList<String>(userData.getPrivileges()));
            if (userPrincipal != null) {
                this.identity = userPrincipal;
                this.DPSUserName = userPrincipal.getUserName();
                this.DPSUserInstitution = userPrincipal.getInstitutionCode();
                this.augmentUserPrincipal();
                this.loginOk = true;
                authenticated = true;
            }
        }
        return authenticated;
    }

    private void checkRemoteReportsUser(UserPrincipal userPrincipal) throws RemoteAuthenticationException {
        if (userPrincipal != null) {
            if (!"remotereports".equals(userPrincipal.getUserName())) {
                throw new RemoteAuthenticationException("Invalid Remote Report User", 401);
            }
            GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            boolean enableRemoteReportsUser = Boolean.valueOf(generalParameterManager.getParameter("authentication", "enable_remote_reports_user"));
            if (!enableRemoteReportsUser) {
                throw new RemoteAuthenticationException("Remote Report is not Allowed", 403);
            }
        } else {
            throw new RemoteAuthenticationException("Invalid Remote Report Token", 401);
        }
    }

    private boolean handleSamlLogin(Callback[] calls) throws Exception {
        HFrUser userByName;
        AuthenticationProfileManager authenticationProfileManager = (AuthenticationProfileManager)ServiceLocator.getInstance().lookUp(AuthenticationProfileManager.class);
        String name = ((NameCallback)calls[0]).getName();
        String samlRequestId = StringUtils.substringBefore((String)name, (String)"-institutionCode-");
        this.DPSUserInstitution = StringUtils.substringAfter((String)name, (String)"-institutionCode-");
        Map authenticationParameters = (Map)((GenericCallback)calls[3]).getValue();
        String samlProfileName = (String)authenticationParameters.get("authenticationProfile");
        String samlResponse = String.valueOf(((PasswordCallback)calls[1]).getPassword());
        if (StringUtils.isBlank((String)samlResponse) && ":ChangeInstitution:".equals(samlRequestId)) {
            this.DPSUserName = UserPrincipalRetriever.getUserPrincipal().getUserName();
            this.pdsHandle = UserPrincipalRetriever.getUserPrincipal().getPdsHandle();
        } else {
            try {
                UserManager userManager;
                HFrUser user;
                String strAttributeValue;
                int y;
                List attributeValues;
                String attrFriendlyName;
                String attrName;
                int x;
                List attributes;
                List attributeStatements;
                Signature signature;
                ExlSAMLBootstrap.bootstrap();
                Map<String, String> samlProfileParameters = authenticationProfileManager.getAuthenticationProfileParameters(samlProfileName);
                String userIdAttributeName = null;
                String userGroupAttributeName = null;
                String userIDLocation = samlProfileParameters.get("userIDLocation");
                String userGroupLocation = samlProfileParameters.get("userGroupLocation");
                if ("attribute".equals(userIDLocation)) {
                    userIdAttributeName = samlProfileParameters.get("attributeName");
                }
                if ("attribute".equals(userGroupLocation)) {
                    userGroupAttributeName = samlProfileParameters.get("groupAttributeName");
                }
                BasicParserPool ppMgr = new BasicParserPool();
                ppMgr.setNamespaceAware(true);
                Response response = null;
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(Base64.decode((String)samlResponse));
                    Document doc = ppMgr.parse((InputStream)in);
                    Element metadataRoot = doc.getDocumentElement();
                    UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
                    Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(metadataRoot);
                    response = (Response)unmarshaller.unmarshall(metadataRoot);
                }
                catch (Exception e) {
                    logger.error("Failed to parse SAML response", e, new String[0]);
                    return false;
                }
                if (response == null) {
                    logger.error("Failed to parse SAML response", new String[0]);
                    return false;
                }
                if (!StringUtils.equalsIgnoreCase((String)samlProfileParameters.get("IdPIssuer"), (String)response.getIssuer().getValue())) {
                    logger.error("Issuer " + response.getIssuer().getValue() + " doesn't match IDP Issuer on SAML proflile " + samlProfileParameters.get("IdPIssuer"), new String[0]);
                    return false;
                }
                if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
                    logger.error("Wrong Response Status Code '" + response.getStatus().getStatusCode().getValue() + "'", new String[0]);
                    return false;
                }
                if (StringUtils.isNotEmpty((String)samlRequestId) && !StringUtils.equals((String)samlRequestId, (String)"null") && (response.getInResponseTo() == null || StringUtils.isEmpty((String)response.getInResponseTo().toString()) || !response.getInResponseTo().toString().startsWith(samlRequestId))) {
                    logger.error("Response 'InResponsTo' value  '" + response.getInResponseTo() + "' does not match request ID '" + samlRequestId + "'", new String[0]);
                    return false;
                }
                KeyStore idpKeyStore = SamlUtil.getIdpKeyStore(samlProfileName);
                String rosettaCertificateVersion = samlProfileParameters.get("rosettaCertificateVersion");
                KeyStore rosettaKeyStore = SamlUtil.getRosettaKeyStore(rosettaCertificateVersion);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                Assertion assertion = null;
                if (response.getEncryptedAssertions() != null && !response.getEncryptedAssertions().isEmpty()) {
                    RSAPrivateKey privateKey = (RSAPrivateKey)rosettaKeyStore.getKey("rosetta saml_jks", "p5909206323797881374".toCharArray());
                    BasicX509Credential decryptionCredential = new BasicX509Credential();
                    decryptionCredential.setPrivateKey((PrivateKey)privateKey);
                    Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)decryptionCredential), (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
                    decrypter.setRootInNewDocument(true);
                    try {
                        assertion = decrypter.decrypt((EncryptedAssertion)response.getEncryptedAssertions().get(0));
                    }
                    catch (Exception de) {
                        logger.error("Assertion decryption failed", de, new String[0]);
                        return false;
                    }
                } else if (response.getAssertions() != null && !response.getAssertions().isEmpty()) {
                    assertion = (Assertion)response.getAssertions().get(0);
                } else {
                    logger.error(" No assertions were found", new String[0]);
                    return false;
                }
                String serverUrl = (String)authenticationParameters.remove("serverUrl");
                String recipientExl = URI.create(serverUrl + "/pdsHandleLogin").normalize().toString();
                String audienceExl = SamlUtil.getIssuerUrl();
                DateTime notBefore = null;
                DateTime notAfter = null;
                if (assertion.getConditions() != null) {
                    String audienceIdp;
                    notBefore = assertion.getConditions().getNotBefore();
                    notAfter = assertion.getConditions().getNotOnOrAfter();
                    DateTime nowDate = new DateTime();
                    String nowReadble = nowDate.toString();
                    if (notBefore == null || notAfter == null || notBefore.isAfterNow() || notAfter.isEqualNow() || notAfter.isBeforeNow()) {
                        DateTime dateTime = notBefore = notBefore != null ? new DateTime(notBefore.getMillis() - 30000L) : null;
                        if (notBefore != null && notBefore.isAfterNow()) {
                            this.log.error("Conditions timestamp is still not valid after adding tolerance - current time is out of range.  Assertion is valid only between " + notBefore + " and " + notAfter + " . Current time is " + nowReadble, new String[0]);
                            return false;
                        }
                    }
                    if (!StringUtils.isEmpty((String)(audienceIdp = ((Audience)((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0)).getAudienceURI())) && !SamlUtil.matchUrls(audienceExl, audienceIdp)) {
                        logger.error("Conditions audience URI " + audienceIdp + " does not match Rosetta server URL " + audienceExl, new String[0]);
                        return false;
                    }
                }
                if (assertion.getAuthnStatements() != null && !assertion.getAuthnStatements().isEmpty()) {
                    for (AuthnStatement authnStatment : assertion.getAuthnStatements()) {
                        notAfter = authnStatment.getSessionNotOnOrAfter();
                        if (notAfter == null || !notAfter.isEqualNow() && !notAfter.isBeforeNow()) continue;
                        logger.error("AuthnStatement timestamp has expired. IDP timestamp notAfter " + notAfter, new String[0]);
                        return false;
                    }
                } else {
                    logger.error("Missing AuthnStatement", new String[0]);
                    return false;
                }
                if (assertion.getSubject().getSubjectConfirmations() != null && !assertion.getSubject().getSubjectConfirmations().isEmpty()) {
                    notAfter = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getNotOnOrAfter();
                    if (notAfter != null && (notAfter.isEqualNow() || notAfter.isBeforeNow())) {
                        logger.error("Subject Confirmation timestamp has expired. IDP timestamp notAfter " + notAfter, new String[0]);
                        return false;
                    }
                    String recipientIdp = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getRecipient();
                    if (!SamlUtil.matchUrls(recipientExl, recipientIdp)) {
                        logger.error("Subject Recipient " + recipientIdp + " does not match Rosetta server URL recipient " + recipientExl, new String[0]);
                        return false;
                    }
                }
                Signature signature2 = signature = assertion.isSigned() ? assertion.getSignature() : response.getSignature();
                if (signature == null) {
                    logger.error("Missing signature.", new String[0]);
                    return false;
                }
                X509Certificate certificate = null;
                boolean isCertificateFromResponse = false;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                if (signature.getKeyInfo() != null) {
                    String idpCert = "-----BEGIN CERTIFICATE-----\n" + ((org.opensaml.xml.signature.X509Certificate)((X509Data)signature.getKeyInfo().getX509Datas().get(0)).getX509Certificates().get(0)).getValue() + "\n" + "-----END CERTIFICATE-----";
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(idpCert.getBytes());
                    certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                    ((InputStream)inputStream).close();
                    isCertificateFromResponse = true;
                } else {
                    certificate = (X509Certificate)idpKeyStore.getCertificate("idp saml_jks");
                }
                if (certificate == null) {
                    logger.error(" No 'Certificate' was found in the SAML response, Nor in profile", new String[0]);
                    return false;
                }
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(certificate.getPublicKey().getEncoded());
                PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
                BasicX509Credential publicCredential = new BasicX509Credential();
                publicCredential.setPublicKey(publicKey);
                SignatureValidator signatureValidator = new SignatureValidator((Credential)publicCredential);
                try {
                    signatureValidator.validate(signature);
                }
                catch (ValidationException ve) {
                    logger.error("Signature is not valid", (Exception)((Object)ve), new String[0]);
                    return false;
                }
                if (isCertificateFromResponse) {
                    try {
                        PKIXParameters params = new PKIXParameters(idpKeyStore);
                        params.setRevocationEnabled(false);
                        CertPath certPath = certificateFactory.generateCertPath(SamlUtil.getCertificateList(idpKeyStore, certificate));
                        CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
                        certPathValidator.validate(certPath, params);
                    }
                    catch (Exception e) {
                        logger.error("Certificate is not valid", e, new String[0]);
                        return false;
                    }
                }
                if (assertion.getAuthnStatements() != null && assertion.getAuthnStatements().get(0) != null) {
                    String sessionIndex = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
                    authenticationParameters.put("SAMLIdpSessionIndex", sessionIndex);
                }
                if (assertion.getSubject() != null & assertion.getSubject().getNameID() != null) {
                    String nameId = assertion.getSubject().getNameID().getValue();
                    String idpIssuer = assertion.getSubject().getNameID().getNameQualifier();
                    authenticationParameters.put("SAMLIdpNameId", nameId);
                    authenticationParameters.put("SAMLIdpNameIdNameQualifier", idpIssuer);
                }
                authenticationParameters.put("rosettaCertificateVersion", rosettaCertificateVersion);
                if (StringUtils.isEmpty((String)userIdAttributeName)) {
                    if (assertion.getSubject().getNameID() == null && StringUtils.isBlank((String)assertion.getSubject().getNameID().getValue())) {
                        logger.error("NameIdentifier element is not found in assertion", new String[0]);
                        return false;
                    }
                    this.DPSUserName = assertion.getSubject().getNameID().getValue();
                } else {
                    attributeStatements = assertion.getAttributeStatements();
                    if (attributeStatements != null && !attributeStatements.isEmpty()) {
                        for (int i = 0; i < attributeStatements.size(); ++i) {
                            attributes = ((AttributeStatement)attributeStatements.get(i)).getAttributes();
                            for (x = 0; x < attributes.size(); ++x) {
                                attrName = ((Attribute)attributes.get(x)).getName();
                                attrFriendlyName = ((Attribute)attributes.get(x)).getFriendlyName();
                                attributeValues = ((Attribute)attributes.get(x)).getAttributeValues();
                                for (y = 0; y < attributeValues.size(); ++y) {
                                    strAttributeValue = ((XMLObject)attributeValues.get(y)).getDOM().getTextContent();
                                    if (!StringUtils.equalsIgnoreCase((String)userIdAttributeName, (String)attrName) && !StringUtils.equalsIgnoreCase((String)userIdAttributeName, (String)attrFriendlyName) || attributeValues.size() != 1) continue;
                                    this.DPSUserName = strAttributeValue;
                                }
                            }
                        }
                    }
                    if (StringUtils.isBlank((String)this.DPSUserName)) {
                        logger.error("Cannot find 'User ID Attribute Name' value. User Id attribute name in SAML profile '" + userIdAttributeName + "'", new String[0]);
                        return false;
                    }
                }
                if (StringUtils.isNotEmpty((String)userGroupAttributeName) && (attributeStatements = assertion.getAttributeStatements()) != null && !attributeStatements.isEmpty()) {
                    for (int i = 0; i < attributeStatements.size(); ++i) {
                        attributes = ((AttributeStatement)attributeStatements.get(i)).getAttributes();
                        for (x = 0; x < attributes.size(); ++x) {
                            attrName = ((Attribute)attributes.get(x)).getName();
                            attrFriendlyName = ((Attribute)attributes.get(x)).getFriendlyName();
                            attributeValues = ((Attribute)attributes.get(x)).getAttributeValues();
                            for (y = 0; y < attributeValues.size(); ++y) {
                                strAttributeValue = ((XMLObject)attributeValues.get(y)).getDOM().getTextContent();
                                if (!StringUtils.equalsIgnoreCase((String)userGroupAttributeName, (String)attrName) && !StringUtils.equalsIgnoreCase((String)userGroupAttributeName, (String)attrFriendlyName) || attributeValues.size() <= 0) continue;
                                this.userGroups = this.userGroups + strAttributeValue + ",";
                            }
                        }
                    }
                }
                if ((user = (userManager = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class)).getUserByUniqueName(authenticationProfileManager.getAuthenticationProfile(samlProfileName), this.DPSUserName)) == null) {
                    logger.error("'" + this.DPSUserName + "' is not an authorized user", new String[0]);
                    return false;
                }
                this.DPSUserName = user.getUserName();
            }
            catch (Exception e) {
                logger.error("SAML Failure", e, new String[0]);
                return false;
            }
            this.pdsHandle = samlRequestId;
        }
        this.loginOk = true;
        this.identity = this.createIdentity(this.DPSUserName);
        ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
        ((UserPrincipal)this.identity).setPdsHandle(this.pdsHandle);
        ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
        ((UserPrincipal)this.identity).setAuthenticationMode(this.authenticationMode);
        if (StringUtils.isNotEmpty((String)this.userGroups) && this.userGroups.split(",").length > 0) {
            this.userGroups = this.userGroups.substring(0, this.userGroups.length() - 1);
        }
        this.userGroups = StringUtils.isEmpty((String)(userByName = this.getAuthenticationManager().getUserByName(this.DPSUserName)).getUserGroup()) ? this.userGroups : userByName.getUserGroup() + (StringUtils.isNotEmpty((String)this.userGroups) ? "," + this.userGroups : "");
        authenticationParameters.put("SAMLUserGroups", this.userGroups);
        ((UserPrincipal)this.identity).setAuthenticationParameters(authenticationParameters);
        this.augmentUserPrincipal();
        return true;
    }

    private boolean handleLocalLogin(Callback[] calls) throws Exception {
        boolean authenticated = false;
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        String userNameInstitution = ((NameCallback)calls[0]).getName();
        this.DPSUserName = StringUtils.substringBefore((String)userNameInstitution, (String)"-institutionCode-");
        this.DPSUserInstitution = StringUtils.substringAfter((String)userNameInstitution, (String)"-institutionCode-");
        String password = String.valueOf(((PasswordCallback)calls[1]).getPassword());
        if (StringUtils.isBlank((String)password) && ":ChangeInstitution:".equals(this.DPSUserName)) {
            authenticated = true;
            this.DPSUserName = UserPrincipalRetriever.getUserPrincipal().getUserName();
            this.pdsHandle = UserPrincipalRetriever.getUserPrincipal().getPdsHandle();
        } else {
            authenticated = authenticationManager.authenticateUser(this.DPSUserName, password);
            this.pdsHandle = String.valueOf(System.currentTimeMillis()) + RandomStringUtils.randomNumeric((int)3);
        }
        if (authenticated) {
            this.loginOk = true;
            this.identity = this.createIdentity(this.DPSUserName);
            ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
            ((UserPrincipal)this.identity).setPdsHandle(this.pdsHandle);
            ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
            ((UserPrincipal)this.identity).setAuthenticationMode(this.authenticationMode);
            this.augmentUserPrincipal();
        }
        return authenticated;
    }

    private boolean handlePdsLogin(Callback[] calls) throws LoginException, UnsupportedEncodingException {
        boolean authenticated = false;
        this.pdsHandle = ((NameCallback)calls[0]).getName();
        PdsConnector pdsConn = PdsConnector.getInstance();
        PdsUserInfo userDetails = pdsConn.getUserInfo(this.pdsHandle);
        if (((PasswordCallback)calls[1]).getPassword() != null && !String.valueOf(((PasswordCallback)calls[1]).getPassword()).equals("null") && !String.valueOf(((PasswordCallback)calls[1]).getPassword()).trim().equals("")) {
            this.DPSUserName = userDetails.getUserName();
            this.DPSUserInstitution = String.valueOf(((PasswordCallback)calls[1]).getPassword());
            authenticated = true;
            this.loginOk = true;
            this.getUsernameAndPassword();
            try {
                this.identity = this.createIdentity(this.DPSUserName);
                ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
                ((UserPrincipal)this.identity).setPdsHandle(this.pdsHandle);
                ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
                ((UserPrincipal)this.identity).setAuthenticationMode(this.authenticationMode);
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                logger.debug((Object)e.getStackTrace(), new String[0]);
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            return authenticated;
        }
        if (userDetails != null && userDetails.getUserName() != null) {
            this.DPSUserName = new String(userDetails.getUserName().getBytes("ISO-8859-1"), "UTF-8");
            this.DPSUserInstitution = userDetails.getBorDeptM();
            authenticated = true;
            this.loginOk = true;
            this.getUsernameAndPassword();
            try {
                this.identity = this.createIdentity(this.DPSUserName);
                ((UserPrincipal)this.identity).setUserName(this.DPSUserName);
                ((UserPrincipal)this.identity).setPdsHandle(this.pdsHandle);
                ((UserPrincipal)this.identity).setAuthenticationMode(this.authenticationMode);
                this.augmentUserPrincipal();
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to create principal: " + e.getMessage()), new String[0]);
                logger.debug((Object)e.getStackTrace(), new String[0]);
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            return authenticated;
        }
        return authenticated;
    }

    private void augmentUserPrincipal() {
        try {
            ((UserPrincipal)this.identity).setInstitutionCode(this.DPSUserInstitution);
            ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
            HFrInstitution institution = consMng.findInstitutionByCode(this.DPSUserInstitution);
            if (institution == null) {
                if (!"CRS00".equals(this.DPSUserInstitution)) {
                    logger.warn((Object)("No institution found for code " + this.DPSUserInstitution), new String[0]);
                }
                ((UserPrincipal)this.identity).setInstitutionPath(this.DPSUserInstitution);
            } else {
                ((UserPrincipal)this.identity).setInstitutionPath(institution.getPath());
            }
            HFrUser userByName = this.getAuthenticationManager().getUserByName(this.DPSUserName);
            ((UserPrincipal)this.identity).setUserDetails(userByName);
        }
        catch (Exception e) {
            logger.warn((Object)"Couldn't add extra info to the UserPrincipal", e, new String[0]);
        }
    }

    private AuthenticationManager getAuthenticationManager() {
        return (AuthenticationManager)ServiceLocator.getInstance().lookUp(AuthenticationManager.class);
    }

    @Override
    protected Principal getIdentity() {
        return this.identity;
    }

    @Override
    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[2];
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = EncodingUtil.encodeISO88591UsingUTF8(nc.getName());
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = EncodingUtil.encodeISO88591UsingUTF8(new String(this.credential));
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        SecurityHash.getInstance().add(username, password);
        info[0] = username;
        info[1] = password;
        return info;
    }

    @Override
    protected Principal createIdentity(String username) throws Exception {
        return super.createIdentity(username);
    }

    protected String createPasswordHash(String username, String password) {
        String passwordHash = "Util.createPasswordHash(hashAlgorithm, hashEncoding, hashCharset, username, password)";
        return passwordHash;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }

    protected String getUsersPassword() throws LoginException {
        return "jaas";
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup gr1 = new SimpleGroup("Roles");
        HashMap<String, SimpleGroup> setsMap = new HashMap<String, SimpleGroup>();
        UserPrincipal userPrincipal = (UserPrincipal)this.getIdentity();
        userPrincipal.setUserName(this.DPSUserName);
        String psdhandle = ((UserPrincipal)this.identity).getPdsHandle();
        userPrincipal.setPdsHandle(psdhandle);
        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        HFrInstitution institution = consMng.findInstitutionByCode(this.DPSUserInstitution);
        if (institution == null) {
            if (!"CRS00".equals(this.DPSUserInstitution)) {
                logger.warn((Object)("No institution found for code " + this.DPSUserInstitution), new String[0]);
            }
            userPrincipal.setInstitutionCode(this.DPSUserInstitution);
            userPrincipal.setInstitutionPath(this.DPSUserInstitution);
        } else {
            userPrincipal.setInstitutionCode(institution.getCode());
            userPrincipal.setInstitutionPath(institution.getPath());
        }
        HFrUser userDetails = null;
        try {
            AuthenticationManager pdsManager = this.getAuthenticationManager();
            userDetails = pdsManager.getUserByName(this.DPSUserName);
            List<HFrUserRoles> userRoles = pdsManager.getUserRoleByUserAndInstitution(userDetails, userPrincipal.getInstitutionPath());
            userPrincipal.setUserDetails(userDetails);
            List<String> userPrivileges = userPrincipal.getPrivileges();
            if (userPrivileges == null) {
                userPrivileges = new ArrayList<String>();
            }
            for (HFrUserRoles role : userRoles) {
                if (!role.getStatus().equals((Object)HFrUserRoles.Status.ACTIVE)) continue;
                String userRoleName = Integer.toString(role.getRoleType());
                ArrayList<String> privileges = PrivilegeCacheManager.getInstance().getPrivileges2Role(userRoleName);
                for (String privilege : privileges) {
                    gr1.addMember(new SimplePrincipal(privilege));
                    userPrivileges.add(privilege);
                }
            }
            userPrincipal.setPrivileges(userPrivileges);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gr1.addMember(new SimplePrincipal("DEFAULT_ROLE"));
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        callerPrincipal.addMember(userPrincipal);
        setsMap.put("CallerPrincipal", callerPrincipal);
        setsMap.put("Roles", gr1);
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }
}

