/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.set_horspool;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.OptimalByteMatcherFactory;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceReverseMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceUtils;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.multisequence.AbstractMultiSequenceSearcher;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public class SetHorspoolSearcher
extends AbstractMultiSequenceSearcher {
    private final ByteMatcherFactory byteMatcherFactory;
    private final LazyObject<SearchInfo> forwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new ForwardInfoFactory());
    private final LazyObject<SearchInfo> backwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new BackwardInfoFactory());

    public SetHorspoolSearcher(MultiSequenceMatcher sequences) {
        super(sequences);
        this.byteMatcherFactory = OptimalByteMatcherFactory.FACTORY;
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        byte currentByte;
        int finalPosition;
        SearchInfo info = this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        ByteMatcher endOfSequence = info.matcher;
        MultiSequenceMatcher verifier = info.verifier;
        int safeStartPosition = fromPosition > 0 ? fromPosition : 0;
        int lastPossiblePosition = bytes.length - 1;
        int lastToPosition = toPosition + this.sequences.getMaximumLength() - 1;
        int n = finalPosition = lastToPosition < lastPossiblePosition ? lastToPosition : lastPossiblePosition;
        for (int searchPosition = safeStartPosition + this.sequences.getMinimumLength() - 1; searchPosition <= finalPosition; searchPosition += safeShifts[currentByte & 0xFF]) {
            List<SearchResult<SequenceMatcher>> results;
            currentByte = bytes[searchPosition];
            while (!endOfSequence.matches(currentByte)) {
                if ((searchPosition += safeShifts[currentByte & 0xFF]) > finalPosition) {
                    return SearchUtils.noResults();
                }
                currentByte = bytes[searchPosition];
            }
            Collection<SequenceMatcher> matches = verifier.allMatchesBackwards(bytes, searchPosition);
            if (matches.isEmpty() || (results = SearchUtils.resultsBackFromPosition(searchPosition, matches, fromPosition, toPosition)).isEmpty()) continue;
            return results;
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arrayStartPosition;
        int arraySearchPosition;
        SearchInfo info = this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        ByteMatcher endOfSequence = info.matcher;
        MultiSequenceMatcher verifier = info.verifier;
        long finalPosition = toPosition + (long)this.sequences.getMaximumLength() - 1L;
        block0: for (long searchPosition = fromPosition + (long)this.sequences.getMinimumLength() - 1L; searchPosition <= finalPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition += (long)(arraySearchPosition - arrayStartPosition)) {
            byte currentByte;
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            int arrayEndPosition = window.length() - 1;
            long distanceToEnd = finalPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition <= lastSearchPosition; arraySearchPosition += safeShifts[currentByte & 0xFF]) {
                List<SearchResult<SequenceMatcher>> results;
                currentByte = array[arraySearchPosition];
                while (!endOfSequence.matches(currentByte)) {
                    if ((arraySearchPosition += safeShifts[currentByte & 0xFF]) > lastSearchPosition) continue block0;
                    currentByte = array[arraySearchPosition];
                }
                long matchEndPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                Collection<SequenceMatcher> matches = verifier.allMatchesBackwards(reader, matchEndPosition);
                if (matches.isEmpty() || (results = SearchUtils.resultsBackFromPosition(matchEndPosition, matches, fromPosition, toPosition)).isEmpty()) continue;
                return results;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        byte currentByte;
        int lastPosition;
        SearchInfo info = this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        ByteMatcher startOfSequence = info.matcher;
        MultiSequenceMatcher verifier = info.verifier;
        int n = lastPosition = toPosition > 0 ? toPosition : 0;
        for (int searchPosition = fromPosition < (firstPossiblePosition = bytes.length - this.getMatcher().getMinimumLength()) ? fromPosition : firstPossiblePosition; searchPosition >= lastPosition; searchPosition -= safeShifts[currentByte & 0xFF]) {
            currentByte = bytes[searchPosition];
            while (!startOfSequence.matches(currentByte)) {
                if ((searchPosition -= safeShifts[currentByte & 0xFF]) < lastPosition) {
                    return SearchUtils.noResults();
                }
                currentByte = bytes[searchPosition];
            }
            Collection<SequenceMatcher> matches = verifier.allMatches(bytes, searchPosition);
            if (matches.isEmpty()) continue;
            return SearchUtils.resultsAtPosition(searchPosition, matches);
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arraySearchPosition;
        int arrayStartPosition;
        SearchInfo info = this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        ByteMatcher startOfSequence = info.matcher;
        MultiSequenceMatcher verifier = info.verifier;
        block0: for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(arrayStartPosition - arraySearchPosition)) {
            byte currentByte;
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            long distanceToEnd = toPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
            for (arraySearchPosition = arrayStartPosition; arraySearchPosition >= lastSearchPosition; arraySearchPosition -= safeShifts[currentByte & 0xFF]) {
                currentByte = array[arraySearchPosition];
                while (!startOfSequence.matches(currentByte)) {
                    if ((arraySearchPosition -= safeShifts[currentByte & 0xFF]) < lastSearchPosition) continue block0;
                    currentByte = array[arraySearchPosition];
                }
                long startMatchPosition = searchPosition - (long)(arrayStartPosition - arraySearchPosition);
                Collection<SequenceMatcher> matches = verifier.allMatches(reader, startMatchPosition);
                if (matches.isEmpty()) continue;
                return SearchUtils.resultsAtPosition(startMatchPosition, matches);
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
        this.forwardInfo.get();
    }

    @Override
    public void prepareBackwards() {
        this.backwardInfo.get();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[sequences:" + this.sequences + ']';
    }

    private class BackwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        @Override
        public SearchInfo create() {
            MultiSequenceMatcher matcher = SetHorspoolSearcher.this.getMatcher();
            int minLength = matcher.getMinimumLength();
            Set<Byte> allFirstBytes = MultiSequenceUtils.bytesAlignedLeft(0, matcher);
            ByteMatcher firstPositionMatcher = SetHorspoolSearcher.this.byteMatcherFactory.create(allFirstBytes);
            MultiSequenceMatcher verifier = matcher;
            int[] shifts = new int[256];
            Arrays.fill(shifts, minLength);
            for (int distanceFromStart = minLength - 1; distanceFromStart > 0; --distanceFromStart) {
                Set<Byte> bytesForPosition = MultiSequenceUtils.bytesAlignedLeft(distanceFromStart, matcher);
                for (byte b : bytesForPosition) {
                    shifts[b & 0xFF] = distanceFromStart;
                }
            }
            return new SearchInfo(shifts, firstPositionMatcher, verifier);
        }
    }

    private final class ForwardInfoFactory
    implements ObjectFactory<SearchInfo> {
        private ForwardInfoFactory() {
        }

        @Override
        public SearchInfo create() {
            MultiSequenceMatcher matcher = SetHorspoolSearcher.this.getMatcher();
            int minLength = matcher.getMinimumLength();
            Set<Byte> allLastBytes = MultiSequenceUtils.bytesAlignedRight(0, matcher);
            ByteMatcher lastPositionMatcher = SetHorspoolSearcher.this.byteMatcherFactory.create(allLastBytes);
            MultiSequenceReverseMatcher verifier = new MultiSequenceReverseMatcher(matcher);
            int[] shifts = new int[256];
            Arrays.fill(shifts, minLength);
            for (int distanceFromEnd = minLength - 1; distanceFromEnd > 0; --distanceFromEnd) {
                Set<Byte> bytesForPosition = MultiSequenceUtils.bytesAlignedRight(distanceFromEnd, matcher);
                for (byte b : bytesForPosition) {
                    shifts[b & 0xFF] = distanceFromEnd;
                }
            }
            return new SearchInfo(shifts, lastPositionMatcher, verifier);
        }
    }

    private static final class SearchInfo {
        private final int[] shifts;
        private final ByteMatcher matcher;
        private final MultiSequenceMatcher verifier;

        public SearchInfo(int[] shifts, ByteMatcher endMatcher, MultiSequenceMatcher verifier) {
            this.shifts = shifts;
            this.matcher = endMatcher;
            this.verifier = verifier;
        }
    }
}

