/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class IdentificationResultCollection {
    private Map<String, IdentificationResult> puidMap = new HashMap<String, IdentificationResult>();
    private List<IdentificationResult> results = new ArrayList<IdentificationResult>();
    private URI resourceUri;
    private Long fileLength;
    private ResourceId correlationId;
    private boolean archive;
    private RequestMetaData requestMetaData;
    private Boolean fileExtensionMismatch = false;

    public IdentificationResultCollection(IdentificationRequest request) {
        this.correlationId = request.getIdentifier().getParentResourceId();
        this.resourceUri = request.getIdentifier().getUri();
    }

    public void addResult(IdentificationResult result) {
        String puid = result.getPuid();
        if (!this.puidMap.containsKey(puid)) {
            this.puidMap.put(puid, result);
            this.results.add(result);
        }
    }

    public void removeResult(IdentificationResult result) {
        if (this.results.remove(result)) {
            String puid = result.getPuid();
            this.puidMap.remove(puid);
        }
    }

    public List<IdentificationResult> getResults() {
        return this.results;
    }

    public ResourceId getCorrelationId() {
        return this.correlationId;
    }

    public void setUri(URI uri) {
        this.resourceUri = uri;
    }

    public URI getUri() {
        return this.resourceUri;
    }

    public void setFileLength(Long fileLength) {
        this.fileLength = fileLength;
    }

    public Long getFileLength() {
        return this.fileLength;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setExtensionMismatch(Boolean value) {
        this.fileExtensionMismatch = value;
    }

    public Boolean getExtensionMismatch() {
        return this.fileExtensionMismatch;
    }

    public void setRequestMetaData(RequestMetaData requestMetaData) {
        this.requestMetaData = requestMetaData;
    }

    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }
}

