/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.SevenZipIteratorAdapter;
import uk.gov.nationalarchives.droid.core.interfaces.archive.SevenZipReader;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class SevenZipArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droid;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;

    public SevenZipArchiveHandler() {
    }

    public SevenZipArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler) {
        this.droid = droidCore;
        this.factory = factory;
        this.resultHandler = resultHandler;
    }

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        SevenZipReader sevenZipReader = new SevenZipReader(request.getWindowReader());
        SevenZFile sevenZFile = new SevenZFile((SeekableByteChannel)sevenZipReader);
        SevenZipIteratorAdapter sevenZIterator = new SevenZipIteratorAdapter(sevenZFile);
        SevenZArchiveWalker walker = new SevenZArchiveWalker(this.droid, this.factory, request.getIdentifier(), this.resultHandler);
        walker.walk(sevenZIterator);
    }

    private static ResourceId submitDirectory(URI parentName, SevenZArchiveEntry entry, String entryName, ResourceId correlationId, ResultHandler resultHandler) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        long size = entry.getSize();
        Date date = entry.getLastModifiedDate();
        long time = date == null ? -1L : date.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(parentName, entry.getName()));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return resultHandler.handleDirectory(result, correlationId, false);
    }

    public void setFactory(IdentificationRequestFactory<InputStream> factory) {
        this.factory = factory;
    }

    public void setDroid(AsynchDroid droid) {
        this.droid = droid;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public static class SevenZArchiveWalker
    extends ArchiveFileWalker<SevenZEntryInfo> {
        private final AsynchDroid droid;
        private IdentificationRequestFactory<InputStream> factory;
        private final ResourceId parentId;
        private final URI parentName;
        private final long originatorNodeId;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();
        private final ResultHandler resultHandler;

        public SevenZArchiveWalker(AsynchDroid droid, IdentificationRequestFactory<InputStream> factory, RequestIdentifier parent, ResultHandler resultHandler) {
            this.droid = droid;
            this.factory = factory;
            this.parentId = parent.getResourceId();
            this.parentName = parent.getUri();
            this.originatorNodeId = parent.getAncestorId();
            this.resultHandler = resultHandler;
        }

        @Override
        protected void handleEntry(SevenZEntryInfo info) throws IOException {
            String entryName = info.entry.getName();
            String prefixPath = FilenameUtils.getPath((String)entryName);
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = this.processAncestorFolders(prefixPath, info.getEntry().getLastModifiedDate());
            }
            if (!info.entry.isDirectory() && !(entryName = FilenameUtils.getName((String)entryName)).isEmpty()) {
                this.submit(info, entryName, correlationId);
            }
        }

        final void submit(SevenZEntryInfo info, String entryName, ResourceId correlationId) throws IOException {
            IdentificationRequest<InputStream> request;
            Long size = info.entry != null ? Long.valueOf(info.entry.getSize()) : null;
            Long lastModfied = info.entry != null && info.entry.getHasLastModifiedDate() ? info.entry.getLastModifiedDate().getTime() : new Date().getTime();
            RequestMetaData metaData = new RequestMetaData(size, lastModfied, entryName);
            RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toSevenZUri(this.parentName, info.entry.getName()));
            identifier.setAncestorId(this.originatorNodeId);
            identifier.setParentResourceId(correlationId);
            if (identifier.getParentPrefix() != null && identifier.getParentPrefix().isEmpty()) {
                identifier.setParentPrefix(null);
            }
            if (this.droid.passesIdentificationFilter(request = this.factory.newRequest(metaData, identifier))) {
                request.open(info.stream);
                this.droid.submit(request);
            }
        }

        private ResourceId processAncestorFolders(String path, Date lastModified) {
            int pathIndex;
            List<String> paths = ArchiveFileUtils.getAncestorPaths(path);
            ResourceId longestParentId = this.parentId;
            int longestSeenBefore = paths.size();
            ResourceId correlationId = null;
            for (pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
                correlationId = this.directories.get(paths.get(pathIndex));
                if (correlationId == null) continue;
                longestSeenBefore = pathIndex;
                longestParentId = correlationId;
                break;
            }
            for (pathIndex = longestSeenBefore - 1; pathIndex >= 0; --pathIndex) {
                String pathName = paths.get(pathIndex);
                SevenZArchiveEntry entry = new SevenZArchiveEntry();
                entry.setLastModifiedDate(lastModified);
                entry.setName(pathName);
                String dirName = FilenameUtils.getName((String)pathName.substring(0, pathName.length() - 1));
                longestParentId = SevenZipArchiveHandler.submitDirectory(this.parentName, entry, dirName, longestParentId, this.resultHandler);
                this.directories.put(pathName, longestParentId);
            }
            return longestParentId;
        }
    }

    public static class SevenZEntryInfo {
        private final SevenZArchiveEntry entry;
        private final InputStream stream;

        public SevenZEntryInfo(SevenZArchiveEntry entry, InputStream stream) {
            this.entry = entry;
            this.stream = stream;
        }

        public SevenZArchiveEntry getEntry() {
            return this.entry;
        }

        public InputStream getEntryStream() {
            return this.stream;
        }
    }
}

