/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.fat.FatFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.FatReader;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FatFileIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public final class FatArchiveHandler
implements ArchiveHandler {
    private static final boolean OPEN_READ_ONLY = true;
    private AsynchDroid droid;
    private ResultHandler resultHandler;
    private IdentificationRequestFactory<InputStream> factory;

    public FatArchiveHandler() {
    }

    public FatArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory factory, ResultHandler resultHandler) {
        this.droid = droidCore;
        this.factory = factory;
        this.resultHandler = resultHandler;
    }

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        FatReader device = new FatReader(request.getWindowReader());
        FatFileSystem fatSystem = FatFileSystem.read((BlockDevice)device, (boolean)true);
        FsDirectory root = fatSystem.getRoot();
        FatArchiveWalker walker = new FatArchiveWalker(this.droid, this.resultHandler, request.getIdentifier());
        walker.walk(root);
    }

    private <T> Iterable<T> toIterable(Iterator<T> it) {
        return () -> it;
    }

    private String expand(FsDirectoryEntry entry, Map<FsDirectoryEntry, FsDirectoryEntry> map) {
        String filePath = entry.getName();
        FsDirectoryEntry parent = map.get(entry);
        while (parent != null) {
            filePath = parent.getName() + File.separatorChar + filePath;
            parent = map.get(parent);
        }
        return filePath;
    }

    public void setFactory(IdentificationRequestFactory<InputStream> factory) {
        this.factory = factory;
    }

    public void setDroid(AsynchDroid droid) {
        this.droid = droid;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private final class FatArchiveWalker
    extends ArchiveFileWalker<FsDirectoryEntry> {
        private final AsynchDroid droid;
        private final ResultHandler resultHandler;
        private final ResourceId rootParentId;
        private final URI fatFileUri;
        private final long originatorNodeId;
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Map<FsDirectoryEntry, ResourceId> directories = new HashMap<FsDirectoryEntry, ResourceId>();
        private final Map<FsDirectoryEntry, FsDirectoryEntry> parentMap = new HashMap<FsDirectoryEntry, FsDirectoryEntry>();

        private FatArchiveWalker(AsynchDroid droid, ResultHandler resultHandler, RequestIdentifier requestIdentifier) {
            this.droid = droid;
            this.resultHandler = resultHandler;
            this.rootParentId = requestIdentifier.getResourceId();
            this.fatFileUri = requestIdentifier.getUri();
            this.originatorNodeId = requestIdentifier.getNodeId();
        }

        private void submitFile(FsFile file, FsDirectoryEntry entry) throws IOException {
            FsDirectoryEntry parent = this.parentMap.get(entry);
            ResourceId correlationId = this.rootParentId;
            if (parent != null) {
                correlationId = this.directories.get(parent);
            }
            RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toFatImageUri(this.fatFileUri, FatArchiveHandler.this.expand(entry, this.parentMap)));
            identifier.setAncestorId(this.originatorNodeId);
            identifier.setParentResourceId(correlationId);
            RequestMetaData requestMetaData = new RequestMetaData(file.getLength(), entry.getCreated(), entry.getName());
            IdentificationRequest<FileInputStream> req = FatArchiveHandler.this.factory.newRequest(requestMetaData, identifier);
            if (this.droid.passesIdentificationFilter(req)) {
                Path tempFile = ArchiveFileUtils.writeFsFileToTemp(entry, ((FatFileIdentificationRequest)req).getTempDir());
                FileInputStream is = new FileInputStream(tempFile.toFile());
                req.open(is);
                this.droid.submit(req);
            }
        }

        private void submitDirectory(FsDirectoryEntry directoryEntry) throws IOException {
            ResourceId resourceId = this.directories.get(directoryEntry);
            if (resourceId == null) {
                FsDirectoryEntry parent = this.parentMap.get(directoryEntry);
                ResourceId parentID = parent != null ? this.directories.get(parent) : this.rootParentId;
                RequestMetaData metaData = new RequestMetaData(null, directoryEntry.getLastModified(), directoryEntry.getName());
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toFatImageUri(this.fatFileUri, FatArchiveHandler.this.expand(directoryEntry, this.parentMap)));
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setRequestMetaData(metaData);
                result.setIdentifier(identifier);
                resourceId = this.resultHandler.handleDirectory(result, parentID, false);
                this.directories.put(directoryEntry, resourceId);
            }
        }

        @Override
        protected void handleEntry(FsDirectoryEntry directoryEntry) throws IOException {
            if (directoryEntry.isFile()) {
                if (directoryEntry.getFile().getLength() != 0L) {
                    this.submitFile(directoryEntry.getFile(), directoryEntry);
                }
            } else if (directoryEntry.isDirectory()) {
                if (this.notCurrentOrParentDirectory(directoryEntry)) {
                    for (FsDirectoryEntry e : directoryEntry.getDirectory()) {
                        if (!this.notCurrentOrParentDirectory(e)) continue;
                        this.parentMap.put(e, directoryEntry);
                    }
                    if (!"".equals(directoryEntry.getDirectory().toString())) {
                        try {
                            this.submitDirectory(directoryEntry);
                            this.walk(FatArchiveHandler.this.toIterable(directoryEntry.getDirectory().iterator()));
                        }
                        catch (IOException ex) {
                            this.log.error("Failed on directory submission", (Throwable)ex);
                        }
                    }
                }
            } else {
                this.log.error("unknown entry : " + directoryEntry);
            }
        }

        private boolean notCurrentOrParentDirectory(FsDirectoryEntry directoryEntry) {
            return !".".equals(directoryEntry.getName()) && !"..".equals(directoryEntry.getName());
        }
    }
}

