/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatLfnDirectoryEntry;
import de.waldheinz.fs.fat.ShortName;
import de.waldheinz.fs.fat.ShortNameGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class FatLfnDirectory
extends AbstractFsObject
implements FsDirectory {
    private final Set<String> usedNames;
    private final Fat fat;
    private final Map<ShortName, FatLfnDirectoryEntry> shortNameIndex;
    private final Map<String, FatLfnDirectoryEntry> longNameIndex;
    private final Map<FatDirectoryEntry, FatFile> entryToFile;
    private final Map<FatDirectoryEntry, FatLfnDirectory> entryToDirectory;
    private final ShortNameGenerator sng;
    final AbstractDirectory dir;

    FatLfnDirectory(AbstractDirectory dir, Fat fat, boolean readOnly) throws IOException {
        super(readOnly);
        if (dir == null || fat == null) {
            throw new NullPointerException();
        }
        this.fat = fat;
        this.dir = dir;
        this.shortNameIndex = new LinkedHashMap<ShortName, FatLfnDirectoryEntry>();
        this.longNameIndex = new LinkedHashMap<String, FatLfnDirectoryEntry>();
        this.entryToFile = new LinkedHashMap<FatDirectoryEntry, FatFile>();
        this.entryToDirectory = new LinkedHashMap<FatDirectoryEntry, FatLfnDirectory>();
        this.usedNames = new HashSet<String>();
        this.sng = new ShortNameGenerator(this.usedNames);
        this.parseLfn();
    }

    Fat getFat() {
        return this.fat;
    }

    FatFile getFile(FatDirectoryEntry entry) throws IOException {
        FatFile file = this.entryToFile.get(entry);
        if (file == null) {
            file = FatFile.get(this.fat, entry);
            this.entryToFile.put(entry, file);
        }
        return file;
    }

    FatLfnDirectory getDirectory(FatDirectoryEntry entry) throws IOException {
        FatLfnDirectory result = this.entryToDirectory.get(entry);
        if (result == null) {
            ClusterChainDirectory storage = FatLfnDirectory.read(entry, this.fat);
            result = new FatLfnDirectory(storage, this.fat, this.isReadOnly());
            this.entryToDirectory.put(entry, result);
        }
        return result;
    }

    @Override
    public FatLfnDirectoryEntry addFile(String name) throws IOException {
        this.checkWritable();
        this.checkUniqueName(name);
        name = name.trim();
        ShortName sn = this.makeShortName(name);
        FatLfnDirectoryEntry entry = new FatLfnDirectoryEntry(name, sn, this, false);
        this.dir.addEntries(entry.compactForm());
        this.shortNameIndex.put(sn, entry);
        this.longNameIndex.put(name.toLowerCase(Locale.ROOT), entry);
        this.getFile(entry.realEntry);
        this.dir.setDirty();
        return entry;
    }

    boolean isFreeName(String name) {
        return !this.usedNames.contains(name.toLowerCase(Locale.ROOT));
    }

    private void checkUniqueName(String name) throws IOException {
        String lowerName = name.toLowerCase(Locale.ROOT);
        if (!this.usedNames.add(lowerName)) {
            throw new IOException("an entry named " + name + " already exists");
        }
    }

    private ShortName makeShortName(String name) throws IOException {
        ShortName result;
        try {
            result = this.sng.generateShortName(name);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("could not generate short name for \"" + name + "\"", ex);
        }
        this.usedNames.add(result.asSimpleString().toLowerCase(Locale.ROOT));
        return result;
    }

    @Override
    public FatLfnDirectoryEntry addDirectory(String name) throws IOException {
        this.checkWritable();
        this.checkUniqueName(name);
        name = name.trim();
        ShortName sn = this.makeShortName(name);
        FatDirectoryEntry real = this.dir.createSub(this.fat);
        real.setShortName(sn);
        FatLfnDirectoryEntry e = new FatLfnDirectoryEntry(this, real, name);
        try {
            this.dir.addEntries(e.compactForm());
        }
        catch (IOException ex) {
            ClusterChain cc = new ClusterChain(this.fat, real.getStartCluster(), false);
            cc.setChainLength(0);
            this.dir.removeEntry(real);
            throw ex;
        }
        this.shortNameIndex.put(sn, e);
        this.longNameIndex.put(name.toLowerCase(Locale.ROOT), e);
        this.getDirectory(real);
        this.flush();
        return e;
    }

    @Override
    public FatLfnDirectoryEntry getEntry(String name) {
        FatLfnDirectoryEntry entry = this.longNameIndex.get(name = name.trim().toLowerCase(Locale.ROOT));
        if (entry == null) {
            if (!ShortName.canConvert(name)) {
                return null;
            }
            return this.shortNameIndex.get(ShortName.get(name));
        }
        return entry;
    }

    private void parseLfn() throws IOException {
        int i = 0;
        int size = this.dir.getEntryCount();
        while (i < size) {
            while (i < size && this.dir.getEntry(i) == null) {
                ++i;
            }
            if (i >= size) break;
            int offset = i;
            while (this.dir.getEntry(i).isLfnEntry() && ++i < size) {
            }
            if (i >= size) break;
            FatLfnDirectoryEntry current = FatLfnDirectoryEntry.extract(this, offset, ++i - offset);
            if (current.realEntry.isDeleted() || !current.isValid()) continue;
            this.checkUniqueName(current.getName());
            this.shortNameIndex.put(current.realEntry.getShortName(), current);
            this.longNameIndex.put(current.getName().toLowerCase(Locale.ROOT), current);
        }
    }

    private void updateLFN() throws IOException {
        ArrayList<FatDirectoryEntry> dest = new ArrayList<FatDirectoryEntry>();
        for (FatLfnDirectoryEntry currentEntry : this.shortNameIndex.values()) {
            FatDirectoryEntry[] encoded = currentEntry.compactForm();
            dest.addAll(Arrays.asList(encoded));
        }
        int size = dest.size();
        this.dir.changeSize(size);
        this.dir.setEntries(dest);
    }

    @Override
    public void flush() throws IOException {
        this.checkWritable();
        for (FatFile f : this.entryToFile.values()) {
            f.flush();
        }
        for (FatLfnDirectory d : this.entryToDirectory.values()) {
            d.flush();
        }
        this.updateLFN();
        this.dir.flush();
    }

    @Override
    public Iterator<FsDirectoryEntry> iterator() {
        return new Iterator<FsDirectoryEntry>(){
            final Iterator<FatLfnDirectoryEntry> it;
            {
                this.it = FatLfnDirectory.this.shortNameIndex.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FsDirectoryEntry next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void remove(String name) throws IOException, IllegalArgumentException {
        this.checkWritable();
        FatLfnDirectoryEntry entry = this.getEntry(name);
        if (entry == null) {
            return;
        }
        this.unlinkEntry(entry);
        ClusterChain cc = new ClusterChain(this.fat, entry.realEntry.getStartCluster(), false);
        cc.setChainLength(0);
        this.updateLFN();
    }

    void unlinkEntry(FatLfnDirectoryEntry entry) {
        ShortName sn = entry.realEntry.getShortName();
        if (sn.equals(ShortName.DOT) || sn.equals(ShortName.DOT_DOT)) {
            throw new IllegalArgumentException("the dot entries can not be removed");
        }
        String lowerName = entry.getName().toLowerCase(Locale.ROOT);
        assert (this.longNameIndex.containsKey(lowerName));
        this.longNameIndex.remove(lowerName);
        assert (this.shortNameIndex.containsKey(sn));
        this.shortNameIndex.remove(sn);
        this.usedNames.remove(sn.asSimpleString().toLowerCase(Locale.ROOT));
        assert (this.usedNames.contains(lowerName));
        this.usedNames.remove(lowerName);
        if (entry.isFile()) {
            this.entryToFile.remove(entry.realEntry);
        } else {
            this.entryToDirectory.remove(entry.realEntry);
        }
    }

    void linkEntry(FatLfnDirectoryEntry entry) throws IOException {
        this.checkUniqueName(entry.getName());
        ShortName sn = this.makeShortName(entry.getName());
        entry.realEntry.setShortName(sn);
        this.longNameIndex.put(entry.getName().toLowerCase(Locale.ROOT), entry);
        this.shortNameIndex.put(entry.realEntry.getShortName(), entry);
        this.updateLFN();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [size=" + this.shortNameIndex.size() + ", dir=" + this.dir + "]";
    }

    private static ClusterChainDirectory read(FatDirectoryEntry entry, Fat fat) throws IOException {
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException(entry + " is no directory");
        }
        ClusterChain chain = new ClusterChain(fat, entry.getStartCluster(), entry.isReadonlyFlag());
        ClusterChainDirectory result = new ClusterChainDirectory(chain, false);
        result.read();
        return result;
    }
}

