/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.TiffModule;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExif;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifIFD;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public final class JpegExif {
    private boolean _exifProfileOK = false;
    private String _profileText = null;
    private NisoImageMetadata _exifNiso = null;

    public static boolean isTiffAvailable() {
        try {
            Class.forName("edu.harvard.hul.ois.jhove.module.TiffModule");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepInfo readExifData(DataInputStream dstream, JhoveBase je, int length) {
        RandomAccessFile tiffRaf = null;
        File tiffFile = null;
        FileOutputStream fos = null;
        RepInfo info = new RepInfo("tempfile");
        try {
            tiffFile = je.tempFile();
        }
        catch (IOException e) {
            info.setMessage((Message)new ErrorMessage("Error creating temporary file. Check your configuration: " + e.getMessage()));
            return info;
        }
        try {
            fos = new FileOutputStream(tiffFile);
            int bufSize = je.getBufferSize();
            int tiffLen = length - 8;
            if (bufSize <= 0) {
                bufSize = 32768;
            }
            if (bufSize > tiffLen) {
                bufSize = tiffLen;
            }
            BufferedOutputStream bos = new BufferedOutputStream(fos, bufSize);
            byte[] buf = new byte[bufSize];
            while (tiffLen > 0) {
                int sz = tiffLen < bufSize ? tiffLen : bufSize;
                sz = dstream.read(buf, 0, sz);
                bos.write(buf, 0, sz);
                tiffLen -= sz;
            }
            fos.flush();
            TiffModule tiffMod = new TiffModule();
            tiffMod.setByteOffsetValid(true);
            tiffRaf = new RandomAccessFile(tiffFile, "r");
            List<IFD> ifds = tiffMod.exifParse(tiffRaf, info);
            if (ifds == null) {
                RepInfo repInfo = info;
                return repInfo;
            }
            ListIterator<IFD> iter = ifds.listIterator();
            boolean first = true;
            boolean haveNisoMetadata = false;
            NisoImageMetadata niso = null;
            while (iter.hasNext()) {
                IFD ifd = iter.next();
                if (ifd instanceof TiffIFD && first) {
                    TiffIFD tifd = (TiffIFD)ifd;
                    niso = tifd.getNisoImageMetadata();
                    info.setProperty(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)niso));
                    haveNisoMetadata = true;
                    TiffProfileExif exifProfile = new TiffProfileExif();
                    this._exifProfileOK = exifProfile.satisfiesProfile(tifd);
                    if (this._exifProfileOK) {
                        this._profileText = exifProfile.getText();
                    }
                }
                if (ifd instanceof ExifIFD) {
                    ExifIFD eifd = (ExifIFD)ifd;
                    Property ifdProp = eifd.getProperty(je.getShowRawFlag());
                    List exifList = null;
                    if (ifdProp != null) {
                        exifList = eifd.exifProps(ifdProp);
                    }
                    if (first || this._exifProfileOK) {
                        TiffProfileExifIFD exifIFDProfile = new TiffProfileExifIFD();
                        this._exifProfileOK = exifIFDProfile.satisfiesProfile(eifd);
                        if (!this._exifProfileOK) {
                            this._profileText = null;
                        }
                    }
                    if (exifList != null) {
                        info.setProperty(new Property("Exif", PropertyType.PROPERTY, PropertyArity.LIST, (Object)exifList));
                    }
                    if (!haveNisoMetadata) {
                        niso = eifd.getNisoImageMetadata();
                        info.setProperty(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)niso));
                    } else {
                        this._exifNiso = eifd.getNisoImageMetadata();
                    }
                }
                first = false;
            }
        }
        catch (IOException e) {
            info.setMessage((Message)new ErrorMessage("I/O exception processing Exif metadata: " + e.getMessage()));
        }
        finally {
            if (tiffRaf != null) {
                try {
                    tiffRaf.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (tiffFile != null) {
                try {
                    tiffFile.delete();
                }
                catch (Exception exception) {}
            }
        }
        return info;
    }

    public boolean isExifProfileOK() {
        return this._exifProfileOK;
    }

    public String getProfileText() {
        return this._profileText;
    }

    public NisoImageMetadata getExifNiso() {
        return this._exifNiso;
    }
}

