/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFile;
import uk.gov.nationalarchives.droid.container.AbstractIdentifierEngine;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ByteseekWindowWrapper;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;

public class ZipIdentifierEngine
extends AbstractIdentifierEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(IdentificationRequest request, ContainerSignatureMatchCollection matches) throws IOException {
        try (ZipFile zipFile = new ZipFile((SeekableByteChannel)new ByteseekWindowWrapper(request.getWindowReader()), ZipFile.DEFAULT_CHARSET, true, false);){
            for (String entryName : matches.getAllFileEntries()) {
                ZipEntry entry = zipFile.entry(entryName);
                if (entry == null) continue;
                InputStream stream = zipFile.getInputStream(entry.getName());
                ByteReader reader = null;
                try {
                    reader = this.newByteReader(stream);
                    List<ContainerSignatureMatch> matchList = matches.getContainerSignatureMatches();
                    for (ContainerSignatureMatch match : matchList) {
                        match.matchBinaryContent(entryName, reader);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
    }
}

