/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.util;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.verify.FileCountAndTotalSizeVistor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;

public final class PathUtils {
    private static final String PAYLOAD_DIR_NAME = "data";
    private static final String DOT_BAGIT_DIR_NAME = ".bagit";

    private PathUtils() {
    }

    public static String getFilename(Path path) {
        Path filenamePath;
        String filename = "";
        if (path != null && (filenamePath = path.getFileName()) != null) {
            filename = filenamePath.toString();
        }
        return filename;
    }

    public static String decodeFilname(String encoded) {
        return encoded.replaceAll("%0A", "\n").replaceAll("%0D", "\r");
    }

    public static String encodeFilename(Path path) {
        return path.toString().replaceAll("\n", "%0A").replaceAll("\r", "%0D");
    }

    public static boolean isHidden(Path path) throws IOException {
        if (System.getProperty("os.name").contains("Windows")) {
            return Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]).isHidden();
        }
        return Files.isHidden(path);
    }

    public static Path getDataDir(Bag bag) {
        if (bag.getVersion().isSameOrNewer(new Version(2, 0))) {
            return bag.getRootDir();
        }
        return bag.getRootDir().resolve(PAYLOAD_DIR_NAME);
    }

    public static Path getDataDir(Version version, Path output) {
        if (version.isSameOrNewer(new Version(2, 0))) {
            return output;
        }
        return output.resolve(PAYLOAD_DIR_NAME);
    }

    public static Path getBagitDir(Bag bag) {
        if (bag.getVersion().isSameOrNewer(new Version(2, 0))) {
            return bag.getRootDir().resolve(DOT_BAGIT_DIR_NAME);
        }
        return bag.getRootDir();
    }

    public static Path getBagitDir(Version version, Path bagRoot) {
        if (version.isSameOrNewer(new Version(2, 0))) {
            return bagRoot.resolve(DOT_BAGIT_DIR_NAME);
        }
        return bagRoot;
    }

    public static String generatePayloadOxum(Path dataDir) throws IOException {
        FileCountAndTotalSizeVistor visitor = new FileCountAndTotalSizeVistor();
        Files.walkFileTree(dataDir, visitor);
        return visitor.getTotalSize() + "." + visitor.getCount();
    }
}

