/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.matcher;

import java.util.ArrayList;
import net.byteseek.compiler.Optimiser;
import net.byteseek.matcher.bytes.AnyByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.ByteMatcherSequenceMatcher;
import net.byteseek.matcher.sequence.ByteSequenceMatcher;
import net.byteseek.matcher.sequence.FixedGapMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.matcher.sequence.SequenceSequenceMatcher;

public class SequenceMatcherOptimiser
implements Optimiser<SequenceMatcher> {
    public static final Optimiser<SequenceMatcher> SEQUENCE_OPTIMISER = new SequenceMatcherOptimiser();
    private static final int SIMPLE_MATCHER_CUT_OFF = 5;
    private static final int SUB_COMPONENT_OPTIMISE_PERCENTAGE = 40;

    @Override
    public SequenceMatcher optimise(SequenceMatcher toOptimise) {
        int length = toOptimise.length();
        if (length == 1) {
            return toOptimise.getMatcherForPosition(0);
        }
        int consecutiveOnes = this.countConsecutiveMatchersWithNumBytes(toOptimise, 1);
        if (consecutiveOnes == length) {
            return new ByteSequenceMatcher(toOptimise);
        }
        int consecutiveAny = this.countConsecutiveMatchersWithNumBytes(toOptimise, 256);
        if (consecutiveAny == length) {
            return new FixedGapMatcher(length);
        }
        if (length <= 5) {
            return new ByteMatcherSequenceMatcher(toOptimise);
        }
        int percentageOfRuns = (consecutiveOnes + consecutiveAny) * 100 / length;
        if (percentageOfRuns >= 40) {
            return this.optimiseSubComponents(toOptimise);
        }
        return new ByteMatcherSequenceMatcher(toOptimise);
    }

    private SequenceMatcher optimiseSubComponents(SequenceMatcher toOptimise) {
        int length = toOptimise.length();
        ArrayList<SequenceMatcher> components = new ArrayList<SequenceMatcher>();
        int currentOneRun = 0;
        int currentAnyRun = 0;
        for (int matcherIndex = 0; matcherIndex < length; ++matcherIndex) {
            int endIndex;
            int startIndex;
            ByteMatcher byteMatcher = toOptimise.getMatcherForPosition(matcherIndex);
            int numMatchingValues = byteMatcher.getNumberOfMatchingBytes();
            if (numMatchingValues == 1) {
                if (currentAnyRun == 1) {
                    components.add(AnyByteMatcher.ANY_BYTE_MATCHER);
                } else if (currentAnyRun > 1) {
                    components.add(new FixedGapMatcher(currentAnyRun));
                }
                currentAnyRun = 0;
                ++currentOneRun;
                continue;
            }
            if (numMatchingValues == 256) {
                if (currentOneRun == 1) {
                    components.add(toOptimise.getMatcherForPosition(matcherIndex - 1));
                } else if (currentOneRun > 1) {
                    startIndex = matcherIndex - currentOneRun;
                    endIndex = startIndex + currentOneRun;
                    components.add(new ByteSequenceMatcher(toOptimise.subsequence(startIndex, endIndex)));
                }
                currentOneRun = 0;
                ++currentAnyRun;
                continue;
            }
            if (currentAnyRun == 1) {
                components.add(AnyByteMatcher.ANY_BYTE_MATCHER);
            } else if (currentAnyRun > 1) {
                components.add(new FixedGapMatcher(currentAnyRun));
            } else if (currentOneRun == 1) {
                components.add(toOptimise.getMatcherForPosition(matcherIndex - 1));
            } else if (currentOneRun > 1) {
                startIndex = matcherIndex - currentOneRun;
                endIndex = startIndex + currentOneRun;
                components.add(new ByteSequenceMatcher(toOptimise.subsequence(startIndex, endIndex)));
            }
            currentAnyRun = 0;
            currentOneRun = 0;
            components.add(byteMatcher);
        }
        if (currentAnyRun == 1) {
            components.add(AnyByteMatcher.ANY_BYTE_MATCHER);
        } else if (currentAnyRun > 1) {
            components.add(new FixedGapMatcher(currentAnyRun));
        } else if (currentOneRun == 1) {
            components.add(toOptimise.getMatcherForPosition(length - 1));
        } else if (currentOneRun > 1) {
            int startIndex = length - currentOneRun;
            int endIndex = startIndex + currentOneRun;
            components.add(new ByteSequenceMatcher(toOptimise.subsequence(startIndex, endIndex)));
        }
        return new SequenceSequenceMatcher(components);
    }

    private int countConsecutiveMatchersWithNumBytes(SequenceMatcher toAnalyse, int valuesToFind) {
        int length = toAnalyse.length();
        int totalConsecutive = 0;
        int currentRun = 0;
        for (int matcherIndex = 0; matcherIndex < length; ++matcherIndex) {
            int numMatchingValues = toAnalyse.getMatcherForPosition(matcherIndex).getNumberOfMatchingBytes();
            if (numMatchingValues == valuesToFind) {
                ++currentRun;
                continue;
            }
            if (currentRun > 1) {
                totalConsecutive += currentRun;
            }
            currentRun = 0;
        }
        return currentRun > 1 ? totalConsecutive + currentRun : totalConsecutive;
    }
}

