/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser.tree;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class ParseTreeUtils {
    private static final String TYPE_ERROR = "Parse tree type [%s] is not supported by the parser.";

    private ParseTreeUtils() {
    }

    public static ParseTree getFirstChild(ParseTree node) throws ParseException {
        ArgUtils.checkNullObject(node);
        if (node.getNumChildren() > 0) {
            return node.getChild(0);
        }
        throw new ParseException("No children exist for node type: " + node.getParseTreeType().name());
    }

    public static ParseTree getLastChild(ParseTree parentNode) throws ParseException {
        ArgUtils.checkNullObject(parentNode);
        int numChildren = parentNode.getNumChildren();
        if (numChildren == 0) {
            throw new ParseException("Node has no children - cannot get last child node [" + parentNode + ']');
        }
        return parentNode.getChild(numChildren - 1);
    }

    public static int getChildIndexOfType(ParseTree parentNode, int from, ParseTreeType type) {
        ArgUtils.checkNullObject(parentNode);
        int numChildren = parentNode.getNumChildren();
        if (from < numChildren && from >= 0) {
            for (int searchIndex = from; searchIndex < numChildren; ++searchIndex) {
                if (parentNode.getChild(searchIndex).getParseTreeType() != type) continue;
                return searchIndex;
            }
        }
        return -1;
    }

    public static int getFirstRangeValue(ParseTree rangeNode) throws ParseException {
        return ParseTreeUtils.getRangeValue(rangeNode, 0);
    }

    public static int getSecondRangeValue(ParseTree rangeNode) throws ParseException {
        return ParseTreeUtils.getRangeValue(rangeNode, 1);
    }

    public static void addByteValues(ParseTree byteNode, Set<Byte> bytes) throws ParseException {
        ArgUtils.checkNullObject(byteNode, " parameter:byteNode");
        ArgUtils.checkNullCollection(bytes, " parameter: bytes");
        if (byteNode.isValueInverted()) {
            ByteUtils.addInvertedByteValues(byteNode.getByteValue(), bytes);
        } else {
            bytes.add(byteNode.getByteValue());
        }
    }

    public static void addRangeBytes(ParseTree range, Set<Byte> byteSet) throws ParseException {
        ArgUtils.checkNullObject(range, " parameter:range");
        ArgUtils.checkNullCollection(byteSet, " parameter:byteSet");
        if (range.isValueInverted()) {
            ByteUtils.addBytesNotInRange(ParseTreeUtils.getFirstRangeValue(range), ParseTreeUtils.getSecondRangeValue(range), byteSet);
        } else {
            ByteUtils.addBytesInRange(ParseTreeUtils.getFirstRangeValue(range), ParseTreeUtils.getSecondRangeValue(range), byteSet);
        }
    }

    public static int getFirstRepeatValue(ParseTree repeatNode) throws ParseException {
        return ParseTreeUtils.getRepeatValue(repeatNode, 0);
    }

    public static int getSecondRepeatValue(ParseTree repeatNode) throws ParseException {
        return ParseTreeUtils.getRepeatValue(repeatNode, 1);
    }

    public static void addBytesMatchingAllBitmask(ParseTree allBitmask, Collection<Byte> bytes) throws ParseException {
        ArgUtils.checkNullObject(allBitmask, "parameter: allBitmask");
        ArgUtils.checkNullCollection(bytes, "parameter: bytes");
        if (allBitmask.isValueInverted()) {
            ByteUtils.addBytesNotMatchingAllBitMask(allBitmask.getByteValue(), bytes);
        } else {
            ByteUtils.addBytesMatchingAllBitMask(allBitmask.getByteValue(), bytes);
        }
    }

    public static void addBytesMatchingAnyBitmask(ParseTree anyBitmask, Collection<Byte> bytes) throws ParseException {
        ArgUtils.checkNullObject(anyBitmask, "parameter: anyBitmask");
        ArgUtils.checkNullCollection(bytes, "parameter: bytes");
        if (anyBitmask.isValueInverted()) {
            ByteUtils.addBytesNotMatchingAnyBitMask(anyBitmask.getByteValue(), bytes);
        } else {
            ByteUtils.addBytesMatchingAnyBitMask(anyBitmask.getByteValue(), bytes);
        }
    }

    public static void addStringBytes(ParseTree string, Collection<Byte> bytes) throws ParseException {
        ArgUtils.checkNullObject(string, "parameter:string");
        ByteUtils.addStringBytes(string.getTextValue(), bytes);
    }

    public static void addCaseInsensitiveStringBytes(ParseTree caseInsensitive, Collection<Byte> bytes) throws ParseException {
        ArgUtils.checkNullObject(caseInsensitive, "parameter:caseInsensitive");
        ByteUtils.addCaseInsensitiveStringBytes(caseInsensitive.getTextValue(), bytes);
    }

    public static Set<Byte> getSetValues(ParseTree set) throws ParseException {
        ArgUtils.checkNullObject(set);
        HashSet<Byte> setValues = new HashSet<Byte>(64);
        for (ParseTree valueNode : set) {
            switch (valueNode.getParseTreeType()) {
                case SET: {
                    ParseTreeUtils.addSetValues(valueNode, setValues);
                    break;
                }
                case BYTE: {
                    ParseTreeUtils.addByteValues(valueNode, setValues);
                    break;
                }
                case RANGE: {
                    ParseTreeUtils.addRangeBytes(valueNode, setValues);
                    break;
                }
                case ALL_BITMASK: {
                    ParseTreeUtils.addBytesMatchingAllBitmask(valueNode, setValues);
                    break;
                }
                case ANY_BITMASK: {
                    ParseTreeUtils.addBytesMatchingAnyBitmask(valueNode, setValues);
                    break;
                }
                case STRING: {
                    ParseTreeUtils.addStringBytes(valueNode, setValues);
                    break;
                }
                case CASE_INSENSITIVE_STRING: {
                    ParseTreeUtils.addCaseInsensitiveStringBytes(valueNode, setValues);
                    break;
                }
                case ANY: {
                    ByteUtils.addAllBytes(setValues);
                    break;
                }
                default: {
                    throw new ParseException(ParseTreeUtils.getTypeError(valueNode));
                }
            }
            if (setValues.size() != 256) continue;
            break;
        }
        return setValues;
    }

    public static void addSetValues(ParseTree setNode, Collection<Byte> bytes) throws ParseException {
        ArgUtils.checkNullCollection(bytes, "parameter:bytes");
        bytes.addAll(ParseTreeUtils.calculateSetValues(setNode));
    }

    public static Set<Byte> calculateSetValues(ParseTree set) throws ParseException {
        ArgUtils.checkNullObject(set);
        Set<Byte> setValues = ParseTreeUtils.getSetValues(set);
        if (set.isValueInverted()) {
            return ByteUtils.invertedSet(setValues);
        }
        return setValues;
    }

    private static int getRangeValue(ParseTree rangeNode, int valueIndex) throws ParseException {
        ArgUtils.checkNullObject(rangeNode);
        if (rangeNode.getParseTreeType() != ParseTreeType.RANGE) {
            throw new ParseException("Node is not a RANGE node.  It has type: " + (Object)((Object)rangeNode.getParseTreeType()));
        }
        int numChildren = rangeNode.getNumChildren();
        if (numChildren != 2) {
            throw new ParseException("Ranges must have two BYTE values as child nodes. Actual number of children was: " + numChildren);
        }
        byte rangeValue = rangeNode.getChild(valueIndex).getByteValue();
        return rangeValue & 0xFF;
    }

    private static int getRepeatValue(ParseTree repeatNode, int valueIndex) throws ParseException {
        ArgUtils.checkNullObject(repeatNode);
        if (repeatNode.getParseTreeType() != ParseTreeType.REPEAT && repeatNode.getParseTreeType() != ParseTreeType.REPEAT_MIN_TO_MANY && repeatNode.getParseTreeType() != ParseTreeType.REPEAT_MIN_TO_MAX) {
            throw new ParseException("Node is not a REPEAT, REPEAT_MIN_TO_MANY or REPEAT_MIN_TO_MAX node.  It has type: " + (Object)((Object)repeatNode.getParseTreeType()));
        }
        ParseTree repeatValue = repeatNode.getChild(valueIndex);
        int intValue = repeatValue.getIntValue();
        if (intValue < 1) {
            throw new ParseException("Repeat integer values must be at least one. Actual value was: " + intValue);
        }
        return intValue;
    }

    private static String getTypeError(ParseTree node) {
        return String.format(TYPE_ERROR, new Object[]{node.getParseTreeType()});
    }
}

