/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser.tree.node;

import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.BaseNode;

public final class ByteNode
extends BaseNode {
    private final byte value;
    private final boolean inverted;

    public static ByteNode valueOf(byte value) {
        return NodeCache.values[value & 0xFF];
    }

    public static ByteNode valueOf(byte value, boolean inverted) {
        return inverted ? new ByteNode(value, true) : ByteNode.valueOf(value);
    }

    public ByteNode(byte value) {
        this(value, false);
    }

    public ByteNode(ParseTreeType type, byte value) {
        this(type, value, false);
    }

    public ByteNode(byte value, boolean inverted) {
        this(ParseTreeType.BYTE, value, inverted);
    }

    public ByteNode(ParseTreeType type, byte value, boolean inverted) {
        super(type);
        this.value = value;
        this.inverted = inverted;
    }

    @Override
    public byte getByteValue() throws ParseException {
        return this.value;
    }

    @Override
    public int getIntValue() throws ParseException {
        return this.value & 0xFF;
    }

    @Override
    public boolean isValueInverted() {
        return this.inverted;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + (Object)((Object)this.getParseTreeType()) + ", value:" + this.value + " inverted: " + this.inverted + ']';
    }

    private static class NodeCache {
        static final ByteNode[] values = new ByteNode[256];

        private NodeCache() {
        }

        static {
            for (int i = 0; i < 256; ++i) {
                NodeCache.values[i] = new ByteNode((byte)(i & 0xFF));
            }
        }
    }
}

