/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import com.google.common.collect.ArrayListMultimap;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVMetadataValue {
    private final String key;
    private final String labelFR;
    private final String labelEN;
    private final String labelDE;

    public CSVMetadataValue(String key, String labelFR, String labelEN, String labelDE) {
        this.key = key;
        this.labelFR = labelFR;
        this.labelEN = labelEN;
        this.labelDE = labelDE;
    }

    private String getLabelFR() {
        return this.labelFR;
    }

    public String getLabelEN() {
        if (this.labelEN != null) {
            return this.labelEN;
        }
        return this.getKey();
    }

    private String getLabelDE() {
        return this.labelDE;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel(String languageString) {
        String label = null;
        try {
            LANGUAGE language = LANGUAGE.valueOf(languageString);
            switch (language) {
                case fr: {
                    label = this.getLabelFR();
                    break;
                }
                case en: {
                    label = this.getLabelEN();
                    break;
                }
                case de: {
                    label = this.getLabelDE();
                    break;
                }
                default: {
                    label = this.getKey();
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.debug((Object)("getLabel failed, languageString: " + languageString + " not supported"), (Throwable)e);
        }
        return label;
    }

    public static List<CSVMetadataValue> getAllowedValuesList(String documentURLString) {
        ArrayList<CSVMetadataValue> valueList = new ArrayList<CSVMetadataValue>();
        URL documentURL = null;
        try {
            documentURL = ResourceUtil.getResourceURL((String)new URL(documentURLString).getFile());
        }
        catch (MalformedURLException e) {
            Logger.error((Object)"getAllowedValuesList failed, due to: ", (Throwable)e);
        }
        ArrayListMultimap allLabels = ArrayListMultimap.create();
        try (InputStream inputStream = documentURL.openStream();
             CSVParser csvParser = CSVParser.parse((InputStream)inputStream, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.newFormat((char)',').withQuote('\"').withRecordSeparator("\r\n").withIgnoreEmptyLines(true).withAllowMissingColumnNames(true).withIgnoreHeaderCase().withTrim());){
            int labelFRIndex = -1;
            int labelENIndex = -1;
            int labelDEIndex = -1;
            for (CSVRecord csvRecord : csvParser) {
                String key = csvRecord.get(0);
                int recordIndex = 1;
                while (csvRecord.size() > recordIndex) {
                    allLabels.put((Object)key, (Object)csvRecord.get(recordIndex++));
                }
                List labelHeaders = null;
                if (csvRecord.getRecordNumber() == 1L) {
                    labelHeaders = allLabels.get((Object)"key");
                    int index = 0;
                    for (String label : labelHeaders) {
                        if (label.equalsIgnoreCase("fr")) {
                            labelFRIndex = index++;
                            continue;
                        }
                        if (label.equalsIgnoreCase("de")) {
                            labelDEIndex = index++;
                            continue;
                        }
                        if (!label.equalsIgnoreCase("en")) continue;
                        labelENIndex = index++;
                    }
                    continue;
                }
                if (csvRecord.getRecordNumber() == 1L) continue;
                List labels = allLabels.get((Object)key);
                CSVMetadataValue value = new CSVMetadataValue(key, CSVMetadataValue.getLabelForIndex(labelFRIndex, labels), CSVMetadataValue.getLabelForIndex(labelENIndex, labels), CSVMetadataValue.getLabelForIndex(labelDEIndex, labels));
                valueList.add(value);
            }
        }
        catch (Exception ex) {
            Logger.error((Object)"getAllowedValuesList failed, due to: ", (Throwable)ex);
        }
        return valueList;
    }

    private static String getLabelForIndex(int labelIndex, List<String> labels) {
        return labelIndex > -1 && labelIndex < labels.size() ? labels.get(labelIndex) : null;
    }

    public static String getCSVLabelEN(List<CSVMetadataValue> csvAllowedValues, String value) {
        for (CSVMetadataValue csvValue : csvAllowedValues) {
            if (!csvValue.getKey().equals(value)) continue;
            value = csvValue.getLabelEN();
        }
        return value;
    }

    public String toString() {
        String language = this.getDefaultLanguage();
        if (this.getLabel(language) != null && !this.getLabel(language).isEmpty()) {
            return this.getLabel(language);
        }
        return this.getKey();
    }

    private String getDefaultLanguage() {
        String language = OperatingSystem.userLanguage();
        if (Locale.getDefault() != null) {
            language = Locale.getDefault().getLanguage();
        }
        return language;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVMetadataValue other = (CSVMetadataValue)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    static enum LANGUAGE {
        fr,
        en,
        de;

    }
}

