/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public final class DroidUrlFormat {
    private static final Pattern WINDOWS_DRIVER_LETTER = Pattern.compile("^[A-Z]:$");
    private static final String WINDOWS_UNC_REFIX = "//";
    private static final String PATH_SPLITER = "/";

    private DroidUrlFormat() {
    }

    public static String format(URI uri) {
        StringBuilder b = new StringBuilder();
        if (!"file".equals(uri.getScheme())) {
            return uri.toString();
        }
        b.append(uri.getScheme()).append(':');
        if (uri.getPath().startsWith(WINDOWS_UNC_REFIX)) {
            b.append(WINDOWS_UNC_REFIX);
        }
        if (uri.getAuthority() != null) {
            b.append(uri.getRawAuthority());
        }
        b.append(DroidUrlFormat.encodePath(uri.getPath()));
        if (uri.getQuery() != null) {
            b.append(uri.getRawQuery());
        }
        if (uri.getFragment() != null) {
            b.append(uri.getRawFragment());
        }
        return b.toString();
    }

    private static String encodePath(String path) {
        String[] parts = path.split(PATH_SPLITER);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == 1 && WINDOWS_DRIVER_LETTER.matcher(parts[i]).matches()) {
                b.append(parts[i]).append('/');
                continue;
            }
            b.append(DroidUrlFormat.encode(parts[i])).append('/');
        }
        if (!path.endsWith(PATH_SPLITER)) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding", ex);
        }
    }
}

