/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.ead;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.ead.ArchDesc;
import ch.docuteam.darc.ead.ComponentAbstract;
import ch.docuteam.darc.ead.Header;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.exception.ExceptionCollectorException;
import ch.docuteam.tools.file.ResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.TreeMap;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Document
extends DocumentAbstract {
    private static final long serialVersionUID = 1L;
    protected static final String DefaultEADTemplateFile = "/templates/ead.xml";
    protected static String EADTemplateFile = "/templates/ead.xml";
    protected Header eadHeader;
    protected ArchDesc archDesc;

    public static Document createEmpty() throws DocumentException, ExceptionCollectorException, UnsupportedEncodingException, IOException {
        return Document.read(EADTemplateFile);
    }

    public static Document read(String filePath) throws DocumentException, ExceptionCollectorException, UnsupportedEncodingException, IOException {
        Document ead = null;
        if (new File(filePath).exists()) {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8");){
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                ead = Document.read(bufferedReader);
                ead.filePath = filePath;
            }
        } else {
            URL resourceURL = ResourceUtil.getResourceURL((String)filePath);
            if (resourceURL == null) {
                throw new FileNotFoundException(filePath);
            }
            ead = Document.read(resourceURL);
            ead.filePath = filePath;
        }
        return ead;
    }

    public static Document read(BufferedReader br) throws DocumentException, ExceptionCollectorException {
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((org.dom4j.DocumentFactory)new DocumentFactory());
        Document ead = (Document)reader.read((Reader)br);
        ExceptionCollector.clear();
        ead.parse();
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            throw new ExceptionCollectorException();
        }
        return ead;
    }

    public static Document read(URL url) throws DocumentException, ExceptionCollectorException {
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((org.dom4j.DocumentFactory)new DocumentFactory());
        Document ead = (Document)reader.read(url);
        ExceptionCollector.clear();
        ead.parse();
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            throw new ExceptionCollectorException();
        }
        return ead;
    }

    public static Document read(StringReader stringReader) throws DocumentException, ExceptionCollectorException {
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory((org.dom4j.DocumentFactory)new DocumentFactory());
        Document ead = (Document)reader.read((Reader)stringReader);
        ead.parse();
        return ead;
    }

    public static void setEADTemplateFile(String newEADTemplateFile) {
        EADTemplateFile = newEADTemplateFile;
    }

    public Header getEADHeader() {
        return this.eadHeader;
    }

    public ArchDesc getArchDesc() {
        return this.archDesc;
    }

    public void setId(String id) {
        this.eadHeader.setEadId(id);
    }

    public String getId() {
        return this.eadHeader.getEadId();
    }

    @Override
    public DocumentAbstract.Type getDocumentType() {
        return DocumentAbstract.Type.EAD;
    }

    public ComponentAbstract searchUnitTitle(String title) {
        return this.archDesc.searchUnitTitle(title);
    }

    public void saveAs(String filePath) throws IOException {
        this.filePath = filePath;
        new File(this.filePath).getParentFile().mkdirs();
        this.save();
    }

    public void save() throws IOException {
        try (OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filePath), "utf-8");){
            XMLWriter writer = new XMLWriter((Writer)oswriter);
            writer.write((org.dom4j.Document)this);
            writer.flush();
            writer.close();
        }
        this.isModified = false;
    }

    public String toString() {
        return "\n====\tEAD-Document on '" + this.filePath + "'" + (this.isModified ? "*" : "") + "\t====\n\t" + this.eadHeader + "\n" + this.archDesc;
    }

    private Document parse() {
        Element root = this.getRootElement();
        this.eadHeader = Header.parse(this, root);
        this.archDesc = ArchDesc.parse(this, root);
        return this;
    }

    private static class DocumentFactory
    extends org.dom4j.DocumentFactory {
        private static final long serialVersionUID = 1L;

        private DocumentFactory() {
        }

        public Document createDocument() {
            TreeMap<String, String> namespaces = new TreeMap<String, String>();
            namespaces.put("EAD", "urn:isbn:1-931666-22-9");
            namespaces.put("xlink", "http://www.w3.org/1999/xlink");
            this.setXPathNamespaceURIs(namespaces);
            Document ead = new Document();
            ead.setDocumentFactory(this);
            return ead;
        }
    }
}

