/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.translations.I18N;

public class MetadataElementValidatorInteger
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorIntegerNotNumeric", (Object[])new Object[]{value}));
        }
        if (value.length() > 10) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorIntegerMax10Digits", (Object[])new Object[]{value}));
        }
        try {
            long number = new Long(value);
            if (number > Integer.MAX_VALUE) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorIntegerMaxValue", (Object[])new Object[]{Integer.MAX_VALUE, value}));
            }
        }
        catch (NumberFormatException ex) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorIntegerCantConvert", (Object[])new Object[]{value}));
        }
    }
}

