/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.structmap;

import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileIsNotReadableException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class NodeFolder
extends NodeAbstract {
    private static final String Type = "folder";
    private static final String RootType = "rootfolder";

    protected NodeFolder() {
    }

    protected NodeFolder(StructureMap parent, Element element) {
        super(parent.getDocument(), element);
        this.initialize();
    }

    protected NodeFolder(NodeFolder parent, Element element) {
        super(parent.getDocument(), element);
        parent.add((MutableTreeTableNode)this);
        this.initialize();
    }

    protected NodeFolder(StructureMap parent, String label) throws IOException, FileUtilExceptionListException {
        super(parent, label);
        FileUtil.createFolderOverwriting((File)this.getFile());
        this.initializeFileAccessRights();
        this.allowsChildren = true;
        this.type = RootType;
        this.element = parent.getElement().addElement("METS:div").addAttribute("LABEL", this.label).addAttribute("TYPE", this.type).addAttribute("ADMID", this.admId);
        new DigiprovWithPremis(this);
        this.createDMDSectionWithEADIfNecessary();
        this.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
    }

    private NodeFolder(NodeFolder parent, String label) throws IOException, FileUtilExceptionListException {
        super(parent, label);
        FileUtil.createFolderOverwriting((File)this.getFile());
        this.initializeFileAccessRights();
        this.allowsChildren = true;
        this.type = Type;
        this.element = ((NodeFolder)this.parent).getElement().addElement("METS:div").addAttribute("LABEL", this.label).addAttribute("TYPE", this.type).addAttribute("ADMID", this.admId);
        new DigiprovWithPremis(this);
        this.createDMDSectionWithEADIfNecessary();
        try {
            this.setLevel(parent.getLevel().getDefaultSubLevel());
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed();
    }

    @Override
    public String getChecksum() {
        return "";
    }

    @Override
    public String getChecksumType() {
        return "";
    }

    @Override
    public String getMimeType() {
        return "";
    }

    @Override
    public String getFormatKey() {
        return "";
    }

    @Override
    public String getFormatName() {
        return "";
    }

    @Override
    public int getDescendantCount() {
        Integer cumulatedCount = this.getChildCount();
        for (MutableTreeTableNode child : this.children) {
            cumulatedCount = cumulatedCount + ((NodeAbstract)child).getDescendantCount();
        }
        return cumulatedCount;
    }

    @Override
    public int getTreeDepth() {
        if (this.children.size() == 0) {
            return 0;
        }
        int maxDepth = 1;
        for (MutableTreeTableNode child : this.children) {
            maxDepth = Math.max(maxDepth, ((NodeAbstract)child).getTreeDepth() + 1);
        }
        return maxDepth;
    }

    public List<MutableTreeTableNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public boolean doesLabelHaveNumericPrefix() {
        return Character.isDigit(this.label.charAt(0));
    }

    public boolean isPredecessorOf(NodeAbstract child) {
        for (NodeFolder parent = (NodeFolder)child.getParent(); parent != null; parent = (NodeFolder)parent.getParent()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendantNotReadableByCurrentUser() {
        for (MutableTreeTableNode c : this.children) {
            NodeAbstract child = (NodeAbstract)c;
            if (!child.fileExists || !child.canRead) {
                return true;
            }
            if (!child.isFolder() || !((NodeFolder)child).hasDescendantNotReadableByCurrentUser()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendantNotWritableByCurrentUser() {
        for (MutableTreeTableNode c : this.children) {
            NodeAbstract child = (NodeAbstract)c;
            if (!child.fileExists || !child.canWrite) {
                return true;
            }
            if (!child.isFolder() || !((NodeFolder)child).hasDescendantNotWritableByCurrentUser()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDescendantNotReadableOrWritableByCurrentUser() {
        for (MutableTreeTableNode c : this.children) {
            NodeAbstract child = (NodeAbstract)c;
            if (!(child.fileExists && child.canWrite && child.canRead)) {
                return true;
            }
            if (!child.isFolder() || !((NodeFolder)child).hasDescendantNotReadableOrWritableByCurrentUser()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkFixity() {
        boolean isOK = true;
        for (MutableTreeTableNode t : this.children) {
            if (((NodeAbstract)t).checkFixity()) continue;
            isOK = false;
        }
        return isOK;
    }

    @Override
    public boolean checkAgainstSubmissionAgreement() {
        return this.checkAgainstSubmissionAgreement(((Document)this.document).getSubmissionAgreement(), ((Document)this.document).getDSSId());
    }

    @Override
    public List<NodeFile> filesNotAllowedBySubmissionAgreement() {
        return this.filesNotAllowedBySubmissionAgreement(((Document)this.document).getSubmissionAgreement(), ((Document)this.document).getDSSId());
    }

    @Override
    public boolean checkAgainstSubmissionAgreement(SubmissionAgreement sa, String dssId) {
        boolean isOK = true;
        for (MutableTreeTableNode t : this.children) {
            if (((NodeAbstract)t).checkAgainstSubmissionAgreement(sa, dssId)) continue;
            isOK = false;
        }
        return isOK;
    }

    @Override
    public List<NodeFile> filesNotAllowedBySubmissionAgreement(SubmissionAgreement sa, String dssId) {
        this.getMyDigiprov();
        Vector<NodeFile> result = new Vector<NodeFile>();
        for (MutableTreeTableNode t : this.children) {
            result.addAll(((NodeAbstract)t).filesNotAllowedBySubmissionAgreement(sa, dssId));
        }
        return result;
    }

    @Override
    public boolean isAllowedBySA() {
        return true;
    }

    @Override
    public boolean hasMimeType() {
        return true;
    }

    @Override
    public boolean hasFormatKey() {
        return true;
    }

    @Override
    public NodeAbstract searchId(String admId) {
        if (this.admId.equals(admId)) {
            return this;
        }
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract found = ((NodeAbstract)child).searchId(admId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public List<NodeAbstract> searchLabel(String label) {
        Vector<NodeAbstract> found = new Vector<NodeAbstract>(10);
        if (this.label.equals(label)) {
            found.add(this);
        }
        for (MutableTreeTableNode child : this.children) {
            found.addAll(((NodeAbstract)child).searchLabel(label));
        }
        return found;
    }

    @Override
    public NodeAbstract searchFileId(String fileId) {
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract found = ((NodeAbstract)child).searchFileId(fileId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void rename(String newLabel) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        String oldRelativePath = this.getPathString();
        String oldAbsolutePath = this.getAbsolutePathString();
        super.rename(newLabel);
        String newRelativePath = this.getPathString();
        String newAbsolutePath = this.getAbsolutePathString();
        for (NodeFile file : this.getDescendantFiles()) {
            file.createNewEvent("Path Modification", "Manually", "Success", "");
            ((Document)this.document).getFileSection().getFile(file.getFileId()).replaceInFilePath(oldRelativePath, newRelativePath);
        }
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void moveTo(NodeFolder toFolder) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(toFolder.label, "MoveTo");
        String oldRelativePath = this.getPathString();
        String oldAbsolutePath = this.getAbsolutePathString();
        super.moveTo(toFolder);
        String newRelativePath = this.getPathString();
        String newAbsolutePath = this.getAbsolutePathString();
        for (NodeFile file : this.getDescendantFiles()) {
            file.createNewEvent("Path Modification", "Manually", "Success", "");
            ((Document)this.document).getFileSection().getFile(file.getFileId()).replaceInFilePath(oldRelativePath, newRelativePath);
        }
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void moveBeforeNode(NodeAbstract node) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException {
        this.checkIfFileOperationNotAllowed(node.label, "MoveBeforeNode");
        String oldRelativePath = this.getPathString();
        String oldAbsolutePath = this.getAbsolutePathString();
        NodeAbstract oldParent = (NodeAbstract)this.getParent();
        NodeAbstract newParent = (NodeAbstract)node.getParent();
        super.moveBeforeNode(node);
        String newRelativePath = this.getPathString();
        String newAbsolutePath = this.getAbsolutePathString();
        for (NodeFile file : this.getDescendantFiles()) {
            if (!oldParent.equals(newParent)) {
                file.createNewEvent("Path Modification", "Manually", "Success", "");
            }
            ((Document)this.document).getFileSection().getFile(file.getFileId()).replaceInFilePath(oldRelativePath, newRelativePath);
        }
        FileUtil.renameTo((String)oldAbsolutePath, (String)newAbsolutePath);
    }

    @Override
    public void delete() throws IOException, FileOperationNotAllowedException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(this.label, "Delete");
        NodeFolder parent = (NodeFolder)this.getParent();
        for (NodeAbstract node : this.getDescendantsDepthFirst()) {
            node.delete();
        }
        String oldAbsolutePath = this.getAbsolutePathString();
        super.delete();
        FileUtil.delete((String)oldAbsolutePath);
        if (parent != null) {
            parent.setOrderRecursive(-1, false);
        }
    }

    public NodeAbstract insertFileOrFolder(String fileOrFolderPath, boolean renameIfNecessary) throws FileNotFoundException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException, FolderNameIsEmptyException {
        this.checkIfFileOperationNotAllowed(fileOrFolderPath, renameIfNecessary ? "InsertFileOrFolderRenameIfNecessary" : "InsertFileOrFolder");
        NodeAbstract returnNode = null;
        returnNode = new File(fileOrFolderPath).isFile() ? this.insertFile(fileOrFolderPath, renameIfNecessary) : this.insertFolder(fileOrFolderPath, renameIfNecessary);
        if (returnNode != null) {
            this.setOrderRecursive(-1, false);
        }
        return returnNode;
    }

    public NodeAbstract insertFileOrFolder(String fileOrFolderPath) throws FileNotFoundException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException, FolderNameIsEmptyException {
        return this.insertFileOrFolder(fileOrFolderPath, false);
    }

    public NodeFolder createNewFolder(String newFolderName) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException {
        return this.createNewFolder(newFolderName, false);
    }

    public NodeFolder createNewFolder(String newFolderName, boolean renameIfNecessary) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException {
        this.checkIfFileOperationNotAllowed(newFolderName, "InsertNewFolder");
        if (newFolderName == null || newFolderName.isEmpty()) {
            throw new FolderNameIsEmptyException();
        }
        String sanitizedNewFolderName = FileUtil.asBasicSafeFileName((String)newFolderName);
        if (this.doesAlreadyContainChildWithThisName(sanitizedNewFolderName) && renameIfNecessary) {
            sanitizedNewFolderName = FileUtil.createUniqueFolderNameByAppendingIndex((String)sanitizedNewFolderName, (String[])this.getFile().list());
        }
        if (this.doesAlreadyContainChildWithThisName(sanitizedNewFolderName)) {
            throw new FileAlreadyExistsException(sanitizedNewFolderName, this.getPathString());
        }
        NodeFolder newNodeFolder = new NodeFolder(this, sanitizedNewFolderName);
        if (!sanitizedNewFolderName.equals(newFolderName)) {
            newNodeFolder.getMyDigiprov().addNewFirstEvent("Renaming", "Renamed from '" + newFolderName + "' to '" + sanitizedNewFolderName + "'", "Success", "");
        }
        this.setOrderRecursive(-1, false);
        return newNodeFolder;
    }

    @Override
    public Long getSize() {
        Long cumulatedSize = 0L;
        for (MutableTreeTableNode child : this.children) {
            cumulatedSize = cumulatedSize + ((NodeAbstract)child).getSize();
        }
        return cumulatedSize;
    }

    public boolean doesAlreadyContainChildWithThisName(String newFileOrFolderName) throws IOException {
        Path newChildPath = Paths.get(this.getFile().getAbsolutePath(), newFileOrFolderName);
        return Files.exists(newChildPath, new LinkOption[0]);
    }

    public void insert(MutableTreeTableNode child, int index) {
        super.insert(child, index);
        this.document.setIsModified();
    }

    public List<NodeAbstract> getDescendants() {
        Vector<NodeAbstract> descendants = new Vector<NodeAbstract>();
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract aChild = (NodeAbstract)child;
            descendants.add(aChild);
            if (!aChild.isFolder()) continue;
            descendants.addAll(((NodeFolder)aChild).getDescendants());
        }
        return descendants;
    }

    public List<NodeAbstract> getDescendantsDepthFirst() {
        Vector<NodeAbstract> descendants = new Vector<NodeAbstract>();
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract aChild = (NodeAbstract)child;
            if (aChild.isFolder()) {
                descendants.addAll(((NodeFolder)aChild).getDescendantsDepthFirst());
            }
            descendants.add(aChild);
        }
        return descendants;
    }

    @Override
    public List<NodeAbstract> getWithDescendants() {
        ArrayList<NodeAbstract> all = new ArrayList<NodeAbstract>();
        all.add(this);
        all.addAll(this.getDescendants());
        return all;
    }

    @Override
    public List<NodeAbstract> getWithDescendantsDepthFirst() {
        ArrayList<NodeAbstract> all = new ArrayList<NodeAbstract>();
        all.addAll(this.getDescendantsDepthFirst());
        all.add(this);
        return all;
    }

    public List<NodeFile> getDescendantFiles() {
        Vector<NodeFile> descendantFiles = new Vector<NodeFile>();
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract aChild = (NodeAbstract)child;
            if (aChild.isFile()) {
                descendantFiles.add((NodeFile)aChild);
                continue;
            }
            descendantFiles.addAll(((NodeFolder)aChild).getDescendantFiles());
        }
        return descendantFiles;
    }

    public List<NodeFolder> getDescendantFolders() {
        Vector<NodeFolder> descendantFolders = new Vector<NodeFolder>();
        for (MutableTreeTableNode child : this.children) {
            NodeAbstract node = (NodeAbstract)child;
            if (!node.isFolder()) continue;
            NodeFolder folder = (NodeFolder)node;
            descendantFolders.add(folder);
            descendantFolders.addAll(folder.getDescendantFolders());
        }
        return descendantFolders;
    }

    @Override
    protected String compareString() {
        return "1" + this.getLabel();
    }

    @Override
    public String toString() {
        return "[" + (this.isRoot() != false ? "Root" : "") + "StructureMapFolder:" + this.label + "[" + this.getLevel() + "](admId=" + this.admId + "/dmdIdOAI=" + this.dmdIdOAI_DC + "/dmdIdEAD=" + this.dmdIdEAD + ")(children:" + this.children.size() + ")" + (this.fileExists ? "D" : "d") + (this.canRead ? "R" : "r") + (this.canWrite ? "W" : "w") + (this.canExecute ? "X" : "x") + "^" + (this.hasPredecessorNotReadableByCurrentUser() ? "r" : "R") + (this.hasPredecessorNotWritableByCurrentUser() ? "w" : "W") + "v" + (this.hasDescendantNotReadableByCurrentUser() ? "r" : "R") + (this.hasDescendantNotWritableByCurrentUser() ? "w" : "W") + "(" + (Object)((Object)this.getSubmitStatus()) + ")]";
    }

    @Override
    public String treeString(Integer indent) {
        StringBuilder buf = new StringBuilder(200);
        buf.append("\n");
        for (int i = 0; i < indent; ++i) {
            buf.append("\t");
        }
        buf.append(this.toString());
        for (MutableTreeTableNode child : this.children) {
            buf.append(((NodeAbstract)child).treeString(indent + 1));
        }
        return buf.toString();
    }

    protected void initialize() {
        this.initializeFileAccessRights();
        this.allowsChildren = true;
        List children = this.element.selectNodes("./METS:div[@TYPE = 'file' or @TYPE = 'folder']");
        children.sort(new Comparator<Node>(){

            @Override
            public int compare(Node div1, Node div2) {
                Node order1 = div1.selectSingleNode("@ORDER");
                Node order2 = div2.selectSingleNode("@ORDER");
                if (order1 != null && order2 != null) {
                    return Integer.valueOf(div1.selectSingleNode("@ORDER").getText()) - Integer.valueOf(div2.selectSingleNode("@ORDER").getText());
                }
                return 0;
            }
        });
        for (Object o : children) {
            NodeFolder.parse(this, (Element)o);
        }
    }

    protected NodeFile insertFile(String sourceFilePath, boolean renameIfNecessary) throws FileNotFoundException, IOException, FileAlreadyExistsException {
        Logger.debug((Object)(this.label + ": Inserting file: '" + sourceFilePath + "'"));
        File file = new File(sourceFilePath);
        if (!file.exists()) {
            throw new FileNotFoundException("File to be inserted does not exist: " + sourceFilePath);
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File to be inserted is a folder: " + sourceFilePath);
        }
        if (file.isHidden()) {
            return null;
        }
        if (!file.canRead()) {
            ch.docuteam.tools.exception.Exception.remember((Throwable)new FileIsNotReadableException(file));
            return null;
        }
        SubmissionAgreement sa = ((Document)this.document).getSubmissionAgreement();
        if (sa != null && !sa.allowsFile(((Document)this.document).getDSSId(), sourceFilePath)) {
            ch.docuteam.tools.exception.Exception.rememberWithType((String[])new String[]{"Submission Agreement '" + this.getDocument().getSAId() + "' Data Submission Session '" + this.getDocument().getDSSId() + "' doesn't allow file '" + sourceFilePath + "'", NodeAbstract.ExceptionTypes.SA_DOESNT_ALLOW_FILE.label, this.getDocument().getSAId(), this.getDocument().getDSSId(), file.getPath()});
            return null;
        }
        String sourceFileName = file.getName();
        String sanitizedDestFileName = FileUtil.asBasicSafeFileName((String)sourceFileName);
        if (this.doesAlreadyContainChildWithThisName(sanitizedDestFileName) && renameIfNecessary) {
            sanitizedDestFileName = FileUtil.createUniqueFileNameByAppendingIndex((String)sanitizedDestFileName, (String[])this.getFile().list());
        }
        if (this.doesAlreadyContainChildWithThisName(sanitizedDestFileName)) {
            throw new FileAlreadyExistsException(sanitizedDestFileName, this.getPathString());
        }
        this.document.distributeMessage(sanitizedDestFileName);
        try {
            FileUtil.copyToOverwriting((String)sourceFilePath, (String)(this.getAbsolutePathString() + "/" + sanitizedDestFileName), (boolean)true);
        }
        catch (FileUtilExceptionListException ex) {
            ch.docuteam.tools.exception.Exception.remember((Throwable)ex);
        }
        ch.docuteam.darc.mets.filesec.File newFileSectionFile = new ch.docuteam.darc.mets.filesec.File(this.document, this.getPathString() + "/" + sanitizedDestFileName);
        NodeFile newNodeFile = new NodeFile(this, newFileSectionFile);
        newNodeFile.checkMimeType();
        newNodeFile.checkFormatKey();
        if (!sanitizedDestFileName.equals(sourceFileName)) {
            newNodeFile.getMyDigiprov().addNewFirstEvent("Renaming", "Old name: '" + sourceFileName + "', new name: '" + sanitizedDestFileName + "'", "Success", "");
        }
        Logger.debug((Object)(this.label + ": Inserted file: '" + sanitizedDestFileName + "'"));
        return newNodeFile;
    }

    protected NodeAbstract insertFolder(String sourceFolderPath, boolean renameIfNecessary) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FileUtilExceptionListException, FolderNameIsEmptyException {
        String sanitizedDestFolderName;
        Logger.debug((Object)(this.label + ": Inserting folder: '" + sourceFolderPath + "'"));
        File folder = new File(sourceFolderPath);
        if (!folder.exists()) {
            throw new FileNotFoundException("Folder to be inserted does not exist: " + sourceFolderPath);
        }
        if (folder.isFile()) {
            throw new FileNotFoundException("Folder to be inserted is a file: " + sourceFolderPath);
        }
        if (folder.isHidden()) {
            return null;
        }
        if (!folder.canRead()) {
            ch.docuteam.tools.exception.Exception.remember((Throwable)new FileIsNotReadableException(folder));
            return null;
        }
        String sourceFolderName = folder.getName();
        String sanitizedSourceFolderName = FileUtil.asBasicSafeFileName((String)sourceFolderName);
        if (sanitizedSourceFolderName.isEmpty()) {
            sanitizedSourceFolderName = sanitizedSourceFolderName.substring(0, 1);
        }
        if (this.doesAlreadyContainChildWithThisName(sanitizedDestFolderName = sanitizedSourceFolderName) && renameIfNecessary) {
            sanitizedDestFolderName = FileUtil.createUniqueFolderNameByAppendingIndex((String)sanitizedDestFolderName, (String[])this.getFile().list());
        }
        if (this.doesAlreadyContainChildWithThisName(sanitizedDestFolderName)) {
            throw new FileAlreadyExistsException(sanitizedDestFolderName, this.getPathString());
        }
        NodeFolder newNodeFolder = this.createNewFolder(sanitizedDestFolderName);
        if (!sanitizedDestFolderName.equals(sourceFolderName)) {
            newNodeFolder.getMyDigiprov().addNewFirstEvent("Renaming", "Old name: '" + sourceFolderName + "', new name: '" + sanitizedDestFolderName + "'", "Success", "");
        }
        Logger.debug((Object)(this.label + ": Inserted folder: '" + sanitizedDestFolderName + "'"));
        File[] listFiles = folder.listFiles((FilenameFilter)FileFilter.VisibleAll);
        if (listFiles != null) {
            for (File f : listFiles) {
                newNodeFolder.insertFileOrFolder(f.getPath(), renameIfNecessary);
            }
        }
        newNodeFolder.getFile().setExecutable(folder.canExecute());
        newNodeFolder.getFile().setWritable(folder.canWrite());
        newNodeFolder.getFile().setReadable(folder.canRead());
        newNodeFolder.initializeFileAccessRights();
        return newNodeFolder;
    }
}

