/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.exception.FileDeletionNoPermissionException;
import ch.docuteam.tools.file.exception.FileIsNotReadableException;
import ch.docuteam.tools.file.exception.FileIsNotWritableException;
import ch.docuteam.tools.file.exception.FileUtilException;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.file.exception.FolderIsNotEmptyException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.function.BiFunction;
import org.apache.commons.io.FileUtils;

public abstract class FileUtil {
    public static final Charset AsciiCharset = Charset.forName("ASCII");
    public static final String SafeFileNameAllowedChars = "_.-";
    public static final Character SafeFileNameReplacementChar = Character.valueOf('_');
    public static final String FileExtensionSeparator = ".";
    private static final String DefaultTempFolder;
    private static String TempFolder;
    private static List<FileUtilException> FileUtilExceptions;

    public static String getTempFolder() {
        return TempFolder;
    }

    public static void setTempFolder(String newTempFolderName) {
        if (newTempFolderName == null || newTempFolderName.trim().isEmpty()) {
            return;
        }
        File newTempFolder = new File(newTempFolderName);
        if (!newTempFolder.exists() && !newTempFolder.mkdirs()) {
            throw new IllegalArgumentException("Could not create new temp-folder: " + newTempFolderName);
        }
        TempFolder = newTempFolderName;
        Logger.info("Temp-folder set to: " + newTempFolderName);
    }

    public static File copyToFolderOverwriting(String fileName, String toFolderName) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderOverwriting(fileName, toFolderName, false);
    }

    public static File copyToFolderOverwriting(File sourceFile, File toFolder) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderOverwriting(sourceFile, toFolder, false);
    }

    public static File copyToFolderMerging(String fileName, String toFolderName) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderMerging(fileName, toFolderName, false);
    }

    public static File copyToFolderMerging(File sourceFile, File toFolder) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderMerging(sourceFile, toFolder, false);
    }

    public static File copyToOverwriting(File sourceFile, File destFile) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToOverwriting(sourceFile, destFile, false);
    }

    public static File copyToOverwriting(String sourceFileName, String destFileName) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToOverwriting(sourceFileName, destFileName, false);
    }

    public static File copyToMerging(File sourceFile, File toFolder) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToMerging(sourceFile, toFolder, false);
    }

    public static File copyToMerging(String fileName, String toFolderName) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToMerging(fileName, toFolderName, false);
    }

    public static File copyToFolderOverwriting(String fileName, String toFolderName, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.basicCopyToFolder(fileName, toFolderName, true, preserving);
    }

    public static File copyToFolderOverwriting(File sourceFile, File toFolder, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderOverwriting(sourceFile.getPath(), toFolder.getPath(), preserving);
    }

    public static File copyToFolderMerging(String fileName, String toFolderName, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.basicCopyToFolder(fileName, toFolderName, false, preserving);
    }

    public static File copyToFolderMerging(File sourceFile, File toFolder, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToFolderMerging(sourceFile.getPath(), toFolder.getPath(), preserving);
    }

    public static File copyToOverwriting(File sourceFile, File destFile, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.basicCopyTo(sourceFile, destFile, true, preserving);
    }

    public static File copyToOverwriting(String sourceFileName, String destFileName, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToOverwriting(new File(sourceFileName), new File(destFileName), preserving);
    }

    public static File copyToMerging(File sourceFile, File toFolder, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.basicCopyTo(sourceFile, toFolder, false, preserving);
    }

    public static File copyToMerging(String fileName, String toFolderName, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.copyToMerging(new File(fileName), new File(toFolderName), preserving);
    }

    public static File copySourceFileInTemp(File sourceFile) throws IOException, FileUtilExceptionListException {
        String filePath = sourceFile.getAbsolutePath();
        if (OperatingSystem.isWindows() && filePath.length() >= 255) {
            String originalFilePath = filePath;
            File tempFolder = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), null, new FileAttribute[0]).toFile();
            tempFolder.mkdirs();
            FileUtil.deleteOnExit_NoCheck(tempFolder);
            filePath = Paths.get(tempFolder.getPath(), sourceFile.getName()).toString();
            if (filePath.length() >= 255) {
                filePath = Files.createTempFile(tempFolder.toPath(), FileUtil.asFileNameWithoutExtension(sourceFile).substring(0, 50), FileExtensionSeparator + FileUtil.asFileNameExtension(filePath), new FileAttribute[0]).toString();
            }
            Logger.debug("Too long paths, using temp file: " + filePath);
            FileUtil.copyToOverwriting(originalFilePath, filePath);
            sourceFile = new File(filePath);
        }
        return sourceFile;
    }

    public static File delete(String fileName) throws FileUtilExceptionListException {
        return FileUtil.delete(new File(fileName));
    }

    public static File delete(File file) throws FileUtilExceptionListException {
        return FileUtil.basicDelete(file);
    }

    public static void deleteOnExit(String fileName) throws FileUtilExceptionListException {
        FileUtil.deleteOnExit(new File(fileName));
    }

    public static void deleteOnExit(File file) throws FileUtilExceptionListException {
        FileUtil.basicDeleteOnExit(file);
    }

    public static void deleteOnExit_NoCheck(String fileName) {
        FileUtil.deleteOnExit_NoCheck(new File(fileName));
    }

    public static void deleteOnExit_NoCheck(File file) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.deleteQuietly((File)file)));
    }

    public static void setWritable(String fileName) {
        FileUtil.setWritable(new File(fileName));
    }

    public static void setWritable(File file) {
        FileUtil.basicSetWritableRecursively(file);
    }

    public static File renameTo(String oldName, String newName) throws IOException {
        return FileUtil.renameTo(new File(oldName), new File(newName));
    }

    public static File renameTo(File oldFile, File newFile) throws IOException {
        Logger.info("Renaming file: '" + oldFile.getPath() + "' to: '" + newFile.getPath() + "'");
        if (!oldFile.exists()) {
            throw new IOException("Source File '" + oldFile.getPath() + "' doesn't exist.");
        }
        newFile.getParentFile().mkdirs();
        Files.move(Paths.get(oldFile.getPath(), new String[0]), Paths.get(newFile.getPath(), new String[0]), new CopyOption[0]);
        Logger.debug("Renamed file: '" + oldFile.getPath() + "' to: '" + newFile.getPath() + "'");
        return newFile;
    }

    public static File moveToFolder(String fileName, String toFolderName) throws IOException {
        return FileUtil.moveToFolder(new File(fileName), new File(toFolderName));
    }

    public static File moveToFolder(File sourceFile, File toFolder) throws IOException {
        return FileUtil.renameTo(sourceFile, new File(toFolder.getPath() + "/" + sourceFile.getName()));
    }

    public static File moveTo(String oldName, String newName) throws IOException {
        return FileUtil.moveTo(new File(oldName), new File(newName));
    }

    public static File moveTo(File oldFile, File newFile) throws IOException {
        return FileUtil.renameTo(oldFile, newFile);
    }

    public static File createFolderOverwriting(String folderName, String inFolderName) throws IOException, FileUtilExceptionListException {
        return FileUtil.createFolderOverwriting(folderName, new File(inFolderName));
    }

    public static File createFolderOverwriting(String folderName, File inFolder) throws IOException, FileUtilExceptionListException {
        return FileUtil.createFolderOverwriting(inFolder.getPath() + "/" + folderName);
    }

    public static File createFolderOverwriting(String newFolderName) throws IOException, FileUtilExceptionListException {
        return FileUtil.createFolderOverwriting(new File(newFolderName));
    }

    public static File createFolderOverwriting(File newFolder) throws IOException, FileUtilExceptionListException {
        Logger.info("Creating folder (overwriting): '" + newFolder.getPath() + "'");
        if (newFolder.exists()) {
            FileUtil.delete(newFolder);
        }
        if (!newFolder.mkdirs()) {
            throw new IOException("Could not create folder '" + newFolder.getPath() + "'");
        }
        return newFolder;
    }

    public static File createFolderMerging(String folderName, String inFolderName) throws IOException {
        return FileUtil.createFolderMerging(folderName, new File(inFolderName));
    }

    public static File createFolderMerging(String folderName, File inFolder) throws IOException {
        return FileUtil.createFolderMerging(inFolder.getPath() + "/" + folderName);
    }

    public static File createFolderMerging(String newFolderName) throws IOException {
        return FileUtil.createFolderMerging(new File(newFolderName));
    }

    public static File createFolderMerging(File newFolder) throws IOException {
        Logger.info("Creating folder (merging): '" + newFolder.getPath() + "'");
        if (!newFolder.exists() && !newFolder.mkdirs()) {
            throw new IOException("Could not create folder '" + newFolder.getPath() + "'");
        }
        return newFolder;
    }

    public static String getFileContentAsString(File file) {
        return FileUtil.getFileContentAsString(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContentAsString(String filePath) {
        StringBuilder text = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(filePath));
            do {
                if ((line = reader.readLine()) == null) {
                    break;
                }
                text.append(line).append("\n");
            } while (line != null);
        }
        catch (FileNotFoundException e) {
            Logger.warn("File not found: " + filePath, e);
        }
        catch (IOException e) {
            Logger.warn("Error reading file: " + filePath, e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logger.warn("Error closing file: " + filePath, e);
            }
        }
        return text.toString();
    }

    public static File createFileWithContent(String filePath, String content) throws IOException {
        return FileUtil.createFileWithContent(new File(filePath), content);
    }

    public static File createFileWithContent(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        try (OutputStream out = null;){
            out = new BufferedOutputStream(new FileOutputStream(file));
            if (content != null) {
                out.write(content.getBytes());
            }
        }
        return file;
    }

    public static Integer countLines(String filePath) {
        return FileUtil.countLines(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer countLines(File file) {
        FileReader reader = null;
        BufferedReader lineNumberReader = null;
        int lineCounter = 0;
        try {
            reader = new FileReader(file);
            lineNumberReader = new LineNumberReader(reader);
            while (((LineNumberReader)lineNumberReader).readLine() != null) {
                ++lineCounter;
            }
        }
        catch (FileNotFoundException e) {
            Logger.warn("File not found: " + file.getAbsolutePath(), e);
            Integer n = null;
            return n;
        }
        catch (IOException e) {
            Logger.warn("Error reading file: " + file.getAbsolutePath(), e);
            Integer n = null;
            return n;
        }
        finally {
            if (lineNumberReader != null) {
                try {
                    lineNumberReader.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lineCounter + 1;
    }

    public static boolean areOnSameVolume(String fileName1, String fileName2) {
        return FileUtil.areOnSameVolume(new File(fileName1), new File(fileName2));
    }

    public static boolean areOnSameVolume(File file1, File file2) {
        String path1 = file1.getAbsolutePath();
        String path2 = file2.getAbsolutePath();
        if (path1.charAt(1) == ':' && path2.charAt(1) == ':') {
            return path1.charAt(0) == path2.charAt(0);
        }
        int i1 = StringUtil.indexOf(path1, "/", 3);
        int i2 = StringUtil.indexOf(path2, "/", 3);
        String vol1 = path1.substring(0, i1 != -1 ? i1 : path1.length());
        String vol2 = path2.substring(0, i2 != -1 ? i2 : path2.length());
        return vol1.equals(vol2);
    }

    public static long parseStringAsFileSize(String size) {
        if (!size.matches("\\d+(KB|MB|GB)")) {
            throw new IllegalArgumentException("Input \"" + size + "\" does not meet requirements.");
        }
        long length = Long.parseLong(size.substring(0, size.length() - 2));
        switch (size.substring(size.length() - 2)) {
            case "GB": {
                return length * (long)Math.pow(1024.0, 3.0);
            }
            case "MB": {
                return length * (long)Math.pow(1024.0, 2.0);
            }
            case "KB": {
                return length * 1024L;
            }
        }
        return -1L;
    }

    public static String getHumanReadableFileSize(File file) {
        if (!file.exists()) {
            return null;
        }
        return FileUtil.getHumanReadableFileSize(file.length());
    }

    public static String getHumanReadableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String asBasicSafeFileName(String fileOrFolderName) {
        String sanitizedFileOrFolderName = fileOrFolderName.trim();
        if (sanitizedFileOrFolderName.isEmpty()) {
            sanitizedFileOrFolderName = fileOrFolderName.replaceAll("[\\s]", SafeFileNameReplacementChar.toString());
        }
        sanitizedFileOrFolderName = sanitizedFileOrFolderName.replaceAll("[\\\\/:\"*?<>|\\n\\t\\r\\f]", SafeFileNameReplacementChar.toString());
        sanitizedFileOrFolderName = sanitizedFileOrFolderName.replaceAll("\\.$", SafeFileNameReplacementChar.toString());
        return sanitizedFileOrFolderName;
    }

    public static String asStrictSafeFileName(String fileOrFolderName) {
        String safeFileName = FileUtil.asBasicSafeFileName(fileOrFolderName);
        safeFileName = safeFileName.replace("\u00e4", "ae");
        safeFileName = safeFileName.replace("\u00c4", "Ae");
        safeFileName = safeFileName.replace("\u00f6", "oe");
        safeFileName = safeFileName.replace("\u00d6", "Oe");
        safeFileName = safeFileName.replace("\u00fc", "ue");
        safeFileName = safeFileName.replace("\u00dc", "Ue");
        safeFileName = safeFileName.replace("\u00df", "ss");
        safeFileName = safeFileName.replace("\u00e9", "e");
        safeFileName = safeFileName.replace("\u00c9", "E");
        safeFileName = safeFileName.replace("\u00e8", "e");
        safeFileName = safeFileName.replace("\u00c8", "E");
        safeFileName = safeFileName.replace("\u00ea", "e");
        safeFileName = safeFileName.replace("\u00ca", "E");
        safeFileName = safeFileName.replace("\u00e0", "a");
        safeFileName = safeFileName.replace("\u00c0", "A");
        safeFileName = safeFileName.replace("\u00e2", "a");
        safeFileName = safeFileName.replace("\u00c2", "A");
        safeFileName = safeFileName.replace("\u00e7", "c");
        safeFileName = safeFileName.replace("\u00c7", "C");
        safeFileName = safeFileName.replace("\u00f1", "n");
        safeFileName = safeFileName.replace("\u00d1", "N");
        safeFileName = new String(safeFileName.getBytes(AsciiCharset));
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < safeFileName.length(); ++i) {
            char c = safeFileName.charAt(i);
            if (Character.isLetterOrDigit(c) || SafeFileNameAllowedChars.indexOf(c) != -1) {
                result.append(c);
                continue;
            }
            result.append(SafeFileNameReplacementChar);
        }
        return result.toString();
    }

    public static String asStrictSafeFileName(File f) {
        return FileUtil.asStrictSafeFileName(f.getName());
    }

    public static String asCanonicalFileName(String fileName) {
        return FileUtil.asCanonicalFileName(new File(fileName));
    }

    public static String asCanonicalFileName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isFileNameAllowed(String fileOrFolderName) {
        String sanitizedFileOrFolderName = FileUtil.asBasicSafeFileName(fileOrFolderName);
        return fileOrFolderName.equals(sanitizedFileOrFolderName);
    }

    public static String createUniqueFileNameByAppendingUniqueId(String filename, String[] valuesToExclude) {
        return FileUtil.createUniqueFileNameByAppendingUniqueId(filename, Arrays.asList(valuesToExclude));
    }

    public static String createUniqueFileNameByAppendingUniqueId(String filename, Collection<String> valuesToExclude) {
        return FileUtil.createUniqueFileOrFolderNameByAppendingUniqueId(filename, FileUtil::appendSuffixToFileName, valuesToExclude);
    }

    public static String createUniqueFolderNameByAppendingUniqueId(String foldername, String[] valuesToExclude) {
        return FileUtil.createUniqueFolderNameByAppendingUniqueId(foldername, Arrays.asList(valuesToExclude));
    }

    public static String createUniqueFolderNameByAppendingUniqueId(String folderName, Collection<String> valuesToExclude) {
        return FileUtil.createUniqueFileOrFolderNameByAppendingUniqueId(folderName, FileUtil::appendSuffixToFolderName, valuesToExclude);
    }

    public static String createUniqueFileNameByAppendingIndex(String filename, String[] valuesToExclude) {
        return FileUtil.createUniqueFileNameByAppendingIndex(filename, Arrays.asList(valuesToExclude));
    }

    public static String createUniqueFileNameByAppendingIndex(String filename, Collection<String> valuesToExclude) {
        return FileUtil.createUniqueFileOrFolderNameByAppendingIndex(filename, FileUtil::appendSuffixToFileName, valuesToExclude);
    }

    public static String createUniqueFolderNameByAppendingIndex(String foldername, String[] valuesToExclude) {
        return FileUtil.createUniqueFolderNameByAppendingIndex(foldername, Arrays.asList(valuesToExclude));
    }

    public static String createUniqueFolderNameByAppendingIndex(String folderName, Collection<String> valuesToExclude) {
        return FileUtil.createUniqueFileOrFolderNameByAppendingIndex(folderName, FileUtil::appendSuffixToFolderName, valuesToExclude);
    }

    public static String asFilePathWithoutExtension(String filePath) {
        String fileName = FileUtil.asFileName(filePath);
        if (fileName.contains(FileExtensionSeparator)) {
            return filePath.substring(0, filePath.lastIndexOf(FileExtensionSeparator));
        }
        return filePath;
    }

    public static String asFilePathWithoutExtension(File file) {
        return FileUtil.asFilePathWithoutExtension(file.getPath());
    }

    public static String asFileNameWithoutExtension(String filePath) {
        String fileName = FileUtil.asFileName(filePath);
        if (fileName.contains(FileExtensionSeparator)) {
            return fileName.substring(0, fileName.lastIndexOf(FileExtensionSeparator));
        }
        return fileName;
    }

    public static String asFileNameWithoutExtension(File file) {
        return FileUtil.asFileNameWithoutExtension(file.getName());
    }

    public static String asFileNameExtension(String filePath) {
        String fileName = FileUtil.asFileName(filePath);
        if (fileName.contains(FileExtensionSeparator)) {
            return filePath.substring(filePath.lastIndexOf(FileExtensionSeparator) + 1);
        }
        return "";
    }

    public static String asFileNameExtension(File file) {
        return FileUtil.asFileNameExtension(file.getName());
    }

    public static String asFileName(String filePath) {
        return FileUtil.asFileName(new File(filePath));
    }

    public static String asFileName(File file) {
        return file.getName();
    }

    public static String asParentPath(String filePath) {
        return FileUtil.asParentPath(new File(filePath));
    }

    public static String asParentPath(File file) {
        return file.getParent();
    }

    private static List<FileUtilException> consumeFileUtilExceptions() {
        try {
            List<FileUtilException> list = FileUtilExceptions;
            return list;
        }
        finally {
            FileUtil.clearFileUtilExceptions();
        }
    }

    private static void clearFileUtilExceptions() {
        FileUtilExceptions = new Vector<FileUtilException>(10);
    }

    private static File basicCopyToFolder(String fileName, String toFolderName, boolean overwriting, boolean preserving) throws IOException, FileUtilExceptionListException {
        return FileUtil.basicCopyTo(new File(fileName), new File(toFolderName + "/" + new File(fileName).getName()), overwriting, preserving);
    }

    private static File basicCopyTo(File sourceFile, File destFile, boolean overwriting, boolean preserving) throws IOException, FileUtilExceptionListException {
        if (sourceFile.equals(destFile)) {
            Logger.debug("Source equals destination, not copying: '" + sourceFile.getPath() + "'");
            return destFile;
        }
        Logger.info("Copying file or folder: '" + sourceFile.getPath() + "' to file or folder: '" + destFile.getPath() + "'");
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile.getAbsolutePath());
        }
        FileUtil.clearFileUtilExceptions();
        if (overwriting) {
            FileUtil.basicDeleteRecursively(destFile);
        }
        FileUtil.basicCopyToRecursively(sourceFile, destFile, preserving);
        if (!FileUtilExceptions.isEmpty()) {
            throw new FileUtilExceptionListException(FileUtil.consumeFileUtilExceptions());
        }
        return destFile;
    }

    private static File basicDelete(File file) throws FileUtilExceptionListException {
        FileUtil.clearFileUtilExceptions();
        File returnFile = FileUtil.basicDeleteRecursively(file);
        if (!FileUtilExceptions.isEmpty()) {
            throw new FileUtilExceptionListException(FileUtil.consumeFileUtilExceptions());
        }
        return returnFile;
    }

    private static void basicDeleteOnExit(File file) throws FileUtilExceptionListException {
        FileUtil.clearFileUtilExceptions();
        FileUtil.basicDeleteOnExitRecursively(file);
        if (!FileUtilExceptions.isEmpty()) {
            throw new FileUtilExceptionListException(FileUtil.consumeFileUtilExceptions());
        }
    }

    private static void basicCopyToRecursively(File sourceFile, File destFile, boolean doPreserveAccessRights) throws IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile.getAbsolutePath());
        }
        if (!sourceFile.canRead()) {
            FileUtilExceptions.add(new FileIsNotReadableException(sourceFile));
            return;
        }
        if (destFile.exists() && !destFile.canRead()) {
            FileUtilExceptions.add(new FileIsNotReadableException(destFile));
            return;
        }
        if (destFile.exists() && !destFile.canWrite()) {
            FileUtilExceptions.add(new FileIsNotWritableException(destFile));
            return;
        }
        if (sourceFile.isDirectory()) {
            Logger.debug("Creating folder: '" + destFile + "'");
            destFile.mkdirs();
            for (File f : sourceFile.listFiles()) {
                FileUtil.basicCopyToRecursively(f, new File(destFile + "/" + f.getName()), doPreserveAccessRights);
            }
        } else {
            destFile.getParentFile().mkdirs();
            FileUtil.basicCopyFilePhysically(sourceFile, destFile);
        }
        if (!doPreserveAccessRights) {
            destFile.setWritable(true, true);
            destFile.setExecutable(true, true);
        }
    }

    private static File basicDeleteRecursively(File file) {
        if (!file.exists()) {
            return null;
        }
        File parent = file.getParentFile();
        if (file.isDirectory()) {
            Logger.info("Deleting folder: '" + file.getPath() + "'");
            for (File f : file.listFiles()) {
                FileUtil.basicDeleteRecursively(f);
            }
            if (file.list().length != 0) {
                FileUtilExceptions.add(new FolderIsNotEmptyException(file));
                return null;
            }
        } else {
            Logger.info("Deleting file: '" + file.getPath() + "'");
        }
        boolean success = false;
        for (int i = 20; i > 0; --i) {
            if (file.delete()) {
                Logger.debug("Deleted: '" + file.getPath() + "'");
                success = true;
                break;
            }
            Logger.debug("Retrying: " + i);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!success) {
            FileUtilExceptions.add(new FileDeletionNoPermissionException(file));
            return null;
        }
        return file;
    }

    private static void basicDeleteOnExitRecursively(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.canWrite() || !file.canRead()) {
            FileUtilExceptions.add(new FileDeletionNoPermissionException(file));
            return;
        }
        file.deleteOnExit();
        if (file.isDirectory()) {
            Logger.info("Deleting on exit folder: '" + file.getPath() + "'");
            for (File f : file.listFiles()) {
                FileUtil.basicDeleteOnExitRecursively(f);
            }
        } else {
            Logger.info("Deleting on exit file  : '" + file.getPath() + "'");
        }
    }

    private static void basicSetWritableRecursively(File file) {
        if (!file.exists()) {
            return;
        }
        file.setWritable(true);
        if (file.isDirectory()) {
            Logger.info("Making writable folder: '" + file.getPath() + "'");
            if (file.listFiles() == null) {
                return;
            }
            for (File f : file.listFiles()) {
                FileUtil.basicSetWritableRecursively(f);
            }
        } else {
            Logger.info("Making writable file  : '" + file.getPath() + "'");
        }
    }

    private static void basicCopyFilePhysically(File sourceFile, File destFile) throws IOException {
        Logger.debug("Physically copying file: '" + sourceFile.getPath() + "' to file: '" + destFile.getPath() + "'");
        Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        BasicFileAttributes attr = Files.readAttributes(sourceFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        Files.setAttribute(destFile.toPath(), "creationTime", attr.creationTime(), new LinkOption[0]);
        Files.setAttribute(destFile.toPath(), "lastAccessTime", attr.lastAccessTime(), new LinkOption[0]);
        Files.setAttribute(destFile.toPath(), "lastModifiedTime", attr.lastModifiedTime(), new LinkOption[0]);
    }

    private static String createUniqueFileOrFolderNameByAppendingUniqueId(String fileOrFolderName, BiFunction<String, String, String> suffixAppender, Collection<String> valuesToExclude) {
        String suffix = UniqueID.getXML();
        String uniqueName = suffixAppender.apply(fileOrFolderName, suffix);
        while (valuesToExclude.contains(uniqueName)) {
            suffix = UniqueID.getXML();
            uniqueName = suffixAppender.apply(fileOrFolderName, suffix);
        }
        return uniqueName;
    }

    private static String createUniqueFileOrFolderNameByAppendingIndex(String fileOrFolderName, BiFunction<String, String, String> suffixAppender, Collection<String> valuesToExclude) {
        int index = 1;
        String suffix = String.format("-%03d", index);
        String uniqueName = suffixAppender.apply(fileOrFolderName, suffix);
        while (valuesToExclude.contains(uniqueName)) {
            suffix = String.format("-%03d", index);
            uniqueName = suffixAppender.apply(fileOrFolderName, suffix);
            ++index;
        }
        return uniqueName;
    }

    private static String appendSuffixToFileName(String fileName, String suffix) {
        String nameWithoutExt = FileUtil.asFileNameWithoutExtension(fileName);
        String extension = FileUtil.asFileNameExtension(fileName);
        if (extension.isEmpty()) {
            return nameWithoutExt + suffix;
        }
        return nameWithoutExt + suffix + FileExtensionSeparator + FileUtil.asFileNameExtension(fileName);
    }

    private static String appendSuffixToFolderName(String folderName, String suffix) {
        return folderName + suffix;
    }

    static {
        TempFolder = DefaultTempFolder = OperatingSystem.javaTempDir();
    }
}

