/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class Checksummer
implements Checksum {
    protected long _nByte;
    private CRC32 _crc32;
    private MessageDigest _md5;
    private MessageDigest _sha1;

    public Checksummer() {
        this.reset();
    }

    @Override
    public void reset() {
        this._nByte = 0L;
        this._crc32 = new CRC32();
        try {
            this._md5 = MessageDigest.getInstance("MD5");
            this._sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Override
    public long getValue() {
        return this._crc32.getValue();
    }

    public void update(byte b) {
        this._crc32.update(b);
        if (this._md5 != null) {
            this._md5.update(b);
        }
        if (this._sha1 != null) {
            this._sha1.update(b);
        }
    }

    @Override
    public void update(int b) {
        byte sb = b > 127 ? (byte)(b - 256) : (byte)b;
        this.update(sb);
    }

    @Override
    public void update(byte[] b) {
        this._crc32.update(b);
        if (this._md5 != null) {
            this._md5.update(b);
        }
        if (this._sha1 != null) {
            this._sha1.update(b);
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this._crc32.update(b, off, len);
        if (this._md5 != null) {
            this._md5.update(b, off, len);
        }
        if (this._sha1 != null) {
            this._sha1.update(b, off, len);
        }
    }

    public String getCRC32() {
        return this.padLeadingZeroes(Long.toHexString(this._crc32.getValue()), 8);
    }

    public String getMD5() {
        String value = null;
        if (this._md5 != null) {
            StringBuffer buffer = new StringBuffer();
            byte[] digest = this._md5.digest();
            for (int i = 0; i < digest.length; ++i) {
                int un = digest[i] >= 0 ? digest[i] : 256 + digest[i];
                buffer.append(this.padLeadingZeroes(Integer.toHexString(un), 2));
            }
            value = buffer.toString();
        }
        return value;
    }

    public String getSHA1() {
        String value = null;
        if (this._sha1 != null) {
            StringBuffer buffer = new StringBuffer();
            byte[] digest = this._sha1.digest();
            for (int i = 0; i < digest.length; ++i) {
                int un = digest[i] >= 0 ? digest[i] : 256 + digest[i];
                buffer.append(this.padLeadingZeroes(Integer.toHexString(un), 2));
            }
            value = buffer.toString();
        }
        return value;
    }

    private String padLeadingZeroes(String str, int len) {
        while (str.length() < len) {
            str = "0" + str;
        }
        return str;
    }
}

