/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.html.HtmlStack;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JHPCData
extends JHElement {
    public String _text;

    public JHPCData(List elements, String text, int line, int column) {
        super(elements);
        this._text = text;
        this._line = line;
        this._column = column;
    }

    protected void processPCData(HtmlStack elementStack, HtmlMetadata metadata) {
        JHOpenTag tag = elementStack.top();
        String name = tag.getName();
        if ("title".equals(name)) {
            metadata.setTitle(this._text);
        } else if ("cite".equals(name)) {
            metadata.addCitation(this._text);
        } else if ("dfn".equals(name)) {
            metadata.addDef(this._text);
        } else if ("abbr".equals(name)) {
            ArrayList<Property> abbrList = new ArrayList<Property>(2);
            abbrList.add(new Property("Text", PropertyType.STRING, (Object)this._text));
            for (String[] attr : tag.getAttributes()) {
                String attname = attr[0];
                String attval = attr[1];
                if (!"title".equals(attname)) continue;
                abbrList.add(new Property("Title", PropertyType.STRING, (Object)attval));
                break;
            }
            metadata.addAbbr(new Property("Abbr", PropertyType.PROPERTY, PropertyArity.LIST, abbrList));
        }
        Iterator iter = this.getEntities(this._text).iterator();
        Utf8BlockMarker utf8BM = metadata.getUtf8BlockMarker();
        while (iter.hasNext()) {
            String ent = (String)iter.next();
            metadata.addEntity(ent);
            try {
                if (ent.charAt(1) != '#') continue;
                int entval = Integer.parseInt(ent.substring(2, ent.length() - 1));
                utf8BM.markBlock(entval);
            }
            catch (Exception exception) {}
        }
    }
}

