/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileRFC1314
extends TiffProfile {
    public TiffProfileRFC1314() {
        this._profileText = "RFC 1314";
        this._mimeClass = 2;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getImageWidth() != -1L || niso.getImageLength() != -1L || tifd.getNewSubfileType() != -1L || niso.getRowsPerStrip() == -1L || niso.getStripByteCounts() == null || niso.getStripOffsets() == null || niso.getXSamplingFrequency() == null || niso.getYSamplingFrequency() == null) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 3, 4})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        return this.satisfiesResolutionUnit(tifd, new int[]{2, 3});
    }
}

