/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.bind.JAXBException;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.core.SignatureParseException;

public class ContainerSignatureFileReader {
    private String filePath = "";
    private ContainerSignatureDefinitions definitions;

    public ContainerSignatureFileReader() {
    }

    public ContainerSignatureFileReader(String filepath) {
        this.filePath = filepath;
    }

    public ContainerSignatureFileReader(Path path) {
        this.filePath = path.toFile().getPath();
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public synchronized ContainerSignatureDefinitions getDefinitions() throws SignatureParseException {
        if (this.definitions == null) {
            try {
                ContainerSignatureSaxParser parser = new ContainerSignatureSaxParser();
                try (FileInputStream containerFileStream = new FileInputStream(new File(this.filePath));){
                    this.definitions = parser.parse(containerFileStream);
                }
            }
            catch (IOException | JAXBException ex) {
                throw new SignatureParseException(ex.getMessage(), ex);
            }
        }
        return this.definitions;
    }
}

