/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Event;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class EventBuffer
extends SequenceReceiver {
    List<Event> buffer = new ArrayList<Event>();

    public EventBuffer(PipelineConfiguration pipe) {
        super(pipe);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.buffer.add(new Event.StartDocument(properties));
    }

    @Override
    public void endDocument() throws XPathException {
        this.buffer.add(new Event.EndDocument());
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.StartElement(elemName, typeCode, location, properties));
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.buffer.add(new Event.Namespace(namespaceBindings, properties));
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.Attribute(attName, typeCode, location, value, properties));
    }

    @Override
    public void startContent() throws XPathException {
        this.buffer.add(new Event.StartContent());
    }

    @Override
    public void endElement() throws XPathException {
        this.buffer.add(new Event.EndElement());
    }

    @Override
    public void characters(CharSequence chars, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.Text(chars, location, properties));
    }

    @Override
    public void processingInstruction(String name, CharSequence data, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.ProcessingInstruction(name, data, location, properties));
    }

    @Override
    public void comment(CharSequence content, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.Comment(content, location, properties));
    }

    @Override
    public void append(Item item, Location location, int properties) throws XPathException {
        this.buffer.add(new Event.Append(item, location, properties));
    }

    @Override
    public void close() throws XPathException {
    }

    public void replay(Receiver out) throws XPathException {
        for (Event event : this.buffer) {
            event.replay(out);
        }
    }
}

