/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.x11;

import com.sun.jimi.core.util.x11.XColorNames;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class XpmParser {
    private DataInputStream input;
    private int lineNo = 0;
    private int width = 0;
    private int height = 0;
    private int nColors = 0;
    private int charsPerPixel = 0;
    private Hashtable colors;
    private Color[] colorTable;
    private byte[] pixmap = null;
    private String line;

    public XpmParser(InputStream inputStream) {
        this.input = new DataInputStream(inputStream);
        this.colors = new Hashtable();
    }

    private void checkForHeader() throws Exception {
        this.readLine();
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            String string = this.line.substring(2);
            string = string.trim();
            this.readLine();
        }
    }

    public Color[] getColorTable() {
        return this.colorTable;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixmap() {
        return this.pixmap;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean parse() {
        try {
            this.parseInput();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Color parseColor(String string) {
        Color color = null;
        if (string.charAt(0) == '#') {
            switch (string.length()) {
                case 7: {
                    Integer n = Integer.valueOf(string.substring(1), 16);
                    color = new Color(n);
                    break;
                }
                case 13: {
                    Integer n = Integer.valueOf(string.substring(1, 3), 16);
                    Integer n2 = Integer.valueOf(string.substring(5, 7), 16);
                    Integer n3 = Integer.valueOf(string.substring(9, 11), 16);
                    color = new Color(n, n2, n3);
                    break;
                }
            }
            if (color == null) {
                color = Color.black;
            }
        } else if (string.equalsIgnoreCase("none")) {
            color = null;
        } else {
            int n = XColorNames.getRgb(string);
            if (n != Integer.MIN_VALUE) {
                color = new Color(n);
            }
            if (color == null) {
                color = Color.black;
            }
        }
        return color;
    }

    private void parseInput() throws Exception {
        this.checkForHeader();
        this.skipLineStartingWith("static char");
        this.readHintsLine();
        this.colorTable = new Color[this.nColors];
        this.readColorTable();
        this.readPixels();
    }

    private void readColorTable() throws Exception {
        int n = 0;
        while (n < this.nColors) {
            this.readLine();
            if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
                this.readLine();
            }
            if (this.line == null) {
                throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.lineNo);
            }
            int n2 = this.line.indexOf(34);
            if (n2 < 0) {
                throw new Exception("Invalid Xpm format: color table, line: " + this.lineNo);
            }
            String string = this.line.substring(n2 + 1);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.charsPerPixel) {
                n3 = (n3 << 8) + string.charAt(n4);
                ++n4;
            }
            string = this.line.substring(n2 + 1 + this.charsPerPixel);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \"\t\n\r");
            int n5 = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && n5 < 2) {
                String string2 = stringTokenizer.nextToken();
                switch (n5) {
                    case 0: {
                        if (!string2.equals("c")) break;
                        ++n5;
                        break;
                    }
                    case 1: {
                        this.colorTable[n] = this.parseColor(string2);
                        this.colors.put(new Integer(n3), new Integer(n));
                        ++n5;
                        break;
                    }
                }
            }
            ++n;
        }
    }

    private void readHintsLine() throws Exception {
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            this.readLine();
        }
        if (this.line == null) {
            throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.lineNo);
        }
        int n = this.line.indexOf(34);
        int n2 = this.line.lastIndexOf(34);
        if (n < 0 || n2 < 0 || n2 <= n) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        String string = this.line.substring(n + 1, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 4) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        try {
            this.width = Integer.parseInt(stringTokenizer.nextToken());
            this.height = Integer.parseInt(stringTokenizer.nextToken());
            this.nColors = Integer.parseInt(stringTokenizer.nextToken());
            this.charsPerPixel = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new Exception("Invalid Xpm format: hints line: " + this.lineNo);
        }
        if (this.charsPerPixel > 3) {
            throw new Exception("Invalid Xpm format: Can only handle up to 3 chars per pixels");
        }
    }

    private void readLine() {
        this.line = null;
        try {
            this.line = this.input.readLine();
        }
        catch (IOException iOException) {
            this.line = null;
        }
        if (this.line != null) {
            this.line = this.line.trim();
        }
        ++this.lineNo;
    }

    private void readPixels() throws Exception {
        this.readLine();
        if (this.line != null && this.line.startsWith("/*") && this.line.endsWith("*/")) {
            this.readLine();
        }
        if (this.line == null) {
            throw new Exception("Invalid Xpm format: EOF at line: " + this.lineNo);
        }
        int n = this.width * this.height;
        this.pixmap = new byte[n];
        int n2 = 0;
        while (this.line != null) {
            int n3 = this.line.indexOf(34);
            int n4 = this.line.lastIndexOf(34);
            if (n3 < 0 || n4 < 0 || n4 <= n3) {
                throw new Exception("Invalid Xpm format: line: " + this.lineNo);
            }
            String string = this.line.substring(n3 + 1, n4);
            int n5 = 0;
            while (n5 < string.length()) {
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.charsPerPixel) {
                    n6 = (n6 << 8) + string.charAt(n5++);
                    ++n7;
                }
                this.pixmap[n2++] = (byte)((Integer)this.colors.get(new Integer(n6))).intValue();
            }
            if (n2 >= n) {
                return;
            }
            this.readLine();
        }
    }

    private void skipLineStartingWith(String string) throws Exception {
        if (this.line == null) {
            throw new Exception("Invalid Xpm format, line: " + this.lineNo);
        }
        if (this.line.startsWith(string)) {
            this.readLine();
        }
    }
}

