/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.net;

import ch.docuteam.tools.out.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;

public class ServerResource {
    private ServerResource() {
    }

    public static boolean isReachable(String resourceURL, int timeOutMillis) {
        String host = "";
        int port = 0;
        try {
            URI uri = new URI(resourceURL);
            host = uri.getHost();
            port = uri.getPort();
        }
        catch (URISyntaxException e) {
            Logger.error("URISyntaxException : " + resourceURL);
            return false;
        }
        return ServerResource.isReachable(host, port, timeOutMillis);
    }

    public static boolean isReachable(String addr, int openPort, int timeOutMillis) {
        try {
            try (Socket soc = new Socket();){
                soc.connect(new InetSocketAddress(addr, openPort), timeOutMillis);
            }
            return true;
        }
        catch (IOException ex) {
            Logger.error(String.format("Socket.connect(addr=%s, openPort=%d, timeout=%d) -> %s", addr, openPort, timeOutMillis, ex.getMessage()));
            return false;
        }
    }
}

