/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.out;

import ch.docuteam.tools.out.LogFile;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.out.SystemOutRedirectionTarget;
import ch.docuteam.tools.out.SystemOutRedirectionTargetAbstract;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemOutRedirector
extends FilterOutputStream {
    private static PrintStream Out;
    private static PrintStream Err;
    private final SystemOutRedirectionTarget target;

    public static void main(String[] args) {
        System.out.println("0.1");
        System.out.println("0.2");
        System.out.println("0.3");
        try {
            throw new RuntimeException("X0");
        }
        catch (RuntimeException e) {
            Logger.error(e.getMessage(), e);
            new SystemOutRedirectionTargetExampleFile().install();
            System.out.println("1.1");
            System.out.println("1.2");
            System.out.println("1.3");
            try {
                throw new RuntimeException("X1");
            }
            catch (RuntimeException e2) {
                Logger.error(e2.getMessage(), e2);
                SystemOutRedirectionTargetAbstract.uninstall();
                System.out.println("2.1");
                System.out.println("2.2");
                System.out.println("2.3");
                try {
                    throw new RuntimeException("X2");
                }
                catch (RuntimeException e3) {
                    Logger.error(e3.getMessage(), e3);
                    new SystemOutRedirectionTargetExampleTextArea().install();
                    System.out.println("3.1");
                    System.out.println("3.2");
                    System.out.println("3.3");
                    try {
                        throw new RuntimeException("X3");
                    }
                    catch (RuntimeException e4) {
                        Logger.error(e4.getMessage(), e4);
                        SystemOutRedirectionTargetAbstract.uninstall();
                        System.out.println("4.1");
                        System.out.println("4.2");
                        System.out.println("4.3");
                        try {
                            throw new RuntimeException("X4");
                        }
                        catch (RuntimeException e5) {
                            Logger.error(e5.getMessage(), e5);
                            return;
                        }
                    }
                }
            }
        }
    }

    private SystemOutRedirector(SystemOutRedirectionTarget target) {
        super(new ByteArrayOutputStream());
        this.target = target;
        Out = System.out;
        Err = System.err;
        System.setOut(new PrintStream(this));
        System.setErr(new PrintStream(this));
    }

    public static void install(SystemOutRedirectionTarget target) {
        new SystemOutRedirector(target);
    }

    public static void unInstall() {
        System.setOut(Out);
        System.setErr(Err);
    }

    @Override
    public void write(byte[] b) {
        String str = new String(b);
        this.write(str);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String str = new String(b, off, len);
        this.write(str);
    }

    @Override
    public void write(int b) {
        String str = new String(new char[]{(char)b});
        this.write(str);
    }

    private void write(String message) {
        this.target.write(message);
    }

    private static class SystemOutRedirectionTargetExampleFile
    extends SystemOutRedirectionTargetAbstract {
        private SystemOutRedirectionTargetExampleFile() {
        }

        @Override
        public void write(String string) {
            try {
                LogFile.write((Object)string);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), e);
            }
        }

        static {
            LogFile.initializeAppend("temp/LogFile.txt");
        }
    }

    private static class SystemOutRedirectionTargetExampleTextArea
    extends SystemOutRedirectionTargetAbstract {
        private static JTextArea textArea = new JTextArea();

        private SystemOutRedirectionTargetExampleTextArea() {
        }

        @Override
        public void write(String string) {
            textArea.append(string);
        }

        static {
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(3);
            f.add((Component)new JScrollPane(textArea), "Center");
            f.setSize(300, 200);
            f.setLocationRelativeTo(null);
            f.setVisible(true);
        }
    }
}

