/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public abstract class WebArchiveHandler {
    protected static final int HTTP_ACCEPTED = 200;
    private AsynchDroid droidCore;
    private IdentificationRequestFactory factory;
    private ResultHandler resultHandler;

    public WebArchiveHandler() {
    }

    public WebArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler) {
        this.droidCore = droidCore;
        this.factory = factory;
        this.resultHandler = resultHandler;
    }

    public final void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public final void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public final void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private ResourceId submitDirectory(String webArchiveType, URI parentName, String resourceName, String entryName, ResourceId correlationId) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        RequestMetaData metaData = new RequestMetaData(null, null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toWebArchiveUri(webArchiveType, parentName, resourceName));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return this.resultHandler.handleDirectory(result, correlationId, false);
    }

    final void submit(String webArchiveType, RequestMetaData metaData, URI parentName, InputStream payload, ResourceId correlationId, long originatorNodeId) throws IOException {
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toWebArchiveUri(webArchiveType, parentName, metaData.getName()));
        identifier.setAncestorId(originatorNodeId);
        identifier.setParentResourceId(correlationId);
        IdentificationRequest<InputStream> request = this.factory.newRequest(metaData, identifier);
        if (this.droidCore.passesIdentificationFilter(request)) {
            request.open(payload);
            this.droidCore.submit(request);
        }
    }

    public static List<String> getAncestorUrls(String url) {
        String schemeSeparator = "://";
        ArrayList<String> urls = new ArrayList<String>();
        if (url != null && !url.isEmpty()) {
            String urlPath = url.substring(url.indexOf("://") + "://".length());
            String urlScheme = url.substring(0, url.indexOf("://") + "://".length());
            char separator = '/';
            int lastSeparator = urlPath.length();
            if (separator == urlPath.charAt(urlPath.length() - 1)) {
                --lastSeparator;
            }
            while (lastSeparator >= 0) {
                urlPath = urlPath.substring(0, lastSeparator);
                urls.add(urlScheme + urlPath + String.valueOf(separator));
                lastSeparator = urlPath.lastIndexOf(separator);
            }
        }
        return urls;
    }

    protected ResourceId processAncestorFolders(String webArchiveType, String url, String requestUri, ResourceId parentId, URI parentName, Map<String, ResourceId> directories) {
        List<String> urls = WebArchiveHandler.getAncestorUrls(url);
        ResourceId longestParentId = parentId;
        int longestSeenBefore = urls.size();
        ResourceId correlationId = null;
        for (int urlIndex = 0; urlIndex < urls.size(); ++urlIndex) {
            correlationId = directories.get(urls.get(urlIndex));
            if (correlationId == null) continue;
            longestSeenBefore = urlIndex;
            longestParentId = correlationId;
            break;
        }
        Pattern p = Pattern.compile("/");
        for (int urlIndex = longestSeenBefore - 1; urlIndex >= 0; --urlIndex) {
            String urlName;
            String dirName = urlName = urls.get(urlIndex);
            String[] dirs = p.split(urlName);
            if (!"".equals(dirs[dirs.length - 1])) {
                dirName = dirs[dirs.length - 1];
            }
            longestParentId = this.submitDirectory(webArchiveType, parentName, requestUri, dirName, longestParentId);
            directories.put(urlName, longestParentId);
        }
        return longestParentId;
    }
}

