/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.signature;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySubscriber;

public class ProxySettings
implements ConfigurationListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String proxyHost;
    private int proxyPort;
    private boolean enabled;
    private Set<ProxySubscriber> proxySubscribers = new HashSet<ProxySubscriber>();

    public ProxySettings() {
    }

    public ProxySettings(String proxyHost, int proxyPort, boolean enabled) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.enabled = enabled;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public static ProxySettings newInstance() {
        return new ProxySettings();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void configurationChanged(ConfigurationEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.startsWith("update.proxy")) {
            DroidGlobalProperty property = DroidGlobalProperty.forName(propertyName);
            switch (property) {
                case UPDATE_PROXY_HOST: {
                    this.setProxyHost((String)event.getPropertyValue());
                    break;
                }
                case UPDATE_PROXY_PORT: {
                    this.setProxyPort((Integer)event.getPropertyValue());
                    break;
                }
                case UPDATE_USE_PROXY: {
                    this.setEnabled((Boolean)event.getPropertyValue());
                    break;
                }
                default: {
                    this.log.error(String.format("Invalid proxy setting [%s]", propertyName));
                }
            }
            this.notifyProxySubscribers();
        }
    }

    public void notifyProxySubscribers() {
        for (ProxySubscriber subscriber : this.proxySubscribers) {
            subscriber.onProxyChange(this);
        }
    }

    public void addProxySubscriber(ProxySubscriber proxySubscriber) {
        this.proxySubscribers.add(proxySubscriber);
    }
}

