/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class AbstractDirectory {
    public static final int MAX_LABEL_LENGTH = 11;
    private final List<FatDirectoryEntry> entries = new ArrayList<FatDirectoryEntry>();
    private final boolean readOnly;
    private final boolean isRoot;
    private final FatType type;
    private boolean dirty;
    private int capacity;
    private String volumeLabel;

    protected AbstractDirectory(FatType type, int capacity, boolean readOnly, boolean isRoot) {
        this.type = type;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.isRoot = isRoot;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    protected abstract void write(ByteBuffer var1) throws IOException;

    protected abstract long getStorageCluster();

    protected abstract void changeSize(int var1) throws DirectoryFullException, IOException;

    public void setEntries(List<FatDirectoryEntry> newEntries) {
        if (newEntries.size() > this.capacity) {
            throw new IllegalArgumentException("too many entries");
        }
        this.entries.clear();
        this.entries.addAll(newEntries);
    }

    protected final void sizeChanged(long newSize) throws IOException {
        long newCount = newSize / 32L;
        if (newCount > Integer.MAX_VALUE) {
            throw new IOException("directory too large");
        }
        this.capacity = (int)newCount;
    }

    public final FatDirectoryEntry getEntry(int idx) {
        return this.entries.get(idx);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public int getSize() {
        return this.entries.size() + (this.volumeLabel != null ? 1 : 0);
    }

    protected final void setDirty() {
        this.dirty = true;
    }

    private void checkRoot() throws UnsupportedOperationException {
        if (!this.isRoot()) {
            throw new UnsupportedOperationException("only supported on root directories");
        }
    }

    private void resetDirty() {
        this.dirty = false;
    }

    public void flush() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(this.getCapacity() * 32);
        for (int i = 0; i < this.entries.size(); ++i) {
            FatDirectoryEntry entry = this.entries.get(i);
            if (entry == null) continue;
            entry.write(data);
        }
        if (this.volumeLabel != null) {
            FatDirectoryEntry labelEntry = FatDirectoryEntry.createVolumeLabel(this.type, this.volumeLabel);
            labelEntry.write(data);
        }
        if (data.hasRemaining()) {
            FatDirectoryEntry.writeNullEntry(data);
        }
        data.flip();
        this.write(data);
        this.resetDirty();
    }

    protected final void read() throws IOException {
        FatDirectoryEntry e;
        ByteBuffer data = ByteBuffer.allocate(this.getCapacity() * 32);
        this.read(data);
        data.flip();
        for (int i = 0; i < this.getCapacity() && (e = FatDirectoryEntry.read(this.type, data, this.isReadOnly())) != null; ++i) {
            if (e.isVolumeLabel()) {
                if (!this.isRoot) {
                    throw new IOException("volume label in non-root directory");
                }
                this.volumeLabel = e.getVolumeLabel();
                continue;
            }
            this.entries.add(e);
        }
    }

    public void addEntry(FatDirectoryEntry e) throws IOException {
        assert (e != null);
        if (this.getSize() == this.getCapacity()) {
            this.changeSize(this.getCapacity() + 1);
        }
        this.entries.add(e);
    }

    public void addEntries(FatDirectoryEntry[] entries) throws IOException {
        if (this.getSize() + entries.length > this.getCapacity()) {
            this.changeSize(this.getSize() + entries.length);
        }
        this.entries.addAll(Arrays.asList(entries));
    }

    public void removeEntry(FatDirectoryEntry entry) throws IOException {
        assert (entry != null);
        this.entries.remove(entry);
        this.changeSize(this.getSize());
    }

    public String getLabel() throws UnsupportedOperationException {
        this.checkRoot();
        return this.volumeLabel;
    }

    public FatDirectoryEntry createSub(Fat fat) throws IOException {
        ClusterChain chain = new ClusterChain(fat, false);
        chain.setChainLength(1);
        FatDirectoryEntry entry = FatDirectoryEntry.create(this.type, true);
        entry.setStartCluster(chain.getStartCluster());
        ClusterChainDirectory dir = new ClusterChainDirectory(chain, false);
        FatDirectoryEntry dot = FatDirectoryEntry.create(this.type, true);
        dot.setShortName(ShortName.DOT);
        dot.setStartCluster(dir.getStorageCluster());
        AbstractDirectory.copyDateTimeFields(entry, dot);
        dir.addEntry(dot);
        FatDirectoryEntry dotDot = FatDirectoryEntry.create(this.type, true);
        dotDot.setShortName(ShortName.DOT_DOT);
        dotDot.setStartCluster(this.getStorageCluster());
        AbstractDirectory.copyDateTimeFields(entry, dotDot);
        dir.addEntry(dotDot);
        dir.flush();
        return entry;
    }

    private static void copyDateTimeFields(FatDirectoryEntry src, FatDirectoryEntry dst) {
        dst.setCreated(src.getCreated());
        dst.setLastAccessed(src.getLastAccessed());
        dst.setLastModified(src.getLastModified());
    }

    public void setLabel(String label) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        this.checkRoot();
        if (label != null && label.length() > 11) {
            throw new IllegalArgumentException("label too long");
        }
        if (this.volumeLabel != null) {
            if (label == null) {
                this.changeSize(this.getSize() - 1);
                this.volumeLabel = null;
            } else {
                ShortName.checkValidChars(label.getBytes(ShortName.ASCII));
                this.volumeLabel = label;
            }
        } else if (label != null) {
            this.changeSize(this.getSize() + 1);
            ShortName.checkValidChars(label.getBytes(ShortName.ASCII));
            this.volumeLabel = label;
        }
        this.dirty = true;
    }
}

