/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.Fat16BootSector;
import de.waldheinz.fs.fat.Fat16RootDirectory;
import de.waldheinz.fs.fat.Fat32BootSector;
import de.waldheinz.fs.fat.FatFileSystem;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.FsInfoSector;
import java.io.IOException;
import java.util.Random;

public final class SuperFloppyFormatter {
    public static final int MEDIUM_DESCRIPTOR_HD = 248;
    public static final int DEFAULT_FAT_COUNT = 2;
    public static final int DEFAULT_SECTORS_PER_TRACK = 32;
    public static final int DEFAULT_HEADS = 64;
    @Deprecated
    public static final int DEFULT_HEADS = 64;
    public static final String DEFAULT_OEM_NAME = "fat32lib";
    private static final int MAX_DIRECTORY = 512;
    private final BlockDevice device;
    private final int fatCount;
    private String label;
    private String oemName;
    private FatType fatType;
    private int sectorsPerCluster;
    private int reservedSectors;

    private SuperFloppyFormatter(BlockDevice device) throws IOException {
        this.device = device;
        this.oemName = DEFAULT_OEM_NAME;
        this.fatCount = 2;
        this.setFatType(this.fatTypeFromDevice());
    }

    public static SuperFloppyFormatter get(BlockDevice dev) throws IOException {
        return new SuperFloppyFormatter(dev);
    }

    public String getOemName() {
        return this.oemName;
    }

    public SuperFloppyFormatter setOemName(String oemName) {
        this.oemName = oemName;
        return this;
    }

    public SuperFloppyFormatter setVolumeLabel(String label) {
        this.label = label;
        return this;
    }

    public String getVolumeLabel() {
        return this.label;
    }

    private void initBootSector(BootSector bs) throws IOException {
        bs.init();
        bs.setFileSystemTypeLabel(this.fatType.getLabel());
        bs.setNrReservedSectors(this.reservedSectors);
        bs.setNrFats(this.fatCount);
        bs.setSectorsPerCluster(this.sectorsPerCluster);
        bs.setMediumDescriptor(248);
        bs.setSectorsPerTrack(32);
        bs.setNrHeads(64);
        bs.setOemName(this.oemName);
    }

    public FatFileSystem format() throws IOException {
        AbstractDirectory rootDirStore;
        FsInfoSector fsi;
        BootSector bs;
        int sectorSize = this.device.getSectorSize();
        int totalSectors = (int)(this.device.getSize() / (long)sectorSize);
        if (this.sectorsPerCluster == 0) {
            throw new AssertionError();
        }
        if (this.fatType == FatType.FAT32) {
            bs = new Fat32BootSector(this.device);
            this.initBootSector(bs);
            BootSector f32bs = bs;
            ((Fat32BootSector)f32bs).setFsInfoSectorNr(1);
            ((Fat32BootSector)f32bs).setSectorsPerFat(this.sectorsPerFat(0, totalSectors));
            Random rnd = new Random(System.currentTimeMillis());
            ((Fat32BootSector)f32bs).setFileSystemId(rnd.nextInt());
            ((Fat32BootSector)f32bs).setVolumeLabel(this.label);
            fsi = FsInfoSector.create((Fat32BootSector)f32bs);
        } else {
            bs = new Fat16BootSector(this.device);
            this.initBootSector(bs);
            Fat16BootSector f16bs = (Fat16BootSector)bs;
            int rootDirEntries = SuperFloppyFormatter.rootDirectorySize(this.device.getSectorSize(), totalSectors);
            f16bs.setRootDirEntryCount(rootDirEntries);
            f16bs.setSectorsPerFat(this.sectorsPerFat(rootDirEntries, totalSectors));
            if (this.label != null) {
                f16bs.setVolumeLabel(this.label);
            }
            fsi = null;
        }
        Fat fat = Fat.create(bs, 0);
        if (this.fatType == FatType.FAT32) {
            rootDirStore = ClusterChainDirectory.createRoot(fat);
            fsi.setFreeClusterCount(fat.getFreeClusterCount());
            fsi.setLastAllocatedCluster(fat.getLastAllocatedCluster());
            fsi.write();
        } else {
            rootDirStore = Fat16RootDirectory.create((Fat16BootSector)bs);
        }
        FatLfnDirectory rootDir = new FatLfnDirectory(rootDirStore, fat, false);
        rootDir.flush();
        for (int i = 0; i < bs.getNrFats(); ++i) {
            fat.writeCopy(bs.getFatOffset(i));
        }
        bs.write();
        if (this.fatType == FatType.FAT32) {
            Fat32BootSector f32bs = (Fat32BootSector)bs;
            f32bs.writeCopy(this.device);
        }
        FatFileSystem fs = FatFileSystem.read(this.device, false);
        if (this.label != null) {
            fs.setVolumeLabel(this.label);
        }
        fs.flush();
        return fs;
    }

    private int sectorsPerFat(int rootDirEntries, int totalSectors) throws IOException {
        int bps = this.device.getSectorSize();
        int rootDirSectors = (rootDirEntries * 32 + (bps - 1)) / bps;
        long tmp1 = totalSectors - (this.reservedSectors + rootDirSectors);
        int tmp2 = 256 * this.sectorsPerCluster + this.fatCount;
        if (this.fatType == FatType.FAT32) {
            tmp2 /= 2;
        }
        int result = (int)((tmp1 + (long)(tmp2 - 1)) / (long)tmp2);
        return result;
    }

    private FatType fatTypeFromDevice() throws IOException {
        long sizeInMb = this.device.getSize() / 0x100000L;
        if (sizeInMb < 5L) {
            return FatType.FAT12;
        }
        if (sizeInMb < 512L) {
            return FatType.FAT16;
        }
        return FatType.FAT32;
    }

    public FatType getFatType() {
        return this.fatType;
    }

    public SuperFloppyFormatter setFatType(FatType fatType) throws IOException, IllegalArgumentException {
        if (fatType == null) {
            throw new NullPointerException();
        }
        switch (fatType) {
            case FAT12: 
            case FAT16: {
                this.reservedSectors = 1;
                break;
            }
            case FAT32: {
                this.reservedSectors = 32;
            }
        }
        this.sectorsPerCluster = this.defaultSectorsPerCluster(fatType);
        this.fatType = fatType;
        return this;
    }

    private static int rootDirectorySize(int bps, int nbTotalSectors) {
        int totalSize = bps * nbTotalSectors;
        if (totalSize >= 81920) {
            return 512;
        }
        return totalSize / 160;
    }

    private int sectorsPerCluster32() throws IOException {
        if (this.reservedSectors != 32) {
            throw new IllegalStateException("number of reserved sectors must be 32");
        }
        if (this.fatCount != 2) {
            throw new IllegalStateException("number of FATs must be 2");
        }
        long sectors = this.device.getSize() / (long)this.device.getSectorSize();
        if (sectors <= 66600L) {
            throw new IllegalArgumentException("disk too small for FAT32");
        }
        return sectors > 0x4000000L ? 64 : (sectors > 0x2000000L ? 32 : (sectors > 0x1000000L ? 16 : (sectors > 532480L ? 8 : 1)));
    }

    private int sectorsPerCluster16() throws IOException {
        if (this.reservedSectors != 1) {
            throw new IllegalStateException("number of reserved sectors must be 1");
        }
        if (this.fatCount != 2) {
            throw new IllegalStateException("number of FATs must be 2");
        }
        long sectors = this.device.getSize() / (long)this.device.getSectorSize();
        if (sectors <= 8400L) {
            throw new IllegalArgumentException("disk too small for FAT16 (" + sectors + ")");
        }
        if (sectors > 0x400000L) {
            throw new IllegalArgumentException("disk too large for FAT16");
        }
        return sectors > 0x200000L ? 64 : (sectors > 0x100000L ? 32 : (sectors > 524288L ? 16 : (sectors > 262144L ? 8 : (sectors > 32680L ? 4 : 2))));
    }

    private int defaultSectorsPerCluster(FatType fatType) throws IOException {
        switch (fatType) {
            case FAT12: {
                return this.sectorsPerCluster12();
            }
            case FAT16: {
                return this.sectorsPerCluster16();
            }
            case FAT32: {
                return this.sectorsPerCluster32();
            }
        }
        throw new AssertionError();
    }

    private int sectorsPerCluster12() throws IOException {
        int result = 1;
        long sectors = this.device.getSize() / (long)this.device.getSectorSize();
        while (sectors / (long)result > 4084L) {
            if ((result *= 2) * this.device.getSectorSize() <= 4096) continue;
            throw new IllegalArgumentException("disk too large for FAT12");
        }
        return result;
    }
}

