/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.ole2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import uk.gov.nationalarchives.droid.container.AbstractIdentifierEngine;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;

public class Ole2IdentifierEngine
extends AbstractIdentifierEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(IdentificationRequest request, ContainerSignatureMatchCollection matches) throws IOException {
        InputStream in = request.getSourceInputStream();
        try {
            POIFSFileSystem reader = new POIFSFileSystem(in);
            DirectoryNode root = reader.getRoot();
            Iterator it = root.getEntries();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                String entryName = entry.getName().trim();
                boolean needsBinaryMatch = false;
                for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                    match.matchFileEntry(entryName);
                    if (!match.needsBinaryMatch(entryName)) continue;
                    needsBinaryMatch = true;
                }
                if (!needsBinaryMatch) continue;
                DocumentInputStream docIn = null;
                ByteReader byteReader = null;
                try {
                    docIn = reader.createDocumentInputStream(entry.getName());
                    byteReader = this.newByteReader((InputStream)docIn);
                    for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                        match.matchBinaryContent(entryName, byteReader);
                    }
                }
                finally {
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    if (docIn == null) continue;
                    docIn.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

