/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Logger;

public abstract class HandlerBase
implements OutputHandler {
    public static SynchronizedDateFormat date = new SynchronizedDateFormat("yyyy-MM-dd");
    public static SynchronizedDateFormat dateTime = new SynchronizedDateFormat("yyyy-MM-dd HH:mm:ss z");
    public static SynchronizedDateFormat iso8601 = new SynchronizedDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    protected App _app;
    protected JhoveBase _base;
    protected Date _date;
    protected String _encoding;
    protected String _init;
    protected List _defaultParams;
    protected JhoveBase _je;
    protected int _level;
    protected String _name;
    protected String _note;
    protected String _release;
    protected String _param;
    protected String _rights;
    protected List _specification;
    protected Agent _vendor;
    protected PrintWriter _writer;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.handler");

    protected HandlerBase(String string, String string2, int[] nArray, String string3, String string4) {
        this._logger.info("Initializing " + string);
        this._name = string;
        this._release = string2;
        this._encoding = "UTF-8";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(nArray[0], nArray[1] - 1, nArray[2]);
        this._date = gregorianCalendar.getTime();
        this._note = string3;
        this._rights = string4;
        this._specification = new ArrayList();
        this._level = -1;
    }

    public void reset() {
        this._level = -1;
    }

    public void setDefaultParams(List list) {
        this._defaultParams = list;
    }

    public void applyDefaultParams() throws Exception {
        this.resetParams();
        for (String string : this._defaultParams) {
            this.param(string);
        }
    }

    public void resetParams() throws Exception {
        this._param = null;
    }

    public void init(String string) throws Exception {
        this._init = string;
    }

    public void param(String string) throws Exception {
        this._param = string;
    }

    public final Date getDate() {
        return this._date;
    }

    public final String getName() {
        return this._name;
    }

    public final String getNote() {
        return this._note;
    }

    public final String getRelease() {
        return this._release;
    }

    public final String getRights() {
        return this._rights;
    }

    public final List getSpecification() {
        return this._specification;
    }

    public final Agent getVendor() {
        return this._vendor;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public final void setApp(App app) {
        this._app = app;
    }

    public final void setBase(JhoveBase jhoveBase) {
        this._je = jhoveBase;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public final void setWriter(PrintWriter printWriter) {
        this._writer = printWriter;
    }

    public void analyze(RepInfo repInfo) {
    }

    public void endDirectory() {
    }

    public boolean okToProcess(String string) {
        return true;
    }

    public abstract void show(Module var1);

    public abstract void show(RepInfo var1);

    public abstract void show(OutputHandler var1);

    public abstract void show();

    public abstract void show(App var1);

    public abstract void showHeader();

    public abstract void showFooter();

    public void close() {
        this._writer.close();
    }

    public void startDirectory(String string) {
    }

    protected static String doctype(String string, String string2) {
        return HandlerBase.doctype(string, null, string2);
    }

    protected static String doctype(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("<!DOCTYPE " + string);
        if (string2 != null) {
            stringBuffer.append(" PUBLIC \"" + string2 + "\" \"");
        } else {
            stringBuffer.append(" SYSTEM \"");
        }
        stringBuffer.append(string3 + "\">");
        return stringBuffer.toString();
    }

    protected static String element(String string) {
        return "<" + string + "/>";
    }

    protected static String element(String string, String string2) {
        return HandlerBase.elementStart(string) + HandlerBase.encodeContent(string2) + HandlerBase.elementEnd(string);
    }

    protected static String element(String string, String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i][0] == null || stringArray[i][1] == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i][0]);
            stringBuffer.append("=\"");
            stringBuffer.append(HandlerBase.encodeValue(stringArray[i][1]));
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    protected static String element(String string, String[][] stringArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i][0] == null || stringArray[i][1] == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i][0]);
            stringBuffer.append("=\"");
            stringBuffer.append(HandlerBase.encodeValue(stringArray[i][1]));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(HandlerBase.encodeContent(string2));
        stringBuffer.append(HandlerBase.elementEnd(string));
        return stringBuffer.toString();
    }

    protected static String elementEnd(String string) {
        return "</" + string + ">";
    }

    protected static String elementStart(String string) {
        return "<" + string + ">";
    }

    protected static String elementStart(String string, String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i][0]);
            stringBuffer.append("=\"");
            stringBuffer.append(HandlerBase.encodeValue(stringArray[i][1]));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private static String encodeContent(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (!('\u0000' <= c && c <= '\b' || '\u000b' <= c && c <= '\f' || '\u000e' <= c && c <= '\u001f') && '\u007f' != c) continue;
            stringBuffer.deleteCharAt(i--);
            --n;
        }
        n = 0;
        while ((n = stringBuffer.indexOf("&", n)) > -1) {
            stringBuffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = stringBuffer.indexOf("<", n)) > -1) {
            stringBuffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = stringBuffer.indexOf(">", n)) > -1) {
            stringBuffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        return stringBuffer.toString();
    }

    private static String encodeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (!('\u0000' <= c && c <= '\b' || '\u000b' <= c && c <= '\f' || '\u000e' <= c && c <= '\u001f') && '\u007f' != c) continue;
            stringBuffer.deleteCharAt(i--);
            --n;
        }
        n = 0;
        while ((n = stringBuffer.indexOf("\"", n)) > -1) {
            stringBuffer.replace(n, n + 1, "&quot;");
            n += 7;
        }
        return stringBuffer.toString();
    }

    protected static String xmlDecl() {
        return "<?xml version=\"1.0\"?>";
    }

    protected static String xmlDecl(String string) {
        return "<?xml version=\"1.0\" encoding=\"" + string + "\"?>";
    }

    protected static String getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    protected static String integerArray(int[] nArray) {
        return HandlerBase.integerArray(nArray, ' ');
    }

    protected static String integerArray(int[] nArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(Integer.toString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    protected static String longArray(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Long.toString(lArray[i]));
        }
        return stringBuffer.toString();
    }

    protected static String rationalArray(Rational[] rationalArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < rationalArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(rationalArray[i].toDouble());
        }
        return stringBuffer.toString();
    }

    protected static String rationalArray10(Rational[] rationalArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < rationalArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(rationalArray[i].getNumerator());
            stringBuffer.append(" ");
            stringBuffer.append(rationalArray[i].getNumerator());
        }
        return stringBuffer.toString();
    }

    protected static String doubleArray(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Double.toString(dArray[i]));
        }
        return stringBuffer.toString();
    }

    protected String toDateTime(Date date) {
        String string = iso8601.format(date);
        int n = string.length();
        return string.substring(0, n - 2) + ":" + string.substring(n - 2);
    }

    public static class SynchronizedDateFormat
    extends SimpleDateFormat {
        public SynchronizedDateFormat(String string) {
            super(string);
        }

        public synchronized StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return super.format(date, stringBuffer, fieldPosition);
        }
    }
}

