/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITHCP2
extends TiffProfileClassIT {
    public TiffProfileClassITHCP2() {
        this._profileText = "TIFF/IT-HC/P2 (ISO 12639:2003)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 8) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 32895)) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        int n = tiffIFD.getInkSet();
        if (n != 1) {
            return false;
        }
        if (tiffIFD.getNumberOfInks() != 4) {
            return false;
        }
        if (!this.satisfiesDotRange(tiffIFD, 0, 255)) {
            return false;
        }
        int n2 = tiffIFD.getTransparencyIndicator();
        if (n2 != 0 && n2 != 1) {
            return false;
        }
        return tiffIFD.getDocumentName() == null && nisoImageMetadata.getScannerModelName() == null && tiffIFD.getPageName() == null && nisoImageMetadata.getHostComputer() == null && tiffIFD.getSite() == null;
    }
}

