/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITLWP2
extends TiffProfileClassIT {
    public TiffProfileClassITLWP2() {
        this._profileText = "TIFF/IT-LW/P2 (ISO 12639:2003)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (tiffIFD.getColorTable() == null) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray[0] != 8) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 32896)) {
            return false;
        }
        int n = tiffIFD.getInkSet();
        if (n != 1) {
            return false;
        }
        int n2 = tiffIFD.getBitsPerExtendedRunLength();
        if (n2 != 16) {
            return false;
        }
        int n3 = tiffIFD.getNumberOfInks();
        return n3 == 4 && n3 == nisoImageMetadata.getSamplesPerPixel();
    }
}

