/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLF;

public final class TiffProfileDLFGray
extends TiffProfileDLF {
    public TiffProfileDLFGray() {
        this._profileText = "DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials: grayscale and white";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 5, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1})) {
            return false;
        }
        int[] nArray = tiffIFD.getNisoImageMetadata().getBitsPerSample();
        if (nArray == null || nArray[0] != 8) {
            return false;
        }
        return this.hasMinimumResolution(tiffIFD, 300.0, 760.0);
    }
}

