/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.SeekableByteBufferChannel;
import de.schlichtherle.truezip.rof.ByteArrayReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.EnumMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@NotThreadSafe
public class ByteArrayIOEntry
implements IOEntry<ByteArrayIOEntry> {
    private final String name;
    @Nullable
    private byte[] data;
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    private int reads;
    private int writes;
    int initialCapacity;
    private static final SocketFactory FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO : SocketFactory.OIO;

    public ByteArrayIOEntry(String name) {
        this(name, 32);
    }

    public ByteArrayIOEntry(String name, int initialCapacity) {
        this.name = name;
        this.setInitialCapacity(initialCapacity);
    }

    public final void setInitialCapacity(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    @CheckForNull
    public byte[] getData() {
        return this.data;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setData(@CheckForNull byte[] data) {
        this.data = data;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public long getSize(Entry.Size type) {
        return null != this.data ? (long)this.data.length : -1L;
    }

    public int getCount(Entry.Access type) {
        return type == Entry.Access.WRITE ? this.writes : this.reads;
    }

    @Override
    public long getTime(Entry.Access type) {
        Long time = this.times.get((Object)type);
        return null != time ? time : -1L;
    }

    @Override
    public InputSocket<ByteArrayIOEntry> getInputSocket() {
        return FACTORY.newInputSocket(this);
    }

    @Override
    public OutputSocket<ByteArrayIOEntry> getOutputSocket() {
        return FACTORY.newOutputSocket(this);
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ byte[] access$502(ByteArrayIOEntry x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class DataOutputStream
    extends ByteArrayOutputStream {
        DataOutputStream() {
            super(ByteArrayIOEntry.this.initialCapacity);
        }

        @Override
        public void close() throws IOException {
            ByteArrayIOEntry.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            super.close();
            ByteArrayIOEntry.access$502(ByteArrayIOEntry.this, this.toByteArray());
        }
    }

    private class DataOutputChannel
    extends SeekableByteBufferChannel {
        DataOutputChannel() {
            super((ByteBuffer)ByteBuffer.allocate(ByteArrayIOEntry.this.initialCapacity).limit(0));
        }

        @Override
        public void close() throws IOException {
            ByteArrayIOEntry.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            super.close();
            ByteBuffer buffer = this.getByteBuffer();
            ByteArrayIOEntry.access$502(ByteArrayIOEntry.this, Arrays.copyOf(buffer.array(), buffer.limit()));
        }
    }

    private class ByteArrayOutputSocket
    extends OutputSocket<ByteArrayIOEntry> {
        private ByteArrayOutputSocket() {
        }

        @Override
        public final ByteArrayIOEntry getLocalTarget() throws IOException {
            return ByteArrayIOEntry.this;
        }

        final void count() {
            ByteArrayIOEntry.this.writes++;
        }

        @Override
        public final OutputStream newOutputStream() throws IOException {
            this.count();
            return new DataOutputStream();
        }
    }

    private final class Nio2ByteArrayOutputSocket
    extends ByteArrayOutputSocket {
        private Nio2ByteArrayOutputSocket() {
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            this.count();
            return new DataOutputChannel();
        }
    }

    private class DataInputStream
    extends ByteArrayInputStream {
        DataInputStream() {
            super(ByteArrayIOEntry.this.data);
        }

        @Override
        public void close() throws IOException {
            ByteArrayIOEntry.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            super.close();
        }
    }

    private class DataReadOnlyFile
    extends ByteArrayReadOnlyFile {
        DataReadOnlyFile() {
            super(ByteArrayIOEntry.this.data);
        }

        @Override
        public void close() throws IOException {
            ByteArrayIOEntry.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            super.close();
        }
    }

    private class DataInputChannel
    extends SeekableByteBufferChannel {
        DataInputChannel() {
            super(ByteBuffer.wrap(ByteArrayIOEntry.this.data).asReadOnlyBuffer());
        }

        @Override
        public void close() throws IOException {
            ByteArrayIOEntry.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            super.close();
        }
    }

    private class ByteArrayInputSocket
    extends InputSocket<ByteArrayIOEntry> {
        private ByteArrayInputSocket() {
        }

        @Override
        public final ByteArrayIOEntry getLocalTarget() throws IOException {
            return ByteArrayIOEntry.this;
        }

        final void count() throws FileNotFoundException {
            if (null == ByteArrayIOEntry.this.data) {
                throw new FileNotFoundException();
            }
            ByteArrayIOEntry.this.reads++;
        }

        @Override
        public final ReadOnlyFile newReadOnlyFile() throws IOException {
            this.count();
            return new DataReadOnlyFile();
        }

        @Override
        public final InputStream newInputStream() throws IOException {
            this.count();
            return new DataInputStream();
        }
    }

    private final class Nio2ByteArrayInputSocket
    extends ByteArrayInputSocket {
        private Nio2ByteArrayInputSocket() {
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            this.count();
            return new DataInputChannel();
        }
    }

    @Immutable
    private static enum SocketFactory {
        OIO{

            @Override
            InputSocket<ByteArrayIOEntry> newInputSocket(ByteArrayIOEntry entry) {
                ByteArrayIOEntry byteArrayIOEntry = entry;
                byteArrayIOEntry.getClass();
                return byteArrayIOEntry.new ByteArrayInputSocket();
            }

            @Override
            OutputSocket<ByteArrayIOEntry> newOutputSocket(ByteArrayIOEntry entry) {
                ByteArrayIOEntry byteArrayIOEntry = entry;
                byteArrayIOEntry.getClass();
                return byteArrayIOEntry.new ByteArrayOutputSocket();
            }
        }
        ,
        NIO{

            @Override
            InputSocket<ByteArrayIOEntry> newInputSocket(ByteArrayIOEntry entry) {
                ByteArrayIOEntry byteArrayIOEntry = entry;
                byteArrayIOEntry.getClass();
                return byteArrayIOEntry.new Nio2ByteArrayInputSocket();
            }

            @Override
            OutputSocket<ByteArrayIOEntry> newOutputSocket(ByteArrayIOEntry entry) {
                ByteArrayIOEntry byteArrayIOEntry = entry;
                byteArrayIOEntry.getClass();
                return byteArrayIOEntry.new Nio2ByteArrayOutputSocket();
            }
        };


        abstract InputSocket<ByteArrayIOEntry> newInputSocket(ByteArrayIOEntry var1);

        abstract OutputSocket<ByteArrayIOEntry> newOutputSocket(ByteArrayIOEntry var1);
    }
}

