/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.domesdaybook.reader.ByteReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArray;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArrays;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class GZipIdentificationRequest
implements IdentificationRequest {
    private static final int BUFFER_CACHE_CAPACITY = 16;
    private static final int CAPACITY = 32768;
    private final String extension;
    private final String fileName;
    private long size;
    private CachedBytes cachedBinary;
    private File tempFile;
    private final int bufferCapacity;
    private final int lruCapacity;
    private File tempDir;
    private RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private Log log = LogFactory.getLog(this.getClass());

    public GZipIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, File tempDir) {
        this(metaData, identifier, 16, 32768, tempDir);
    }

    GZipIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, int lruCapacity, int bufferCapacity, File tempDir) {
        this.identifier = identifier;
        String path = identifier.getUri().getSchemeSpecificPart();
        this.extension = ResourceUtils.getExtension(path);
        this.fileName = FilenameUtils.getName((String)path);
        this.bufferCapacity = bufferCapacity;
        this.lruCapacity = lruCapacity;
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public final void open(InputStream in) throws IOException {
        byte[] firstBuffer = new byte[this.bufferCapacity];
        int bytesRead = ResourceUtils.readBuffer(in, firstBuffer);
        if (bytesRead < 1) {
            firstBuffer = new byte[]{};
            this.cachedBinary = new CachedByteArray(firstBuffer, 0);
            this.size = 0L;
        } else if (bytesRead < this.bufferCapacity) {
            this.cachedBinary = new CachedByteArray(firstBuffer, bytesRead);
            this.size = bytesRead;
        } else {
            this.cachedBinary = new CachedByteArrays(this.lruCapacity, this.bufferCapacity, firstBuffer, this.bufferCapacity);
            this.tempFile = ArchiveFileUtils.writeEntryToTemp(this.tempDir, firstBuffer, in);
            this.cachedBinary.setSourceFile(this.tempFile);
            this.size = this.tempFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        block5: {
            block6: {
                try {
                    if (this.cachedBinary != null) {
                        this.cachedBinary.close();
                        this.cachedBinary = null;
                    }
                    if (this.tempFile == null) break block5;
                    if (this.tempFile.delete() || !this.tempFile.exists()) break block6;
                }
                catch (Throwable throwable) {
                    if (this.tempFile != null) {
                        if (!this.tempFile.delete() && this.tempFile.exists()) {
                            String message = String.format("Could not delete temporary file [%s] for gzip entry [%s]. Will try to delete on exit.", this.tempFile.getAbsolutePath(), this.identifier.getUri().toString());
                            this.log.warn((Object)message);
                            this.tempFile.deleteOnExit();
                        }
                        this.tempFile = null;
                    }
                    throw throwable;
                }
                String message = String.format("Could not delete temporary file [%s] for gzip entry [%s]. Will try to delete on exit.", this.tempFile.getAbsolutePath(), this.identifier.getUri().toString());
                this.log.warn((Object)message);
                this.tempFile.deleteOnExit();
            }
            this.tempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final byte getByte(long position) {
        return this.cachedBinary.readByte(position);
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    final CachedBytes getCache() {
        return this.cachedBinary;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return this.cachedBinary.getSourceInputStream();
    }

    final File getTempFile() {
        return this.tempFile;
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final ByteReader getReader() {
        return this.cachedBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final File getSourceFile() throws IOException {
        if (this.tempFile == null) {
            InputStream stream = this.cachedBinary.getSourceInputStream();
            try {
                this.tempFile = ResourceUtils.createTemporaryFileFromStream(this.tempDir, stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return this.tempFile;
    }
}

