/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.dao.ejb3;

import com.exlibris.core.infra.common.dao.GenericDao;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IndexXmlUtil;
import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class DaoServiceInterceptor {
    private static ExLogger log = ExLogger.getExLogger(DaoServiceInterceptor.class);

    @AroundInvoke
    private Object profile(InvocationContext invCtx) throws Exception {
        Object result = invCtx.proceed();
        if (result == null) {
            return null;
        }
        String resultClassName = result.getClass().getName();
        Object tagetObject = invCtx.getTarget();
        String tagetClassName = invCtx.getTarget().getClass().getName();
        Method targetMethod = invCtx.getMethod();
        log.debug((Object)"****** DaoServiceInterceptor Starts ******", new String[0]);
        log.debug((Object)("tagetClassName: " + tagetClassName), new String[0]);
        log.debug((Object)("targetMethod: " + targetMethod.getName()), new String[0]);
        log.debug((Object)("resultClassName: " + resultClassName), new String[0]);
        if (tagetObject instanceof GenericDao) {
            GenericDao genericDao = (GenericDao)tagetObject;
            this.reIndexObject(genericDao, result);
        }
        log.debug((Object)"****** DaoServiceInterceptor Ends ******", new String[0]);
        return result;
    }

    private void reIndexObject(GenericDao genericDao, Object result) {
        Method method;
        try {
            method = result.getClass().getMethod("setIndexXml", String.class);
        }
        catch (Exception e) {
            log.error("result class does not have setIndexXml(String)", e, new String[0]);
            return;
        }
        String indexXml = IndexXmlUtil.generateIndexXml(result);
        try {
            method.invoke(result, indexXml);
        }
        catch (Exception e) {
            log.error("error occurs while invoking setIndexXml(String):", e, new String[0]);
        }
        genericDao.save(result);
    }
}

