/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.exceptions.logging;

import com.exlibris.core.infra.common.exceptions.ExlibrisException;
import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;

public final class ExLogger {
    private Logger logger;
    private String module;
    private String server;
    public static final String DEPOSIT = "DEP";
    public static final String LOADING = "LD";
    public static final String JOB = "JB";
    public static final String PERMANENT = "PER";
    public static final String REPOSITORY = "RPS";
    public static final String VALIDATIONSTACK = "VS";
    public static final String ENRICHMENT = "ENR";
    public static final String STAGING = "STG";
    public static final String TASKS = "TSK";
    public static final String DELETE = "TSK";
    public static final String DELIVERY = "DLVY";
    public static final String INDEX = "RPS";
    public static final String BYTESTREAM = "BST";
    public static final String PRESERVATION = "PRSV";
    public static final String COLLECTIONS = "COL";
    public static final String PUBLISHING = "PBLS";
    public static final String ROLLBACK = "TSK";
    public static final String WS = "WS";
    private static final String RESOURCE_BUNDLE = "ExLibMessageFile.properties";
    private static final String LOG_CONFIG = "log4j_template.xml";
    private static final int MAX_BACKUP_STANDALONE_FILES = 100;
    private static final String MAX_BACKUP_STANDALONE_FILE_SIZE = "1000KB";
    private static final Priority STANDALONE_PRIORITY_LEVEL = Level.DEBUG;
    private static Map<String, ResourceBundle> resourceBundles = null;
    private static ResourceBundle m_resourceBundle = null;
    private static URL m_loggerProps = null;
    private static boolean m_initialized = false;
    private static PatternLayout m_layout = null;

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(Object message, Throwable t) {
        this.logger.trace(message, t);
    }

    public void trace(Object message) {
        this.logger.trace(message);
    }

    public synchronized void addAppender(Appender newAppender) {
        this.logger.addAppender(newAppender);
    }

    public void assertLog(boolean assertion, String msg) {
        this.logger.assertLog(assertion, msg);
    }

    public void callAppenders(LoggingEvent event) {
        this.logger.callAppenders(event);
    }

    public void debug(Object message, Throwable t, String ... identifiers) {
        this.logger.debug((Object)this.createMsg(message, identifiers), t);
    }

    public void debug(Object message, String ... identifiers) {
        this.logger.debug((Object)this.createMsg(message, identifiers));
    }

    public void error(String message, Throwable t, String ... identifiers) {
        this.error(message, identifiers);
        this.error(t);
    }

    public void error(String message, String ... identifiers) {
        this.logger.error((Object)this.createMsg(message, identifiers));
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    public boolean getAdditivity() {
        return this.logger.getAdditivity();
    }

    public synchronized Enumeration getAllAppenders() {
        return this.logger.getAllAppenders();
    }

    public synchronized Appender getAppender(String name) {
        return this.logger.getAppender(name);
    }

    public Level getEffectiveLevel() {
        return this.logger.getEffectiveLevel();
    }

    public LoggerRepository getLoggerRepository() {
        return this.logger.getLoggerRepository();
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public void info(Object message, Throwable t, String ... identifiers) {
        this.logger.info((Object)this.createMsg(message, identifiers), t);
    }

    public void info(Object message) {
        this.info(message, new String[0]);
    }

    public void info(Object message, String ... identifiers) {
        this.logger.info((Object)this.createMsg(message, identifiers));
    }

    public boolean isAttached(Appender appender) {
        return this.logger.isAttached(appender);
    }

    public boolean isEnabledFor(Priority level) {
        return this.logger.isEnabledFor(level);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        this.logger.l7dlog(priority, key, params, t);
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        this.logger.l7dlog(priority, key, t);
    }

    public void log(Priority priority, Object message, Throwable t) {
        this.logger.log(priority, message, t);
    }

    public void log(Priority priority, Object message) {
        this.logger.log(priority, message);
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.logger.log(callerFQCN, level, message, t);
    }

    public synchronized void removeAllAppenders() {
        this.logger.removeAllAppenders();
    }

    public synchronized void removeAppender(Appender appender) {
        this.logger.removeAppender(appender);
    }

    public synchronized void removeAppender(String name) {
        this.logger.removeAppender(name);
    }

    public void setAdditivity(boolean additive) {
        this.logger.setAdditivity(additive);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.logger.setResourceBundle(bundle);
    }

    public void warn(Object message, Throwable t, String ... identifiers) {
        this.logger.warn((Object)this.createMsg(message, identifiers), t);
    }

    public void warn(Object message, String ... identifiers) {
        this.logger.warn((Object)this.createMsg(message, identifiers));
    }

    protected ExLogger(Logger logger, String module) {
        this.logger = logger;
        this.module = module != null ? module : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExLogger getLogger(String name, String module) {
        Class<ExLogger> clazz = ExLogger.class;
        synchronized (ExLogger.class) {
            if (!m_initialized) {
                ExLogger.init();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new ExLogger(Logger.getLogger((String)name), module);
        }
    }

    public static ExLogger getExLogger(Class name, String module) {
        return ExLogger.getLogger(name.getName(), module);
    }

    public static ExLogger getExLogger(String name, String module) {
        return ExLogger.getLogger(name, module);
    }

    public static ExLogger getExLogger(Class name) {
        return ExLogger.getLogger(name.getName(), null);
    }

    public static ExLogger getExLogger(String name) {
        return ExLogger.getLogger(name, null);
    }

    public static ExLogger getSAExLogger(String fullPathToLog) {
        ExLogger log = ExLogger.getExLogger(fullPathToLog);
        RollingFileAppender appender = null;
        try {
            appender = new RollingFileAppender((Layout)m_layout, fullPathToLog, true);
            appender.setMaxBackupIndex(100);
            appender.setImmediateFlush(true);
            appender.setMaxFileSize(MAX_BACKUP_STANDALONE_FILE_SIZE);
            appender.setThreshold(STANDALONE_PRIORITY_LEVEL);
        }
        catch (Exception e) {
            LogLog.error((String)"unable to create appender for SA logger: ");
            e.printStackTrace(new PrintStream(System.out));
        }
        log.addAppender((Appender)appender);
        log.setAdditivity(false);
        return log;
    }

    private static void init() {
        try {
            LogLog.debug((String)"Logger is initializing....");
            ExLogger.initResourceBundles();
            m_resourceBundle = new PropertyResourceBundle(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_BUNDLE));
            if (!ExLogger.isConfigured()) {
                m_loggerProps = Thread.currentThread().getContextClassLoader().getResource(LOG_CONFIG);
                DOMConfigurator.configure((URL)m_loggerProps);
            }
            m_layout = new PatternLayout();
            m_layout.setConversionPattern("%d{ISO8601} %-5p %m%n");
            m_initialized = true;
            LogLog.debug((String)"Logger initialized successfully.");
        }
        catch (Exception e) {
            LogLog.debug((String)"Logger failed to initialize from resource bundle file.");
            return;
        }
    }

    private static boolean isConfigured() {
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            return true;
        }
        Enumeration cats = LogManager.getCurrentLoggers();
        while (cats.hasMoreElements()) {
            Category c = (Category)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    public void finalize() {
        Enumeration enumeration = this.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            ((Appender)enumeration.nextElement()).close();
        }
        this.terminate();
    }

    private void terminate() {
        LogLog.error((String)"Logger terminating.");
    }

    public void handledException(Throwable t) {
        this.log(DescriptorConstants.LG_ExceptionHandled, (Object)t.getMessage(), t.getClass().getName());
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void log(Descriptor desc) {
        this.log(desc, null, null, null, null, null);
    }

    public void log(Descriptor desc, Object o1) {
        this.log(desc, o1, null, null, null, null);
    }

    public void log(Descriptor desc, Object o1, Object o2) {
        this.log(desc, o1, o2, null, null, null);
    }

    public void log(Descriptor desc, Object o1, Object o2, Object o3) {
        this.log(desc, o1, o2, o3, null, null);
    }

    public void log(Descriptor desc, Object o1, Object o2, Object o3, Object o4) {
        this.log(desc, o1, o2, o3, o4, null);
    }

    public void warn(Descriptor desc) {
        this.warn(desc, null, null, null, null, null);
    }

    public void warn(Descriptor desc, Object o1) {
        this.warn(desc, o1, null, null, null, null);
    }

    public void warn(Descriptor desc, Object o1, Object o2) {
        this.warn(desc, o1, o2, null, null, null);
    }

    public void warn(Descriptor desc, Object o1, Object o2, Object o3) {
        this.warn(desc, o1, o2, o3, null, null);
    }

    public void warn(Descriptor desc, Object o1, Object o2, Object o3, Object o4) {
        this.warn(desc, o1, o2, o3, o4, null);
    }

    public void error(Throwable e) {
        if (e != null && e.getStackTrace() != null && e.getStackTrace().length > 0) {
            this.error(ExceptionUtils.getFullStackTrace((Throwable)e), new String[0]);
        }
    }

    public void error(String message, Exception e, String ... identifiers) {
        this.error(message, identifiers);
        this.error(e);
    }

    public void error(Descriptor desc) {
        this.error(desc, null, null, null, null, null);
    }

    public void error(Descriptor desc, Object o1) {
        this.error(desc, o1, null, null, null, null);
    }

    public void error(Descriptor desc, Object o1, Object o2) {
        this.error(desc, o1, o2, null, null, null);
    }

    public void error(Descriptor desc, Object o1, Object o2, Object o3) {
        this.error(desc, o1, o2, o3, null, null);
    }

    public void error(Descriptor desc, Object o1, Object o2, Object o3, Object o4) {
        this.error(desc, o1, o2, o3, o4, null);
    }

    public void info(Descriptor desc) {
        this.info(desc, null, null, null, null, null);
    }

    public void info(Descriptor desc, Object o1) {
        this.info(desc, o1, null, null, null, null);
    }

    public void info(Descriptor desc, Object o1, Object o2) {
        this.info(desc, o1, o2, null, null, null);
    }

    public void info(Descriptor desc, Object o1, Object o2, Object o3) {
        this.info(desc, o1, o2, o3, null, null);
    }

    public void info(Descriptor desc, Object o1, Object o2, Object o3, Object o4) {
        this.info(desc, o1, o2, o3, o4, null);
    }

    public void warn(Descriptor desc, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.log(desc, o1, o2, o3, o4, o5, Level.WARN);
    }

    public void error(Descriptor desc, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.log(desc, o1, o2, o3, o4, o5, Level.ERROR);
    }

    public void info(Descriptor desc, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.log(desc, o1, o2, o3, o4, o5, Level.INFO);
    }

    public void log(Descriptor desc, Object o1, Object o2, Object o3, Object o4, Object o5, Level p) {
        Throwable cause = null;
        if (o5 != null) {
            if (Throwable.class.isAssignableFrom(o5.getClass())) {
                cause = (Throwable)o5;
                o5 = null;
            }
        } else if (o4 != null) {
            if (Throwable.class.isAssignableFrom(o4.getClass())) {
                cause = (Throwable)o4;
                o4 = null;
            }
        } else if (o3 != null) {
            if (Throwable.class.isAssignableFrom(o3.getClass())) {
                cause = (Throwable)o3;
                o3 = null;
            }
        } else if (o2 != null) {
            if (Throwable.class.isAssignableFrom(o2.getClass())) {
                cause = (Throwable)o2;
                o2 = null;
            }
        } else if (o1 != null && Throwable.class.isAssignableFrom(o1.getClass())) {
            cause = (Throwable)o1;
            o1 = null;
        }
        Object[] context = new Object[]{o1 != null ? o1 : "", o2 != null ? o2 : "", o3 != null ? o3 : "", o4 != null ? o4 : "", o5 != null ? o5 : ""};
        this.log(desc, context, cause, p);
    }

    public void log(Descriptor desc, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.log(desc, o1, o2, o3, o4, o5, null);
    }

    private void log(Descriptor desc, Object[] context, Throwable t, Level l) {
        if (null == desc) {
            LogLog.error((String)"An attempt was made to log with a null descriptor. Ignoring.");
            return;
        }
        Level level = null;
        String message = ExLogger.getMessageFromRB(desc.getId());
        level = l == null ? Level.toLevel((String)desc.getType()) : l;
        if (level.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            try {
                message = ExLogger.formatMessage(message, context);
            }
            catch (IllegalArgumentException il) {
                il.printStackTrace();
            }
            try {
                this.logger.log((Priority)level, (Object)message, t);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getMessageFromRB(long id) {
        String msg = "Error " + id;
        try {
            msg = m_resourceBundle.getString(String.valueOf(id));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    public static String getMessageFromRB(long id, String locale) {
        String msg = "Error " + id;
        try {
            if (resourceBundles == null) {
                ExLogger.initResourceBundles();
            }
            if ((msg = resourceBundles.get(locale).getString(String.valueOf(id))) == null) {
                msg = m_resourceBundle.getString(String.valueOf(id));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return msg;
    }

    public static String getLocalizedMessage(ExlibrisException ee, String locale) {
        String message = null;
        try {
            if (resourceBundles == null) {
                ExLogger.initResourceBundles();
            }
            if ((message = (String)resourceBundles.get(locale).getObject(String.valueOf(ee.getDescriptor().getId()))) == null) {
                message = (String)m_resourceBundle.getObject(String.valueOf(ee.getDescriptor().getId()));
            }
        }
        catch (Exception e) {
            return ee.getMessage();
        }
        if (message == null) {
            return ee.getMessage();
        }
        return MessageFormat.format(message, ee.getContext());
    }

    public static String formatMessage(String message, Object[] params) throws IllegalArgumentException {
        return MessageFormat.format(message, params);
    }

    public void log(Descriptor desc, Object[] context, Throwable t) {
        this.log(desc, context, t, null);
    }

    public void log(ExlibrisException s2ex) {
        for (Throwable t = s2ex.getCause(); t != null && t instanceof ExlibrisException; t = t.getCause()) {
            ExlibrisException cause = (ExlibrisException)t;
            if (cause.getDescriptor().equals(s2ex.getDescriptor())) continue;
            this.log(cause);
            break;
        }
    }

    private String createMsg(Object message, String ... identifiers) {
        if (this.server == null) {
            this.server = GlobalProperties.getInstance().getProperty("server.name");
        }
        String newMsg = "";
        if (!this.module.equals("")) {
            newMsg = " | " + this.module + "-" + this.server + " | ";
        }
        for (String id : identifiers) {
            try {
                Integer.parseInt(id);
                newMsg = newMsg + this.module + "SIP" + id + " | ";
            }
            catch (Exception e) {
                newMsg = newMsg + this.module + id + " | ";
            }
        }
        return newMsg + message;
    }

    private static void initResourceBundles() throws IOException {
        resourceBundles = new HashMap<String, ResourceBundle>();
        String path = Thread.currentThread().getContextClassLoader().getResource(RESOURCE_BUNDLE).getPath();
        String folder = path.substring(0, path.indexOf(RESOURCE_BUNDLE));
        File dir = new File(folder);
        String[] children = dir.list();
        String[] parsedBundle = RESOURCE_BUNDLE.split("\\.");
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null || !children[i].startsWith(parsedBundle[0])) continue;
                if (children[i].equals(RESOURCE_BUNDLE)) {
                    resourceBundles.put("en", new PropertyResourceBundle(Thread.currentThread().getContextClassLoader().getResourceAsStream(children[i])));
                    continue;
                }
                if (!children[i].contains(parsedBundle[0] + "_")) continue;
                resourceBundles.put(children[i].substring(children[i].indexOf("_") + 1, children[i].indexOf(".")), new PropertyResourceBundle(Thread.currentThread().getContextClassLoader().getResourceAsStream(children[i])));
            }
        }
    }
}

