/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxAugmenterSharedMD
extends DefaultHandler {
    private static final String POLICY_ID_VAL = "policyId";
    private static final String CMS_FORMAT = "<mets:dmdSec ID=\"cms-dmd\"><mets:mdWrap MDTYPE=\"DC\"><mets:xmlData>%s</mets:xmlData></mets:mdWrap></mets:dmdSec>";
    private static final String AR_FORMAT = "<section id=\"grantedRightsStatement\"><record><key id=\"grantedRightsStatementIdentifier\">%s</key><key id=\"grantedRightsStatementValue\"><![CDATA[%s]]></key></record></section>";
    private static final String METS_TOP_ELEMENT = "mets:mets";
    private StringBuilder augmentedDocument = null;
    private StringBuilder characters = new StringBuilder();
    private boolean currElementEmpty = false;
    private static final String INDENTATION_CHAR = " ";
    private static final int INDENTATION_DIFF = 2;
    private int currIndentation = -2;
    private boolean hasSubElements = false;
    private static final String ID_ATTR = "id";
    private static final String SECTION_TAG = "section";
    private static final String KEY_TAG = "key";
    private static final String AR_POLICY_VAL = "accessRightsPolicy";
    private String cmsData;
    private Map<String, String> sharedMDs;
    private boolean isUnderMets = false;
    private boolean isUnderAccessRights = false;
    private boolean isUnderAccessRightsID = false;
    private String accessRightsID = null;

    public SaxAugmenterSharedMD(int origXmlSize, String cmsData, Map<String, String> sharedMDs) {
        this.augmentedDocument = new StringBuilder((int)((double)origXmlSize * 1.2));
        this.cmsData = cmsData;
        this.sharedMDs = sharedMDs;
    }

    public String getAugmented() {
        return this.augmentedDocument.substring(1);
    }

    private void appendCurrentText() {
        if (this.isUnderAccessRightsID) {
            this.accessRightsID = this.characters.toString().trim();
            this.isUnderAccessRightsID = false;
        }
        this.augmentedDocument.append(this.characters.toString().trim());
        this.characters.setLength(0);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currElementEmpty = true;
        this.hasSubElements = false;
        if (this.isUnderMets) {
            if (!StringUtils.isBlank((String)this.cmsData)) {
                this.augmentedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append(String.format(CMS_FORMAT, this.cmsData));
            }
            this.isUnderMets = false;
        }
        if (METS_TOP_ELEMENT.equals(qName)) {
            this.isUnderMets = true;
        }
        boolean isAccessRights = false;
        boolean isAccessRightsID = false;
        this.appendCurrentText();
        this.currIndentation += 2;
        this.augmentedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.augmentedDocument.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && AR_POLICY_VAL.equals(attributes.getValue(i))) {
                    isAccessRights = true;
                    continue;
                }
                if (!ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) || !POLICY_ID_VAL.equals(attributes.getValue(i))) continue;
                isAccessRightsID = true;
            }
        }
        this.augmentedDocument.append(">");
        if (SECTION_TAG.equals(qName) && isAccessRights) {
            this.isUnderAccessRights = true;
        } else if (KEY_TAG.equals(qName) && isAccessRightsID) {
            this.isUnderAccessRightsID = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.appendCurrentText();
        if (this.currElementEmpty) {
            this.augmentedDocument.setLength(this.augmentedDocument.length() - 1);
            this.augmentedDocument.append("/>");
        } else {
            if (this.hasSubElements) {
                this.augmentedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation));
            }
            this.augmentedDocument.append("</" + qName + '>');
        }
        if (this.isUnderAccessRights && SECTION_TAG.equals(qName)) {
            if (this.sharedMDs != null && this.sharedMDs.containsKey(this.accessRightsID)) {
                this.augmentedDocument.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append(String.format(AR_FORMAT, this.accessRightsID, this.sharedMDs.get(this.accessRightsID)));
            }
            this.accessRightsID = null;
        }
        this.currIndentation -= 2;
        this.currElementEmpty = false;
        this.hasSubElements = true;
        this.isUnderAccessRights &= !SECTION_TAG.equals(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
        if (this.characters.toString().trim().length() > 0) {
            this.currElementEmpty = false;
        }
    }
}

