/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.security;

import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import java.security.Principal;
import java.util.List;

public class UserPrincipal
implements Principal {
    private String name;
    private String userName;
    private String displayName;
    private String institutionPath;
    private HFrUser userDetails;
    private String sessionId;
    private String pdsHandle;
    private String institutionCode;

    public UserPrincipal(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object another) {
        Principal p = (Principal)another;
        return this.name.equals(p.getName());
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public HFrUser getUserDetails() {
        return this.userDetails;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getInstitutionPath() {
        return this.institutionPath;
    }

    public void setInstitutionPath(String institutionPath) {
        this.institutionPath = institutionPath;
    }

    public void setUserDetails(HFrUser userDetails) {
        this.userDetails = userDetails;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getPdsHandle() {
        return this.pdsHandle;
    }

    public void setPdsHandle(String pdsHandle) {
        this.pdsHandle = pdsHandle;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }

    public boolean isInScope(String scope) {
        String userRolesScope = null;
        if (scope != null) {
            if (this.userDetails != null) {
                List<HFrUserRoles> userRoles = this.userDetails.getUserRoles();
                if (userRoles != null && userRoles.size() > 0) {
                    for (HFrUserRoles roles : userRoles) {
                        userRolesScope = roles.getScope();
                        if (userRolesScope == null || !scope.startsWith(userRolesScope)) continue;
                        return true;
                    }
                }
            } else {
                return false;
            }
        }
        return false;
    }
}

